/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.texteval;

import bluej.Config;
import bluej.debugmgr.texteval.TextEvalPane;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.prefmgr.PrefMgr;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JScrollPane;

public final class TextEvalArea
extends JScrollPane
implements KeyListener,
FocusListener {
    private static final Color selectionColour = Config.getSelectionColour();
    private TextEvalPane text;
    private boolean frameEmpty;

    public TextEvalArea(PkgMgrFrame frame, Font font) {
        this.createComponent(frame, font);
        this.frameEmpty = frame.isEmptyFrame();
    }

    @Override
    public void requestFocus() {
        this.text.requestFocus();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.text.setEnabled(enabled);
    }

    public void clear() {
        this.text.clear();
        this.text.clearVars();
    }

    public void resetFontSize() {
        Font codepadFont;
        int fontsize = this.getFontSize();
        if (fontsize != 0 && (codepadFont = this.text.getFont()).getSize() != fontsize) {
            this.text.setFont(codepadFont.deriveFont((float)fontsize));
        }
    }

    private int getFontSize() {
        int fontsize = Config.getPropInteger("bluej.codepad.fontsize", 0);
        if (fontsize == 0) {
            fontsize = PrefMgr.getEditorFontSize();
        }
        return fontsize;
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (!e.isTemporary()) {
            this.setBorder(Config.focusBorder);
            this.repaint();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.setBorder(Config.normalBorder);
        this.repaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        char ch = e.getKeyChar();
        int DEL = 127;
        if (ch == '\b' || ch == '\t' || ch == '\u007f') {
            e.consume();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private void createComponent(PkgMgrFrame frame, Font font) {
        this.text = new TextEvalPane(frame);
        this.text.setMargin(new Insets(2, 2, 2, 2));
        this.text.addKeyListener(this);
        this.text.addFocusListener(this);
        int fontSize = this.getFontSize();
        if (fontSize != 0) {
            font = font.deriveFont((float)fontSize);
        }
        this.text.setFont(font);
        this.text.setSelectionColor(selectionColour);
        this.text.setOpaque(false);
        this.text.setBackground(new Color(0, 0, 0, 0));
        this.setViewportView(this.text);
        this.updateBackground(frame.isEmptyFrame());
        this.setVerticalScrollBarPolicy(22);
        this.setPreferredSize(new Dimension(300, 100));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (g instanceof Graphics2D && !this.frameEmpty) {
            Graphics2D g2d = (Graphics2D)g;
            int w = this.getWidth();
            int h = this.getHeight();
            GradientPaint gp = new GradientPaint(w / 4, 0.0f, new Color(235, 230, 200), w, h, new Color(209, 203, 179));
            g2d.setPaint(gp);
            g2d.fillRect(1, 1, w - 2, h - 2);
        }
    }

    public void updateBackground(boolean frameEmpty) {
        this.frameEmpty = frameEmpty;
        this.getViewport().setOpaque(frameEmpty);
        this.setOpaque(frameEmpty);
    }
}

