/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.inspector;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.debugger.DebuggerField;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.JavaType;
import bluej.debugmgr.ExpressionInformation;
import bluej.debugmgr.inspector.AssertPanel;
import bluej.debugmgr.inspector.FieldInfo;
import bluej.debugmgr.inspector.Inspector;
import bluej.debugmgr.inspector.InspectorManager;
import bluej.pkgmgr.Package;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.Debug;
import bluej.utility.JavaUtils;
import bluej.utility.MultiLineLabel;
import bluej.views.Comment;
import bluej.views.LabelPrintWriter;
import bluej.views.MethodView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class ResultInspector
extends Inspector {
    protected static final String resultTitle = Config.getString("debugger.inspector.result.title");
    protected static final String returnedString = Config.getString("debugger.inspector.result.returned");
    protected DebuggerObject obj;
    protected String objName;
    private ExpressionInformation expressionInformation;
    private JavaType resultType;

    public ResultInspector(DebuggerObject obj, InspectorManager inspectorManager, String name, Package pkg, InvokerRecord ir, ExpressionInformation info) {
        super(inspectorManager, pkg, ir, new Color(226, 224, 220));
        this.expressionInformation = info;
        this.obj = obj;
        this.objName = name;
        this.calcResultType();
        this.makeFrame();
        this.update();
        this.updateLayout();
    }

    private void calcResultType() {
        GenTypeClass instanceType = this.expressionInformation.getInstanceType();
        MethodView methodView = (MethodView)this.expressionInformation.getMethodView();
        Method m = methodView.getMethod();
        JavaType methodReturnType = methodView.getGenericReturnType();
        if (methodReturnType instanceof GenTypeParameter) {
            Map<Object, Object> tparmap = instanceType != null ? instanceType.mapToSuper(m.getDeclaringClass().getName()).getMap() : new HashMap();
            if (tparmap == null) {
                this.resultType = JavaUtils.getJavaUtils().getRawReturnType(m);
                return;
            }
            List<GenTypeDeclTpar> tpars = JavaUtils.getJavaUtils().getTypeParams(m);
            if (tparmap != null) {
                tparmap.putAll(JavaUtils.TParamsToMap(tpars));
            }
            methodReturnType = methodReturnType.mapTparsToTypes(tparmap).getUpperBound();
        }
        this.resultType = methodReturnType;
    }

    @Override
    protected List<FieldInfo> getListData() {
        DebuggerObject resultObject;
        DebuggerField resultField = this.obj.getField(0);
        String fieldString = !this.resultType.isPrimitive() ? (!(resultObject = resultField.getValueObject(this.resultType)).isNullObject() ? resultObject.getGenType().toString(true) : this.resultType.toString(true)) : resultField.getType().toString(true);
        ArrayList<FieldInfo> rlist = new ArrayList<FieldInfo>(1);
        rlist.add(new FieldInfo(fieldString, resultField.getValueString()));
        return rlist;
    }

    protected void makeFrame() {
        this.setTitle(resultTitle);
        JPanel header = new JPanel();
        header.setOpaque(false);
        header.setLayout(new BoxLayout(header, 1));
        Comment comment = this.expressionInformation.getComment();
        LabelPrintWriter commentLabelPrintWriter = new LabelPrintWriter();
        comment.print(commentLabelPrintWriter);
        MultiLineLabel commentLabel = commentLabelPrintWriter.getLabel();
        commentLabel.setOpaque(false);
        header.add(commentLabel);
        JLabel sig = new JLabel(this.expressionInformation.getSignature());
        sig.setForeground(Color.BLACK);
        header.add(sig);
        header.add(Box.createVerticalStrut(5));
        JSeparator sep = new JSeparator();
        sep.setForeground(new Color(191, 190, 187));
        sep.setBackground(new Color(0, 0, 0, 0));
        header.add(sep);
        JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
        mainPanel.setOpaque(false);
        Box result = Box.createVerticalBox();
        result.setOpaque(false);
        final JLabel expression = new JLabel(this.expressionInformation.getExpression(), 2);
        expression.setAlignmentX(0.0f);
        JPopupMenu copyPopup = new JPopupMenu();
        copyPopup.add(new AbstractAction(Config.getString("editor.copyLabel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    StringSelection ss = new StringSelection(expression.getText());
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
                }
                catch (IllegalStateException ise) {
                    Debug.log("Copy: clipboard unavailable.");
                }
            }
        });
        expression.setComponentPopupMenu(copyPopup);
        result.add(expression);
        result.add(Box.createVerticalStrut(5));
        JLabel returnedLabel = new JLabel("  " + returnedString, 10);
        returnedLabel.setAlignmentX(0.0f);
        result.add(returnedLabel);
        result.add(Box.createVerticalStrut(5));
        JScrollPane scrollPane = this.createFieldListScrollPane();
        scrollPane.setAlignmentX(0.0f);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        result.add(scrollPane);
        result.add(Box.createVerticalStrut(5));
        Box resultPanel = new Box(1){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g;
                int width = this.getWidth();
                int height = this.getHeight();
                g2d.setPaint(new GradientPaint(width / 4, 0.0f, new Color(236, 235, 234), width * 3 / 4, height, new Color(220, 218, 214)));
                g2d.fillRect(0, 0, width, height);
            }
        };
        result.setAlignmentX(0.5f);
        result.setAlignmentY(0.0f);
        resultPanel.add(result);
        Border lineBorder = BorderFactory.createLineBorder(new Color(101, 101, 101), 1);
        Border emptyBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        CompoundBorder resultPanelBorder = BorderFactory.createCompoundBorder(lineBorder, emptyBorder);
        resultPanel.setBorder(resultPanelBorder);
        mainPanel.add((Component)resultPanel, "Center");
        JPanel inspectAndGetButtons = this.createInspectAndGetButtons();
        mainPanel.add((Component)inspectAndGetButtons, "East");
        Insets insets = BlueJTheme.generalBorderWithStatusBar.getBorderInsets(mainPanel);
        mainPanel.setBorder(new EmptyBorder(insets));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setOpaque(false);
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        if (this.inspectorManager != null && this.inspectorManager.inTestMode()) {
            this.assertPanel = new AssertPanel();
            this.assertPanel.setAlignmentX(0.0f);
            this.assertPanel.setResultType(this.resultType);
            bottomPanel.add(this.assertPanel);
        }
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setOpaque(false);
        JButton button = this.createCloseButton();
        buttonPanel.add((Component)button, "East");
        bottomPanel.add(buttonPanel);
        JPanel contentPane = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g;
                int width = this.getWidth();
                int height = this.getHeight();
                g2d.setPaint(new GradientPaint(width / 4, 0.0f, new Color(230, 229, 228), width * 3 / 4, height, new Color(191, 186, 178)));
                g2d.fillRect(0, 0, width, height);
            }
        };
        this.setContentPane(contentPane);
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)header, "North");
        contentPane.add((Component)mainPanel, "Center");
        contentPane.add((Component)bottomPanel, "South");
        this.getRootPane().setDefaultButton(button);
    }

    @Override
    protected void listElementSelected(int slot) {
        DebuggerField field = this.obj.getInstanceField(0);
        if (field.isReferenceType() && !field.isNull()) {
            this.setCurrentObj(field.getValueObject(this.resultType), null, this.resultType.toString(false));
            this.setButtonsEnabled(true, true);
        } else {
            this.setCurrentObj(null, null, null);
            this.setButtonsEnabled(false, false);
        }
    }

    @Override
    protected void doInspect() {
        if (this.selectedField != null) {
            boolean isPublic = this.getButton.isEnabled();
            this.inspectorManager.getInspectorInstance(this.selectedField, this.selectedFieldName, this.pkg, isPublic ? this.ir : null, this);
        }
    }

    @Override
    protected void remove() {
        if (this.inspectorManager != null) {
            this.inspectorManager.removeInspector(this.obj);
        }
    }

    public String getResult() {
        DebuggerField resultField = this.obj.getField(0);
        String result = resultField.getType() + " " + resultField.getName() + " = " + resultField.getValueString();
        return result;
    }

    @Override
    protected int getPreferredRows() {
        return 2;
    }

    @Override
    protected void doGet() {
        if (this.selectedField != null) {
            this.pkg.getEditor().raisePutOnBenchEvent(this, this.selectedField, this.resultType.asClass(), this.ir);
        }
    }
}

