/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.inspector;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.debugger.DebuggerField;
import bluej.debugger.DebuggerObject;
import bluej.debugmgr.inspector.AssertPanel;
import bluej.debugmgr.inspector.FieldInfo;
import bluej.debugmgr.inspector.FieldList;
import bluej.debugmgr.inspector.InspectorManager;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageEditor;
import bluej.testmgr.record.GetInvokerRecord;
import bluej.testmgr.record.InvokerRecord;
import bluej.testmgr.record.ObjectInspectInvokerRecord;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class Inspector
extends JFrame
implements ListSelectionListener {
    protected static final String showClassLabel = Config.getString("debugger.inspector.showClass");
    protected static final String inspectLabel = Config.getString("debugger.inspector.inspect");
    protected static final String getLabel = Config.getString("debugger.inspector.get");
    protected static final String close = Config.getString("close");
    protected JScrollPane fieldListScrollPane = null;
    protected FieldList fieldList = null;
    private Color fieldListBackgroundColor;
    protected JButton inspectButton;
    protected JButton getButton;
    protected AssertPanel assertPanel;
    protected DebuggerObject selectedField;
    protected String selectedFieldName;
    protected String selectedFieldType;
    protected InvokerRecord selectedInvokerRecord;
    protected Package pkg;
    protected InspectorManager inspectorManager;
    protected InvokerRecord ir;
    protected Point initialClick;
    private static AtomicInteger nextUniqueId = new AtomicInteger(1);
    private final int uniqueId;
    private static final int MIN_LIST_WIDTH = 150;
    private static final int MAX_LIST_WIDTH = 400;

    public static String fieldToString(DebuggerField field) {
        int mods = field.getModifiers();
        String result = "";
        if (Modifier.isPrivate(mods)) {
            result = "private ";
        } else if (Modifier.isPublic(mods)) {
            result = "public ";
        } else if (Modifier.isProtected(mods)) {
            result = "protected ";
        }
        if (field.isHidden()) {
            result = result + "(hidden) ";
        }
        result = result + field.getType().toString(true);
        result = result + " " + field.getName();
        return result;
    }

    protected Inspector(InspectorManager inspectorManager, Package pkg, InvokerRecord ir, Color valueFieldColor) {
        super(Config.isLinux() ? null : AWTUtilitiesWrapper.getBestGC());
        if (inspectorManager == null) {
            throw new NullPointerException("An inspector must have an InspectorManager.");
        }
        Image icon = BlueJTheme.getIconImage();
        if (icon != null) {
            this.setIconImage(icon);
        }
        if (pkg == null && ir != null) {
            ir = null;
        }
        this.inspectorManager = inspectorManager;
        this.pkg = pkg;
        this.ir = ir;
        this.uniqueId = nextUniqueId.incrementAndGet();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent E) {
                Inspector.this.doClose(true);
            }
        });
        this.fieldListBackgroundColor = valueFieldColor;
        this.initFieldList();
    }

    @Override
    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Inspector.this.doClose(true);
            }
        };
        JRootPane rootPane = super.createRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }

    private void initFieldList() {
        this.fieldList = new FieldList(400, this.fieldListBackgroundColor);
        this.fieldList.setBackground(this.getBackground());
        this.fieldList.setOpaque(true);
        this.fieldList.setSelectionBackground(Config.getSelectionColour());
        this.fieldList.getSelectionModel().addListSelectionListener(this);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Inspector.this.doInspect();
                }
            }
        };
        this.fieldList.addMouseListener(mouseListener);
        this.fieldList.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n' || e.getKeyChar() == '\u001b') {
                    Inspector.this.doClose(true);
                    e.consume();
                }
            }
        });
    }

    protected boolean isGetEnabled() {
        return this.ir != null;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fieldList.requestFocus();
        }
    }

    public void bringToFront() {
        this.setState(0);
        this.toFront();
    }

    protected abstract List<FieldInfo> getListData();

    protected abstract void listElementSelected(int var1);

    protected abstract void remove();

    protected abstract int getPreferredRows();

    public void update() {
        int slot;
        List<FieldInfo> listData = this.getListData();
        this.fieldList.setData(listData);
        this.fieldList.setTableHeader(null);
        if (this.fieldList.getSelectedRow() == -1 && listData.size() > 0) {
            this.fieldList.setRowSelectionInterval(0, 0);
        }
        if ((slot = this.fieldList.getSelectedRow()) != -1) {
            this.listElementSelected(slot);
        }
        this.repaint();
    }

    public void updateLayout() {
        this.recalculateFieldlistSize();
        if (this.fieldListScrollPane != null) {
            this.fieldListScrollPane.setPreferredSize(null);
            Dimension d = this.fieldListScrollPane.getPreferredSize();
            this.fieldListScrollPane.setMaximumSize(d);
            d = new Dimension(d);
            d.width = Math.min(d.width, 400);
            this.fieldListScrollPane.setPreferredSize(d);
        }
        this.pack();
        this.repaint();
    }

    protected void recalculateFieldlistSize() {
        List<FieldInfo> listData = this.getListData();
        int height = this.fieldList.getPreferredSize().height;
        int rows = listData.size();
        int scrollBarWidth = 0;
        if (rows > this.getPreferredRows()) {
            height = this.fieldList.getRowHeight() * this.getPreferredRows();
            scrollBarWidth = 32;
        }
        int width = this.fieldList.getPreferredSize().width;
        width = Math.max(width, 150);
        this.fieldList.setPreferredScrollableViewportSize(new Dimension(width + scrollBarWidth, height));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int slot = this.fieldList.getSelectedRow();
        if (slot == -1) {
            return;
        }
        this.listElementSelected(slot);
    }

    protected void setCurrentObj(DebuggerObject object, String name, String type) {
        this.selectedField = object;
        this.selectedFieldName = name;
        this.selectedFieldType = type;
    }

    protected void setButtonsEnabled(boolean inspect, boolean get) {
        this.inspectButton.setEnabled(inspect);
        this.getButton.setEnabled(get && this.isGetEnabled());
    }

    protected void doInspect() {
        if (this.selectedField != null) {
            boolean isPublic = this.getButton.isEnabled();
            ObjectInspectInvokerRecord newIr = new ObjectInspectInvokerRecord(this.selectedFieldName, this.ir);
            this.inspectorManager.getInspectorInstance(this.selectedField, this.selectedFieldName, this.pkg, isPublic ? newIr : null, this);
        }
    }

    protected void doGet() {
        if (this.selectedField != null) {
            GetInvokerRecord getIr = new GetInvokerRecord(this.selectedFieldType, this.selectedFieldName, this.ir);
            PackageEditor pkgEd = this.pkg.getEditor();
            pkgEd.recordInteraction(getIr);
            pkgEd.raisePutOnBenchEvent(this, this.selectedField, this.selectedField.getGenType(), getIr);
        }
    }

    public void doClose(boolean handleAssertions) {
        boolean closeOk = true;
        if (handleAssertions) {
            closeOk = this.handleAssertions();
        }
        if (closeOk) {
            this.setVisible(false);
            this.remove();
            this.dispose();
        }
    }

    protected boolean handleAssertions() {
        if (this.assertPanel != null && this.assertPanel.isAssertEnabled()) {
            int choice;
            if (!this.assertPanel.isAssertComplete() && (choice = DialogManager.askQuestion(this, "empty-assertion-text")) == 0) {
                return false;
            }
            this.ir.addAssertion(this.assertPanel.getAssertStatement());
        }
        return true;
    }

    protected JButton createCloseButton() {
        JButton button = new JButton(close);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Inspector.this.doClose(true);
            }
        });
        return button;
    }

    protected JPanel createInspectAndGetButtons() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setOpaque(false);
        buttonPanel.setDoubleBuffered(false);
        buttonPanel.setLayout(new GridLayout(0, 1));
        this.inspectButton = new JButton(inspectLabel);
        this.inspectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Inspector.this.doInspect();
            }
        });
        this.inspectButton.setEnabled(false);
        buttonPanel.add(this.inspectButton);
        this.getButton = new JButton(getLabel);
        this.getButton.setEnabled(false);
        this.getButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Inspector.this.doGet();
            }
        });
        buttonPanel.add(this.getButton);
        JPanel buttonFramePanel = new JPanel();
        buttonFramePanel.setOpaque(false);
        buttonFramePanel.setDoubleBuffered(false);
        buttonFramePanel.setLayout(new BorderLayout(0, 0));
        buttonFramePanel.add((Component)buttonPanel, "North");
        return buttonFramePanel;
    }

    protected JScrollPane createFieldListScrollPane() {
        this.fieldListScrollPane = new JScrollPane(this.fieldList);
        this.fieldListScrollPane.setBorder(BorderFactory.createLineBorder(this.fieldListBackgroundColor, 10));
        this.fieldListScrollPane.getViewport().setBackground(this.fieldListBackgroundColor);
        return this.fieldListScrollPane;
    }

    protected void installListenersForMoveDrag() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Inspector.this.initialClick = e.getPoint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Inspector.this.initialClick = null;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (Inspector.this.initialClick == null) {
                    Inspector.this.initialClick = e.getPoint();
                    return;
                }
                int newXPos = e.getXOnScreen() - Inspector.this.initialClick.x;
                int newYPos = e.getYOnScreen() - Inspector.this.initialClick.y;
                Inspector.this.setLocation(newXPos, newYPos);
            }
        });
    }

    protected void setWindowOpaque(boolean b) {
        AWTUtilitiesWrapper.setWindowOpaque(this, b);
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    private static class AWTUtilitiesWrapper {
        private static Class<?> awtUtilitiesClass;
        private static Class<?> translucencyClass;
        private static Method mIsTranslucencyCapable;
        private static Method mSetWindowOpaque;

        private AWTUtilitiesWrapper() {
        }

        static void init() {
            try {
                ?[] kinds;
                awtUtilitiesClass = Class.forName("com.sun.awt.AWTUtilities");
                translucencyClass = Class.forName("com.sun.awt.AWTUtilities$Translucency");
                if (!translucencyClass.isEnum() || (kinds = translucencyClass.getEnumConstants()) != null) {
                    // empty if block
                }
                mIsTranslucencyCapable = awtUtilitiesClass.getMethod("isTranslucencyCapable", GraphicsConfiguration.class);
                mSetWindowOpaque = awtUtilitiesClass.getMethod("setWindowOpaque", Window.class, Boolean.TYPE);
            }
            catch (ClassNotFoundException cnfe) {
                Debug.log("Sun AWT translucency classes not available (ClassNotFoundException).");
            }
            catch (Exception ex) {
                Debug.reportError("Couldn't support AWTUtilities", ex);
            }
        }

        private static boolean isSupported(Method method, Object kind) {
            if (awtUtilitiesClass == null || method == null) {
                return false;
            }
            try {
                Object ret = method.invoke(null, kind);
                if (ret instanceof Boolean) {
                    return (Boolean)ret;
                }
            }
            catch (Exception ex) {
                Debug.reportError("Couldn't support AWTUtilities", ex);
            }
            return false;
        }

        public static boolean isTranslucencyCapable(GraphicsConfiguration gc) {
            return AWTUtilitiesWrapper.isSupported(mIsTranslucencyCapable, gc);
        }

        private static void set(Method method, Window window, Object value) {
            if (awtUtilitiesClass == null || method == null || !AWTUtilitiesWrapper.isTranslucencyCapable(window.getGraphicsConfiguration())) {
                return;
            }
            try {
                method.invoke(null, window, value);
            }
            catch (Exception ex) {
                Debug.reportError("Couldn't support AWTUtilities: ", ex);
            }
        }

        public static void setWindowOpaque(Window window, boolean opaque) {
            AWTUtilitiesWrapper.set(mSetWindowOpaque, window, opaque);
        }

        public static GraphicsConfiguration getBestGC() {
            GraphicsConfiguration translucencyCapableGC = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            if (!AWTUtilitiesWrapper.isTranslucencyCapable(translucencyCapableGC)) {
                translucencyCapableGC = null;
                GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice[] devices = env.getScreenDevices();
                for (int i = 0; i < devices.length && translucencyCapableGC == null; ++i) {
                    GraphicsConfiguration[] configs = devices[i].getConfigurations();
                    for (int j = 0; j < configs.length && translucencyCapableGC == null; ++j) {
                        if (!AWTUtilitiesWrapper.isTranslucencyCapable(configs[j])) continue;
                        translucencyCapableGC = configs[j];
                    }
                }
            }
            if (translucencyCapableGC == null) {
                Debug.message("No translucency capable GC");
            }
            return translucencyCapableGC;
        }

        static {
            AWTUtilitiesWrapper.init();
        }
    }
}

