/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.inspector;

import bluej.Config;
import bluej.debugmgr.inspector.FieldInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class FieldList
extends JTable {
    private int preferredWidth;

    public FieldList(int preferredWidth, Color valueFieldColor) {
        super(new ListTableModel());
        this.preferredWidth = preferredWidth;
        this.setShowGrid(false);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setSelectionMode(0);
        this.setIntercellSpacing(new Dimension());
        this.setDefaultRenderer(Object.class, new ListTableCellRenderer(valueFieldColor));
        this.setRowHeight(25);
        this.setAutoResizeMode(4);
        this.getTableHeader().setVisible(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.removeHeader();
    }

    public void setData(List<FieldInfo> listData) {
        ((ListTableModel)this.getModel()).setData(listData);
        this.setColumnWidths(listData);
        this.revalidate();
    }

    private void setColumnWidths(List<FieldInfo> listData) {
        int colPrefWidth = this.preferredWidth / 2;
        for (int column = 0; column < 2; ++column) {
            TableColumn tableColumn = this.getColumnModel().getColumn(column);
            int contentsMaxWidth = this.getMaxWidth(listData, column);
            if (contentsMaxWidth < colPrefWidth) {
                tableColumn.setMinWidth(contentsMaxWidth);
            } else {
                tableColumn.setMinWidth(colPrefWidth);
            }
            tableColumn.setPreferredWidth(contentsMaxWidth);
        }
    }

    private int getMaxWidth(List<FieldInfo> listData, int column) {
        TableCellRenderer ltcr = this.getDefaultRenderer(Object.class);
        TableColumn tableColumn = this.getColumnModel().getColumn(column);
        int contentsMaxWidth = tableColumn.getPreferredWidth();
        for (int row = 0; row < listData.size(); ++row) {
            Component n = ltcr.getTableCellRendererComponent(this, this.dataModel.getValueAt(row, column), false, false, row, column);
            contentsMaxWidth = Math.max(contentsMaxWidth, n.getPreferredSize().width);
        }
        return contentsMaxWidth;
    }

    private void removeHeader() {
        this.unconfigureEnclosingScrollPane();
    }

    public static class ListTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final ImageIcon objectrefIcon = Config.getImageAsIcon("image.inspector.objectref");
        private static final Border valueBorder = BorderFactory.createLineBorder(Color.gray);
        private Color bkColor;

        public ListTableCellRenderer(Color bkColor) {
            this.bkColor = bkColor;
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String valueString = (String)value;
            if (valueString == null) {
                return this;
            }
            if (valueString.equals("<object reference>")) {
                this.setIcon(objectrefIcon);
                this.setText("");
            } else {
                this.setIcon(null);
                this.setText(valueString);
                if (valueString.startsWith("\"")) {
                    this.setToolTipText(valueString);
                } else {
                    this.setToolTipText(null);
                }
            }
            Color rowBackground = isSelected ? table.getSelectionBackground() : this.bkColor;
            this.setBackground(rowBackground);
            Border b = BorderFactory.createLineBorder(rowBackground, 3);
            super.setBorder(b);
            if (column == 1) {
                this.setBackground(new Color(255, 255, 255));
                this.setHorizontalAlignment(0);
                CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(this.getBorder(), valueBorder);
                super.setBorder(compoundBorder);
            } else {
                this.setHorizontalAlignment(10);
            }
            return this;
        }
    }

    static class ListTableModel
    extends AbstractTableModel {
        private String[][] cells;

        public ListTableModel() {
        }

        public ListTableModel(List<FieldInfo> rows) {
            this.setData(rows);
        }

        @Override
        public String getValueAt(int row, int col) {
            return this.cells[row][col];
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (this.cells != null) {
                return this.cells.length;
            }
            return 0;
        }

        public void setData(List<FieldInfo> rows) {
            this.cells = new String[rows.size()][2];
            Iterator<FieldInfo> f = rows.iterator();
            for (int i = 0; i < rows.size(); ++i) {
                FieldInfo field = f.next();
                this.cells[i][0] = field.getDescription();
                this.cells[i][1] = field.getValue();
            }
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

