/*
 * Decompiled with CFR 0.152.
 */
package bluej.classmgr;

import bluej.classmgr.ClassPathEntry;
import bluej.utility.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassPath {
    private ArrayList<ClassPathEntry> entries = new ArrayList();

    public ClassPath() {
    }

    public ClassPath(ClassPath classpath) {
        this.addClassPath(classpath);
    }

    public ClassPath(String classpath, String genericdescription) {
        this.addClassPath(classpath, genericdescription);
    }

    public ClassPath(URL[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            try {
                ClassPathEntry cpe = new ClassPathEntry(new File(new URI(urls[i].toString())), "");
                if (this.entries.contains(cpe)) continue;
                this.entries.add(cpe);
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    public ClassPath(File[] files) {
        for (int index = 0; index < files.length; ++index) {
            this.entries.add(new ClassPathEntry(files[index], ""));
        }
    }

    protected List<ClassPathEntry> getEntries() {
        return this.entries;
    }

    public List<ClassPathEntry> getPathEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public void removeClassPath(String classpath) {
        try {
            StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String entry = st.nextToken();
                this.entries.remove(entry);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeAll() {
        this.entries.clear();
    }

    public void addClassPath(ClassPath classpath) {
        for (ClassPathEntry nextEntry : classpath.entries) {
            try {
                ClassPathEntry cpentry = (ClassPathEntry)nextEntry.clone();
                if (this.entries.contains(cpentry)) continue;
                this.entries.add(cpentry);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    public void addClassPath(String classpath, String genericdescription) {
        if (classpath == null) {
            return;
        }
        try {
            StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String entry = st.nextToken();
                ClassPathEntry cpentry = new ClassPathEntry(entry, genericdescription);
                if (this.entries.contains(cpentry)) continue;
                this.entries.add(cpentry);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList<URL> getURLs() {
        Iterator<ClassPathEntry> it = this.entries.iterator();
        ArrayList<URL> risul = new ArrayList<URL>();
        while (it.hasNext()) {
            ClassPathEntry path = it.next();
            try {
                risul.add(path.getURL());
            }
            catch (MalformedURLException mue) {
                Debug.reportError("ClassPath.getURLs() bad path=" + path);
            }
        }
        return risul;
    }

    public InputStream getFile(String filename) throws IOException {
        for (ClassPathEntry nextEntry : this.entries) {
            File fd;
            if (nextEntry.isJar()) {
                InputStream ret = this.readJar(nextEntry.getFile(), filename);
                if (ret == null) continue;
                return ret;
            }
            if (!nextEntry.isClassRoot() || !(fd = new File(nextEntry.getFile(), filename)).exists()) continue;
            return new FileInputStream(fd);
        }
        return null;
    }

    private InputStream readJar(File classjar, String filename) throws IOException {
        JarEntry entry;
        JarFile jarf = new JarFile(classjar);
        if (File.separatorChar != '/') {
            filename = filename.replace(File.separatorChar, '/');
        }
        if ((entry = jarf.getJarEntry(filename)) == null) {
            return null;
        }
        InputStream is = jarf.getInputStream(entry);
        return is;
    }

    public String toString() {
        return this.asList(File.pathSeparatorChar, false);
    }

    public String asList(char separator, boolean useURL) {
        StringBuffer buf = new StringBuffer();
        Iterator<ClassPathEntry> it = this.entries.iterator();
        while (it.hasNext()) {
            ClassPathEntry nextEntry = it.next();
            if (useURL) {
                try {
                    buf.append(nextEntry.getURL());
                }
                catch (MalformedURLException e) {}
            } else {
                buf.append(nextEntry.getPath());
            }
            if (!it.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }
}

