/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.glass.ui.Screen;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.prism.CompositeMode;
import com.sun.prism.PixelFormat;
import com.sun.prism.RenderTarget;
import com.sun.prism.Texture;
import com.sun.prism.camera.PrismCameraImpl;
import com.sun.prism.es2.ES2Graphics;
import com.sun.prism.es2.ES2Pipeline;
import com.sun.prism.es2.ES2RTTexture;
import com.sun.prism.es2.ES2RenderingContext;
import com.sun.prism.es2.ES2Shader;
import com.sun.prism.es2.ES2SwapChain;
import com.sun.prism.es2.ES2Texture;
import com.sun.prism.es2.ES2VertexBuffer;
import com.sun.prism.es2.GLContext;
import com.sun.prism.es2.GLDrawable;
import com.sun.prism.es2.GLFactory;
import com.sun.prism.es2.GLPixelFormat;
import com.sun.prism.impl.BufferUtil;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.ps.BaseShaderContext;
import com.sun.prism.ps.Shader;
import com.sun.prism.ps.ShaderFactory;
import java.nio.FloatBuffer;
import java.util.HashMap;

class ES2Context
extends BaseShaderContext {
    private static GeneralTransform3D projViewTx = new GeneralTransform3D();
    private static GeneralTransform3D scratchTx = new GeneralTransform3D();
    private static final GeneralTransform3D flipTx = new GeneralTransform3D();
    private RenderTarget currentTarget;
    private final FloatBuffer rawMatrix = BufferUtil.newFloatBuffer(16);
    private final GLContext glContext;
    private final GLDrawable dummyGLDrawable;
    private final GLPixelFormat pixelFormat;
    private final BaseShaderContext.State state;
    private final int quadIndices;
    private GLDrawable currentDrawable = null;
    private ES2RenderingContext currentRenderingContext = null;
    private int indexBuffer = 0;
    public static final int NUM_QUADS = 256;
    private int savedFBO = 0;

    private static ES2VertexBuffer createVertexBuffer() {
        return new ES2VertexBuffer(256);
    }

    ES2Context(Screen screen, ShaderFactory shaderFactory) {
        super(screen, shaderFactory, (VertexBuffer)ES2Context.createVertexBuffer());
        GLFactory gLFactory = ES2Pipeline.glFactory;
        this.pixelFormat = gLFactory.createGLPixelFormat(screen.getNativeScreen(), ES2Pipeline.pixelFormatAttributes);
        this.dummyGLDrawable = gLFactory.createDummyGLDrawable(this.pixelFormat);
        this.glContext = gLFactory.createGLContext(this.dummyGLDrawable, this.pixelFormat, gLFactory.getShareContext(), PrismSettings.isVsyncEnabled);
        this.makeCurrent(this.dummyGLDrawable);
        ES2VertexBuffer eS2VertexBuffer = (ES2VertexBuffer)this.getVertexBuffer();
        eS2VertexBuffer.enableVertexAttributes(this.glContext);
        this.quadIndices = eS2VertexBuffer.genQuadsIndexBuffer(256);
        this.setIndexBuffer(this.quadIndices);
        this.state = new BaseShaderContext.State();
        if (PlatformUtil.isMac()) {
            HashMap hashMap = (HashMap)ES2Pipeline.getInstance().getDeviceDetails();
            ES2Pipeline.glFactory.updateDeviceDetails(hashMap, this.glContext);
        }
    }

    final void setIndexBuffer(int n) {
        if (this.indexBuffer != n) {
            this.indexBuffer = n;
            this.glContext.setIndexBuffer(this.indexBuffer);
        }
    }

    GLContext getGLContext() {
        return this.glContext;
    }

    GLDrawable getDummyDrawable() {
        return this.dummyGLDrawable;
    }

    GLPixelFormat getPixelFormat() {
        return this.pixelFormat;
    }

    void setCurrentRenderingContext(ES2RenderingContext eS2RenderingContext, GLDrawable gLDrawable) {
        if (eS2RenderingContext != null && gLDrawable == null) {
            System.err.println("Warning: ES2Context.setCurrentRenderingContext: rc = " + eS2RenderingContext + ", drawable = " + gLDrawable);
        }
        this.currentRenderingContext = eS2RenderingContext;
        this.makeCurrent(gLDrawable);
    }

    ES2RenderingContext getCurrentRenderingContext() {
        return this.currentRenderingContext;
    }

    private void makeCurrent(GLDrawable gLDrawable) {
        if (PlatformUtil.isMac()) {
            if (gLDrawable != this.currentDrawable) {
                if (gLDrawable == this.dummyGLDrawable) {
                    this.glContext.bindFBO(this.savedFBO);
                } else {
                    this.savedFBO = this.glContext.getBoundFBO();
                    this.glContext.makeCurrent(gLDrawable);
                }
                this.currentDrawable = gLDrawable;
            }
        } else if (gLDrawable != this.currentDrawable) {
            this.glContext.makeCurrent(gLDrawable);
            this.glContext.bindFBO(0L);
            this.currentDrawable = gLDrawable;
        }
    }

    void forceRenderTarget(ES2Graphics eS2Graphics) {
        this.updateRenderTarget(eS2Graphics.getRenderTarget(), eS2Graphics.getCameraNoClone(), eS2Graphics.isDepthTest() && eS2Graphics.isDepthBuffer());
    }

    int getShaderProgram() {
        return this.glContext.getShaderProgram();
    }

    void setShaderProgram(int n) {
        this.glContext.setShaderProgram(n);
    }

    void updateShaderProgram(int n) {
        if (n != this.getShaderProgram()) {
            this.setShaderProgram(n);
        }
    }

    @Override
    protected void init() {
        super.init();
    }

    @Override
    public boolean isEdgeSmoothingSupported(PixelFormat pixelFormat) {
        if (ES2Pipeline.isEmbededDevice) {
            return !pixelFormat.isOpaque() && pixelFormat.isRGB();
        }
        return pixelFormat.isRGB();
    }

    @Override
    protected void releaseRenderTarget() {
        this.currentTarget = null;
        super.releaseRenderTarget();
    }

    @Override
    protected BaseShaderContext.State updateRenderTarget(RenderTarget renderTarget, PrismCameraImpl prismCameraImpl, boolean bl) {
        this.glContext.bindFBO(renderTarget.getNativeDestHandle());
        if (bl && renderTarget instanceof ES2RTTexture) {
            ((ES2RTTexture)renderTarget).attachDepthBuffer(this);
        }
        int n = renderTarget.getContentX();
        int n2 = renderTarget.getContentY();
        int n3 = renderTarget.getContentWidth();
        int n4 = renderTarget.getContentHeight();
        this.glContext.updateViewportAndDepthTest(n, n2, n3, n4, bl);
        projViewTx = prismCameraImpl.getProjViewTx(projViewTx, n3, n4);
        this.currentTarget = renderTarget;
        return this.state;
    }

    @Override
    protected void updateTexture(int n, Texture texture) {
        this.glContext.updateActiveTextureUnit(n);
        if (texture == null) {
            this.glContext.updateBoundTexture(0);
        } else {
            int n2 = (int)texture.getNativeSourceHandle();
            this.glContext.updateBoundTexture(n2);
            ES2Texture eS2Texture = (ES2Texture)texture;
            eS2Texture.updateWrapState();
            eS2Texture.updateFilterState();
        }
    }

    @Override
    protected void updateShaderTransform(Shader shader, BaseTransform baseTransform) {
        if (baseTransform == null) {
            baseTransform = BaseTransform.IDENTITY_TRANSFORM;
        }
        if (this.currentTarget instanceof ES2RTTexture) {
            scratchTx.set(flipTx);
        } else {
            scratchTx.setIdentity();
        }
        this.loadMatrix(scratchTx.mul(projViewTx).mul(baseTransform));
        ES2Shader eS2Shader = (ES2Shader)shader;
        eS2Shader.setMatrix("mvpMatrix", this.rawMatrix, 0, 1);
        if (eS2Shader.isPixcoordUsed()) {
            float f;
            float f2;
            float f3 = this.currentTarget.getContentX();
            float f4 = this.currentTarget.getContentY();
            if (this.currentTarget instanceof ES2SwapChain) {
                f2 = this.currentTarget.getPhysicalHeight();
                f = 1.0f;
            } else {
                f2 = 0.0f;
                f = -1.0f;
            }
            shader.setConstant("jsl_pixCoordOffset", f3, f4, f2, f);
        }
    }

    @Override
    protected void updateClipRect(Rectangle rectangle) {
        if (rectangle == null || rectangle.isEmpty()) {
            this.glContext.scissorTest(false, 0, 0, 0, 0);
        } else {
            int n = rectangle.width;
            int n2 = rectangle.height;
            int n3 = this.currentTarget.getContentX();
            int n4 = this.currentTarget.getContentY();
            if (this.currentTarget instanceof ES2RTTexture) {
                n3 += rectangle.x;
                n4 += rectangle.y;
            } else {
                int n5 = this.currentTarget.getPhysicalHeight();
                n3 += rectangle.x;
                n4 += n5 - (rectangle.y + n2);
            }
            this.glContext.scissorTest(true, n3, n4, n, n2);
        }
    }

    @Override
    protected void updateCompositeMode(CompositeMode compositeMode) {
        switch (compositeMode) {
            case CLEAR: {
                this.glContext.blendFunc(0, 0);
                break;
            }
            case SRC: {
                this.glContext.blendFunc(1, 0);
                break;
            }
            case SRC_OVER: {
                this.glContext.blendFunc(1, 7);
                break;
            }
            default: {
                throw new InternalError("Unrecognized composite mode: " + (Object)((Object)compositeMode));
            }
        }
    }

    private void loadMatrix(GeneralTransform3D generalTransform3D) {
        this.rawMatrix.rewind();
        this.rawMatrix.put((float)generalTransform3D.get(0));
        this.rawMatrix.put((float)generalTransform3D.get(4));
        this.rawMatrix.put((float)generalTransform3D.get(8));
        this.rawMatrix.put((float)generalTransform3D.get(12));
        this.rawMatrix.put((float)generalTransform3D.get(1));
        this.rawMatrix.put((float)generalTransform3D.get(5));
        this.rawMatrix.put((float)generalTransform3D.get(9));
        this.rawMatrix.put((float)generalTransform3D.get(13));
        this.rawMatrix.put((float)generalTransform3D.get(2));
        this.rawMatrix.put((float)generalTransform3D.get(6));
        this.rawMatrix.put((float)generalTransform3D.get(10));
        this.rawMatrix.put((float)generalTransform3D.get(14));
        this.rawMatrix.put((float)generalTransform3D.get(3));
        this.rawMatrix.put((float)generalTransform3D.get(7));
        this.rawMatrix.put((float)generalTransform3D.get(11));
        this.rawMatrix.put((float)generalTransform3D.get(15));
        this.rawMatrix.rewind();
    }

    static {
        BaseTransform baseTransform = Affine2D.getScaleInstance(1.0, -1.0);
        flipTx.setIdentity();
        flipTx.mul(baseTransform);
    }
}

