/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jobjc;

import com.apple.jobjc.Coder;
import com.apple.jobjc.JObjCRuntime;
import com.apple.jobjc.NativeBuffer;
import java.nio.ByteOrder;

public final class NativeArgumentBuffer {
    private static final ThreadLocal<NativeArgumentBuffer> threadLocal = new ThreadLocal();
    final JObjCRuntime runtime;
    final NativeBuffer buffer;
    long argPtrsPtr;
    long argValuesPtr;
    final long retValPtr;
    private static final int MAX_ARGS = 512;
    private static final int BUF_SIZE = 8192;
    private static final int ARG_VALS_OFFSET = 4096;

    static NativeArgumentBuffer getThreadLocalBuffer(JObjCRuntime runtime) {
        runtime.assertOK();
        NativeArgumentBuffer alreadyCreated = threadLocal.get();
        if (alreadyCreated != null) {
            return alreadyCreated;
        }
        NativeArgumentBuffer newThreadLocalState = new NativeArgumentBuffer(runtime);
        threadLocal.set(newThreadLocalState);
        return newThreadLocalState;
    }

    private NativeArgumentBuffer(JObjCRuntime runtime) {
        runtime.assertOK();
        this.runtime = runtime;
        this.buffer = new NativeBuffer(8192);
        this.buffer.buffer.order(ByteOrder.nativeOrder());
        this.reset();
        this.retValPtr = this.buffer.bufferPtr;
    }

    public void reset() {
        this.argPtrsPtr = this.buffer.bufferPtr;
        this.argValuesPtr = this.buffer.bufferPtr + 4096L;
        assert (this.buffer.ptrInBounds(this.argValuesPtr));
    }

    public void doPutArgPtr(long ptr) {
        assert (this.buffer.ptrInBounds(this.argPtrsPtr));
        Coder.PrimitivePointerCoder.INST.push(this.runtime, this.argPtrsPtr, ptr);
        this.argPtrsPtr += (long)JObjCRuntime.PTR_LEN;
    }

    public void didPutArgValue(int sizeof) {
        assert (this.buffer.ptrInBounds(this.argValuesPtr));
        this.doPutArgPtr(this.argValuesPtr);
        this.argValuesPtr += (long)sizeof;
    }

    public String toString() {
        long bptr;
        long i;
        StringBuilder builder = new StringBuilder();
        for (i = bptr = this.buffer.bufferPtr; i < bptr + 4096L; i += (long)JObjCRuntime.PTR_LEN) {
            if (this.argPtrsPtr == i) {
                builder.append("*");
            }
            builder.append(Coder.PrimitivePointerCoder.INST.popPtr(JObjCRuntime.inst(), i));
            builder.append(" ");
        }
        builder.append("\n");
        for (i = bptr + 4096L; i < bptr + 8192L; i += (long)JObjCRuntime.PTR_LEN) {
            if (this.argValuesPtr == i) {
                builder.append("*");
            }
            builder.append(Coder.PrimitivePointerCoder.INST.popPtr(JObjCRuntime.inst(), i));
            builder.append(" ");
        }
        return builder.toString();
    }
}

