/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jobjc;

import com.apple.jobjc.ID;
import com.apple.jobjc.JObjCRuntime;
import com.apple.jobjc.NativeObjectLifecycleManager;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSClass<T extends ID>
extends ID {
    static native long getNativeClassByName(String var0);

    static native long getSuperClassOfClass(long var0);

    static native String getClassNameOfClass(long var0);

    static native long getClass(long var0);

    public NSClass(long ptr, JObjCRuntime runtime) {
        super(ptr, runtime);
    }

    public NSClass(String name, JObjCRuntime runtime) {
        this(NSClass.getNativeClassByName(name), runtime);
        if (this.ptr == 0L) {
            throw new NSClassNotFoundException("NSClass pointer is 0. Found no class named " + name);
        }
    }

    protected NSClass(JObjCRuntime runtime) {
        super(0L, runtime);
        String sn = this.getClass().getSimpleName();
        String name = sn.substring(0, sn.lastIndexOf("Class"));
        this.ptr = NSClass.getNativeClassByName(name);
        if (this.ptr == 0L) {
            throw new NSClassNotFoundException("NSClass pointer is 0. Found no class named " + name);
        }
    }

    NSClass<? super T> getSuperClass() {
        return new NSClass<T>(NSClass.getSuperClassOfClass(this.ptr), this.runtime);
    }

    String getClassName() {
        return NSClass.getClassNameOfClass(this.ptr);
    }

    @Override
    protected NativeObjectLifecycleManager getNativeObjectLifecycleManager() {
        return NativeObjectLifecycleManager.Nothing.INST;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof NSClass && this.ptr == ((NSClass)o).ptr;
    }

    static <T extends NSClass> T getObjCClassFor(JObjCRuntime runtime, long clsPtr) {
        if (clsPtr == 0L) {
            return null;
        }
        WeakReference cachedObj = (WeakReference)((LinkedHashMap)objectCache.get()).get(clsPtr);
        if (cachedObj != null && cachedObj.get() != null) {
            return (T)((NSClass)cachedObj.get());
        }
        T newObj = NSClass.createNewObjCClassFor(runtime, clsPtr);
        ((LinkedHashMap)objectCache.get()).put(clsPtr, new WeakReference<T>(newObj));
        return newObj;
    }

    static <T extends NSClass> T createNewObjCClassFor(JObjCRuntime runtime, long clsPtr) {
        Constructor<T> ctor = NSClass.getNSClassConstructorForClassPtr(runtime, clsPtr);
        return (T)((NSClass)NSClass.createNewObjCObjectForConstructor(ctor, clsPtr, runtime));
    }

    static <T extends NSClass> Constructor<T> getNSClassConstructorForClassPtr(JObjCRuntime runtime, long clazzPtr) {
        Constructor<T> ctor;
        Class<T> clazz = NSClass.getNSClassForClassPtr(runtime, clazzPtr);
        try {
            ctor = clazz.getDeclaredConstructor(CTOR_ARGS);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        ctor.setAccessible(true);
        return ctor;
    }

    static <T extends ID> Class<T> getNSClassForClassPtr(JObjCRuntime runtime, long clazzPtr) {
        long superClazzPtr;
        String className = NSClass.getClassNameOfClass(clazzPtr);
        Class<? extends ID> clazz = runtime.getClassForNativeClassName(className + "Class");
        if (clazz == null && (superClazzPtr = NSClass.getSuperClassOfClass(clazzPtr)) != 0L) {
            return NSClass.getNSClassForClassPtr(runtime, superClazzPtr);
        }
        return clazz;
    }

    public static class NSClassNotFoundException
    extends RuntimeException {
        public NSClassNotFoundException(String m) {
            super(m);
        }

        public NSClassNotFoundException(String m, Throwable cause) {
            super(m, cause);
        }
    }
}

