/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jobjc;

import com.apple.jobjc.JObjCRuntime;
import com.apple.jobjc.NSClass;
import com.apple.jobjc.NativeObjectLifecycleManager;
import com.apple.jobjc.Pointer;
import com.apple.jobjc.Subclassing;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ID
extends Pointer<Void> {
    final JObjCRuntime runtime;
    static final Class[] CTOR_ARGS = new Class[]{Long.TYPE, JObjCRuntime.class};
    static final ThreadLocal<LinkedHashMap<Long, Constructor>> constructorCache = new ThreadLocal<LinkedHashMap<Long, Constructor>>(){

        @Override
        protected LinkedHashMap<Long, Constructor> initialValue() {
            int MAX_ENTRIES = 1000;
            float LOAD_FACTOR = 0.75f;
            return new LinkedHashMap<Long, Constructor>(1333, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<Long, Constructor> eldest) {
                    return this.size() > 1000;
                }
            };
        }
    };
    static final ThreadLocal<LinkedHashMap<Long, WeakReference>> objectCache = new ThreadLocal<LinkedHashMap<Long, WeakReference>>(){

        @Override
        protected LinkedHashMap<Long, WeakReference> initialValue() {
            int MAX_ENTRIES = 1000;
            float LOAD_FACTOR = 0.75f;
            return new LinkedHashMap<Long, WeakReference>(1333, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<Long, WeakReference> eldest) {
                    return this.size() > 1000 || eldest.getValue().get() == null;
                }
            };
        }
    };

    static native String getNativeDescription(long var0);

    protected ID(long objPtr, JObjCRuntime runtime) {
        super(objPtr);
        runtime.assertOK();
        this.runtime = runtime;
    }

    protected ID(ID obj, JObjCRuntime runtime) {
        this(obj.ptr, runtime);
    }

    @Override
    protected NativeObjectLifecycleManager getNativeObjectLifecycleManager() {
        return NativeObjectLifecycleManager.CFRetainRelease.INST;
    }

    protected final JObjCRuntime getRuntime() {
        return this.runtime;
    }

    public String toString() {
        String s = super.toString();
        return s + " (ObjC: " + this.ptr + " / " + Long.toHexString(this.ptr) + ")";
    }

    public static <T extends ID> T getInstance(long ptr, JObjCRuntime runtime) {
        return ID.getObjCObjectFor(runtime, ptr);
    }

    static <T extends ID> T getObjCObjectFor(JObjCRuntime runtime, long objPtr) {
        if (objPtr == 0L) {
            return null;
        }
        WeakReference cachedObj = objectCache.get().get(objPtr);
        if (cachedObj != null && cachedObj.get() != null) {
            return (T)((ID)cachedObj.get());
        }
        long clsPtr = NSClass.getClass(objPtr);
        Object newObj = runtime.subclassing.isUserClass(clsPtr) ? Subclassing.getJObjectFromIVar(objPtr) : ID.createNewObjCObjectFor(runtime, objPtr, clsPtr);
        objectCache.get().put(objPtr, new WeakReference(newObj));
        return newObj;
    }

    static <T extends ID> T createNewObjCObjectFor(JObjCRuntime runtime, long objPtr, long clsPtr) {
        Constructor<T> ctor = ID.getConstructorForClassPtr(runtime, clsPtr);
        return ID.createNewObjCObjectForConstructor(ctor, objPtr, runtime);
    }

    static <T extends ID> Constructor<T> getConstructorForClassPtr(JObjCRuntime runtime, long clazzPtr) {
        Constructor<T> ctor;
        Constructor cachedCtor = constructorCache.get().get(clazzPtr);
        if (cachedCtor != null) {
            return cachedCtor;
        }
        Class<T> clazz = ID.getClassForClassPtr(runtime, clazzPtr);
        try {
            ctor = clazz.getDeclaredConstructor(CTOR_ARGS);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        ctor.setAccessible(true);
        constructorCache.get().put(clazzPtr, ctor);
        return ctor;
    }

    static <T extends ID> Class<T> getClassForClassPtr(JObjCRuntime runtime, long clazzPtr) {
        long superClazzPtr;
        String className = NSClass.getClassNameOfClass(clazzPtr);
        Class<? extends ID> clazz = runtime.getClassForNativeClassName(className);
        if (clazz == null && (superClazzPtr = NSClass.getSuperClassOfClass(clazzPtr)) != 0L) {
            return ID.getClassForClassPtr(runtime, superClazzPtr);
        }
        return clazz;
    }

    static <T extends ID> T createNewObjCObjectForConstructor(Constructor ctor, long objPtr, JObjCRuntime runtime) {
        try {
            ID newInstance = (ID)ctor.newInstance(objPtr, runtime);
            objectCache.get().put(objPtr, new WeakReference<ID>(newInstance));
            return (T)newInstance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static <T extends ID> T createNewObjCObjectForClass(Class<T> clazz, long objPtr, JObjCRuntime runtime) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(CTOR_ARGS);
            constructor.setAccessible(true);
            return ID.createNewObjCObjectForConstructor(constructor, objPtr, runtime);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

