/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jobjc;

import com.apple.jobjc.MacOSXFramework;

public class Function {
    final long fxnPtr;

    private static native long getFxnPtrForFunctionName(String var0);

    private static native long getFxnPtrForFunctionNameAndLib(long var0, String var2);

    Function(long fxnPtr) {
        this.fxnPtr = fxnPtr;
    }

    public Function(String name) {
        this(Function.getFxnPtr(name));
    }

    public Function(MacOSXFramework framework, String name) {
        this(Function.getFxnPtr(name, framework));
    }

    static long getFxnPtr(String name) {
        long fxnPtr = Function.getFxnPtrForFunctionName(name);
        if (fxnPtr == 0L) {
            throw new RuntimeException("Function pointer for " + name + " not found in runtime.");
        }
        return fxnPtr;
    }

    static long getFxnPtr(String name, MacOSXFramework framework) {
        long fxnPtr = 0L;
        for (int i = 0; fxnPtr == 0L && i < framework.nativeLibPtrs.length; ++i) {
            fxnPtr = Function.getFxnPtrForFunctionNameAndLib(framework.nativeLibPtrs[i], name);
            if (fxnPtr == 0L) continue;
            return fxnPtr;
        }
        throw new RuntimeException("Function pointer for " + name + " not found in framework " + framework + ".");
    }
}

