/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.naming;

import java.io.File;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;

final class NameRef
extends WeakReference<FileNaming> {
    private Object next;
    static final ReferenceQueue<FileNaming> QUEUE = new ReferenceQueue();

    public NameRef(FileNaming fileNaming) {
        super(fileNaming, QUEUE);
    }

    public Integer getIndex() {
        assert (Thread.holdsLock(NamingFactory.class));
        for (NameRef nameRef = this; nameRef != null; nameRef = nameRef.next()) {
            if (!(nameRef.next instanceof Integer)) continue;
            return (Integer)nameRef.next;
        }
        return -1;
    }

    public NameRef next() {
        if (this.next instanceof Integer) {
            return null;
        }
        return (NameRef)this.next;
    }

    public File getFile() {
        FileNaming fileNaming = (FileNaming)this.get();
        return fileNaming == null ? null : fileNaming.getFile();
    }

    public NameRef remove(NameRef nameRef) {
        assert (Thread.holdsLock(NamingFactory.class));
        if (nameRef == this) {
            return this.next();
        }
        NameRef nameRef2 = this;
        while (nameRef2.next != nameRef) {
            if (nameRef2.next instanceof Integer) {
                return this;
            }
            nameRef2 = (NameRef)nameRef2.next;
        }
        nameRef2.next = nameRef2.next().next;
        return this;
    }

    final void setNext(NameRef nameRef) {
        assert (Thread.holdsLock(NamingFactory.class));
        assert (this.next == null) : "There is next " + this.next;
        this.next = nameRef;
    }

    final void setIndex(int n) {
        assert (Thread.holdsLock(NamingFactory.class));
        assert (this.next == null) : "There is next " + this.next;
        this.next = n;
    }

    final void skip(NameRef nameRef) {
        assert (Thread.holdsLock(NamingFactory.class));
        assert (this.next == nameRef);
        assert (nameRef.get() == null);
        this.next = nameRef.next;
    }

    final Iterable<NameRef> disconnectAll() {
        assert (Thread.holdsLock(NamingFactory.class));
        LinkedList<NameRef> linkedList = new LinkedList<NameRef>();
        NameRef nameRef = this;
        while (nameRef != null) {
            NameRef nameRef2 = nameRef.next();
            nameRef.next = null;
            if (nameRef.get() != null) {
                linkedList.add(nameRef);
            }
            nameRef = nameRef2;
        }
        return linkedList;
    }
}

