/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.GraphicsEnvironment;
import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.JarClassLoader;
import org.netbeans.ProxyURLStreamHandlerFactory;
import org.netbeans.Stamps;
import org.netbeans.Util;
import org.netbeans.core.startup.CLIOptions;
import org.netbeans.core.startup.CoreBridge;
import org.netbeans.core.startup.InstalledFileLocatorImpl;
import org.netbeans.core.startup.ModuleSystem;
import org.netbeans.core.startup.NbRepository;
import org.netbeans.core.startup.RunLevel;
import org.netbeans.core.startup.Splash;
import org.netbeans.core.startup.StartLog;
import org.netbeans.core.startup.TopLogging;
import org.netbeans.core.startup.TopThreadGroup;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.Utilities;

public final class Main {
    private static final Logger LOG = Logger.getLogger(Main.class.getName());
    private static ModuleSystem moduleSystem;
    private static boolean moduleSystemInitialized;

    public static void setStatusText(String string) {
        Splash.getInstance().print(string);
        if (moduleSystemInitialized) {
            CoreBridge.getDefault().setStatusText(string);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        TopThreadGroup topThreadGroup = new TopThreadGroup("IDE Main", stringArray);
        StartLog.logStart("Forwarding to topThreadGroup");
        topThreadGroup.start();
        StartLog.logProgress("Main.main finished");
    }

    public static void initializeURLFactory() {
        ProxyURLStreamHandlerFactory.register();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initUICustomizations() {
        if (!CLIOptions.isGui()) {
            return;
        }
        URL uRL = null;
        boolean bl = Boolean.getBoolean("netbeans.useTheme") || CLIOptions.uiClass != null && CLIOptions.uiClass.getName().indexOf("MetalLookAndFeel") >= 0;
        try {
            if (bl) {
                FileObject fileObject = FileUtil.getConfigFile((String)"themes.xml");
                if (fileObject == null) {
                    try {
                        uRL = new URL("nbresloc:/org/netbeans/core/startup/resources/themes.xml");
                        uRL.openStream().close();
                    }
                    catch (IOException iOException) {
                        uRL = null;
                    }
                } else {
                    try {
                        uRL = fileObject.getURL();
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            CoreBridge.getDefault().initializePlaf(CLIOptions.uiClass, CLIOptions.getFontSize(), uRL);
        }
        if (CLIOptions.getFontSize() > 0 && "GTK".equals(UIManager.getLookAndFeel().getID())) {
            Util.err.warning(NbBundle.getMessage(Main.class, (String)"GTK_FONTSIZE_UNSUPPORTED"));
        }
        StartLog.logProgress("Fonts updated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleSystem getModuleSystem() {
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            if (moduleSystem != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return moduleSystem;
            }
            StartLog.logStart("Modules initialization");
            try {
                moduleSystem = new ModuleSystem();
                moduleSystem.init(FileUtil.getConfigRoot().getFileSystem());
            }
            catch (IOException iOException) {
                throw (IllegalStateException)new IllegalStateException("Module system cannot be created").initCause(iOException);
            }
            StartLog.logProgress("ModuleSystem created");
            // ** MonitorExit[var0] (shouldn't be in output)
            moduleSystem.loadBootModules();
            moduleSystem.readList();
            moduleSystem.restore();
            StartLog.logEnd("Modules initialization");
            moduleSystemInitialized = true;
            return moduleSystem;
        }
    }

    public static boolean isInitialized() {
        return moduleSystemInitialized;
    }

    static void start(String[] stringArray) throws SecurityException {
        StartLog.logEnd("Forwarding to topThreadGroup");
        StartLog.logStart("Preparation");
        System.setProperty("org.openide.specification.version", "6.2");
        System.setProperty("org.openide.version", "deprecated");
        System.setProperty("org.openide.major.version", "IDE/1");
        String string = System.getProperty("jdk.home");
        if (string == null) {
            string = System.getProperty("java.home");
            if (!Utilities.isMac()) {
                string = string + File.separator + "..";
            }
            System.setProperty("jdk.home", string);
        }
        Main.initializeURLFactory();
        CLIOptions.initialize();
        StartLog.logProgress("Command line parsed");
        if (CLIOptions.isGui()) {
            try {
                GraphicsEnvironment.getLocalGraphicsEnvironment();
            }
            catch (InternalError internalError) {
                String string2 = NbBundle.getMessage(Main.class, (String)"EXC_GraphicsStartFails1", (Object)internalError.getMessage());
                System.out.println(string2);
                string2 = NbBundle.getMessage(Main.class, (String)"EXC_GraphicsStartFails2", (Object)(CLIOptions.getUserDir() + "/var/log/messages.log"));
                System.out.println(string2);
                throw internalError;
            }
        }
        InstalledFileLocatorImpl.prepareCache();
        String[] stringArray2 = Introspector.getBeanInfoSearchPath();
        String[] stringArray3 = new String[]{"org.netbeans.beaninfo"};
        String[] stringArray4 = new String[stringArray2.length + stringArray3.length];
        System.arraycopy(stringArray3, 0, stringArray4, 0, stringArray3.length);
        System.arraycopy(stringArray2, 0, stringArray4, stringArray3.length, stringArray2.length);
        Introspector.setBeanInfoSearchPath(stringArray4);
        try {
            if (!Boolean.getBoolean("netbeans.full.hack") && !Boolean.getBoolean("netbeans.close")) {
                if (!Main.handleLicenseCheck()) {
                    File file = new File(CLIOptions.getUserDir());
                    Main.deleteRec(new File(file, "var/cache"));
                    Main.deleteRec(new File(file, "var/log"));
                    Main.rm(new File(file, "var"));
                    Main.rm(new File(file, "config"));
                    Main.rm(file);
                    TopLogging.exit(0);
                }
                if (!Main.handleImportOfUserDir()) {
                    TopLogging.exit(0);
                }
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        StartLog.logProgress("License check performed and upgrade wizard consulted");
        Splash.getInstance().setRunning(true);
        Splash.getInstance().print(NbBundle.getMessage(Main.class, (String)"MSG_IDEInit"));
        assert (Repository.getDefault() instanceof NbRepository) : "Has to be NbRepository: " + Repository.getDefault();
        Main.getModuleSystem();
        CoreBridge.getDefault().registerPropertyEditors();
        StartLog.logProgress("PropertyEditors registered");
        org.netbeans.Main.finishInitialization();
        StartLog.logProgress("Ran any delayed command-line options");
        for (RunLevel runLevel : Lookup.getDefault().lookupAll(RunLevel.class)) {
            runLevel.run();
        }
        InstalledFileLocatorImpl.discardCache();
        Splash.getInstance().setRunning(false);
        Splash.getInstance().dispose();
        StartLog.logProgress("Splash hidden");
        StartLog.logEnd("Preparation");
        JarClassLoader.saveArchive();
        Stamps.getModulesJARs().flush(15000);
    }

    private static void deleteRec(File file) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                Logger.getLogger(Main.class.getName()).log(Level.WARNING, "Could not list: {0}", file);
            } else {
                for (File file2 : fileArray) {
                    Main.deleteRec(file2);
                }
            }
        }
        Main.rm(file);
    }

    private static void rm(File file) {
        if (file.exists() && !file.delete()) {
            Logger.getLogger(Main.class.getName()).log(Level.WARNING, "Failed to delete {0}", file);
        }
    }

    private static final Class getKlass(String string) {
        try {
            ModuleSystem moduleSystem = Main.moduleSystem;
            ClassLoader classLoader = moduleSystem != null ? moduleSystem.getManager().getClassLoader() : Main.class.getClassLoader();
            return Class.forName(string, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getLocalizedMessage());
        }
    }

    static boolean handleImportOfUserDir() {
        class ImportHandler
        implements Runnable {
            private File installed = new File(new File(CLIOptions.getUserDir(), "var"), "imported");
            private String classname;
            private boolean executedOk;

            ImportHandler() {
            }

            public boolean shouldDoAnImport() {
                this.classname = System.getProperty("netbeans.importclass");
                return this.classname != null && !this.installed.exists();
            }

            @Override
            public void run() {
                try {
                    Class clazz = Main.getKlass(this.classname);
                    Method method = clazz.getMethod("main", String[].class);
                    method.invoke(null, new Object[]{new String[0]});
                    this.executedOk = true;
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (invocationTargetException.getTargetException() instanceof UserCancelException) {
                        this.executedOk = true;
                    } else {
                        LOG.log(Level.WARNING, null, invocationTargetException);
                    }
                }
                catch (Exception exception) {
                    LOG.log(Level.WARNING, null, exception);
                }
                catch (LinkageError linkageError) {
                    LOG.log(Level.WARNING, null, linkageError);
                }
            }

            public boolean canContinue() {
                if (this.shouldDoAnImport()) {
                    try {
                        SwingUtilities.invokeAndWait(this);
                        if (this.executedOk) {
                            this.installed.getParentFile().mkdirs();
                            this.installed.createNewFile();
                            return true;
                        }
                        return false;
                    }
                    catch (IOException iOException) {
                        LOG.log(Level.WARNING, null, iOException);
                        return true;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        return false;
                    }
                    catch (InterruptedException interruptedException) {
                        LOG.log(Level.WARNING, null, interruptedException);
                        return false;
                    }
                }
                return true;
            }
        }
        ImportHandler importHandler = new ImportHandler();
        return importHandler.canContinue();
    }

    static boolean handleLicenseCheck() {
        class LicenseHandler
        implements Runnable {
            private String classname;
            private boolean executedOk;

            LicenseHandler() {
            }

            public boolean shouldDisplayLicense() {
                File file = InstalledFileLocator.getDefault().locate("var/license_accepted", null, false);
                if (file != null) {
                    return false;
                }
                this.classname = System.getProperty("netbeans.accept_license_class");
                return this.classname != null;
            }

            @Override
            public void run() {
                try {
                    Class clazz = Main.getKlass(this.classname);
                    Method method = clazz.getMethod("showLicensePanel", new Class[0]);
                    method.invoke(null, new Object[0]);
                    this.executedOk = true;
                    File file = new File(new File(CLIOptions.getUserDir(), "var"), "license_accepted");
                    if (!file.exists()) {
                        file.getParentFile().mkdirs();
                        try {
                            file.createNewFile();
                        }
                        catch (IOException iOException) {
                            LOG.log(Level.WARNING, null, iOException);
                        }
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (invocationTargetException.getTargetException() instanceof UserCancelException) {
                        this.executedOk = false;
                    } else {
                        LOG.log(Level.WARNING, null, invocationTargetException);
                    }
                }
                catch (Exception exception) {
                    LOG.log(Level.WARNING, null, exception);
                }
                catch (LinkageError linkageError) {
                    LOG.log(Level.WARNING, null, linkageError);
                }
            }

            public boolean canContinue() {
                if (this.shouldDisplayLicense()) {
                    try {
                        SwingUtilities.invokeAndWait(this);
                        return this.executedOk;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        return false;
                    }
                    catch (InterruptedException interruptedException) {
                        LOG.log(Level.WARNING, null, interruptedException);
                        return false;
                    }
                }
                return true;
            }
        }
        LicenseHandler licenseHandler = new LicenseHandler();
        return licenseHandler.canContinue();
    }
}

