/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.SecuritySettings;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.SandboxSecurity;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.UIFactory;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.deploy.util.VersionID;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.util.JfxHelper;
import java.awt.Component;
import java.io.IOException;
import java.net.URL;

public class SecureStaticVersioning {
    private static final String SSV2VERSION_KEY = "ssv.version.allowed";
    private static final String SSV2LATEST_VALUE = "ssv.latest.allowed";
    private static final int REASON_CONFIG = 0;
    private static final int REASON_UNSIGNED = 1;
    private static final int REASON_UNAVAIL = 2;
    private static final int REASON_FX = 3;
    private static final int REASON_INVALID = 4;

    public static boolean promptUse(Component component, AppInfo appInfo, LocalApplicationProperties localApplicationProperties, String string) throws ExitException {
        if (SecuritySettings.isSSVModeNever()) {
            SecureStaticVersioning.useLatest(appInfo, string);
            return false;
        }
        if (localApplicationProperties != null && SSV2LATEST_VALUE.equals(localApplicationProperties.get(SSV2VERSION_KEY))) {
            return false;
        }
        if (SecureStaticVersioning.showSSV2Dialog(component, appInfo, string)) {
            if (localApplicationProperties != null) {
                localApplicationProperties.put(SSV2VERSION_KEY, string);
                try {
                    localApplicationProperties.store();
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                }
            }
            return true;
        }
        if (localApplicationProperties != null) {
            localApplicationProperties.put(SSV2VERSION_KEY, SSV2LATEST_VALUE);
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        return false;
    }

    public static boolean canUse(LaunchDesc launchDesc, String string) throws ExitException {
        LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((URL)launchDesc.getCanonicalHome());
        if (launchDesc.needFX() && !JfxHelper.isCompatibleRuntime(launchDesc.getHomeJRE(), launchDesc.getSelectedJRE())) {
            SecureStaticVersioning.showCannotUseDialog(null, launchDesc.getAppInfo(), localApplicationProperties, string, 3);
            return false;
        }
        if (JnlpxArgs.getIsRelaunch() && !string.equals(launchDesc.getSelectedJRE().getProduct())) {
            return false;
        }
        if (launchDesc.getSecurityModel() != 0 || !SecureStaticVersioning.isOlderVersion(string) || SecurityBaseline.satisfiesSecurityBaseline((String)string)) {
            return true;
        }
        if (localApplicationProperties != null && string.equals(localApplicationProperties.get(SSV2VERSION_KEY))) {
            return true;
        }
        return SecureStaticVersioning.promptUse(null, launchDesc.getAppInfo(), localApplicationProperties, string);
    }

    public static boolean canUse(AppInfo appInfo, String string) throws ExitException {
        if (!SecureStaticVersioning.isOlderVersion(string) || SecurityBaseline.satisfiesSecurityBaseline((String)string)) {
            return true;
        }
        LocalApplicationProperties localApplicationProperties = null;
        try {
            URL uRL = new URL(appInfo.getFrom().toString() + "/" + appInfo.getTitle());
            localApplicationProperties = Cache.getLocalApplicationProperties((URL)uRL);
        }
        catch (IOException iOException) {
            Trace.ignored((Throwable)iOException);
        }
        if (localApplicationProperties != null && string.equals(localApplicationProperties.get(SSV2VERSION_KEY))) {
            return true;
        }
        return SecureStaticVersioning.promptUse(null, appInfo, localApplicationProperties, string);
    }

    public static void resetAcceptedVersion(URL uRL) {
        LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((URL)uRL);
        if (localApplicationProperties != null) {
            localApplicationProperties.put(SSV2VERSION_KEY, null);
            SandboxSecurity.resetAcceptedVersion((LocalApplicationProperties)localApplicationProperties);
        }
    }

    private static boolean isOlderVersion(String string) {
        VersionID versionID;
        VersionID versionID2 = new VersionID(SecurityBaseline.getCurrentVersion() + "+");
        return !versionID2.match(versionID = new VersionID(string));
    }

    private static LocalApplicationProperties getLap(AppInfo appInfo) {
        return Cache.getLocalApplicationProperties((URL)appInfo.getLapURL());
    }

    private static boolean showSSV2Dialog(Component component, AppInfo appInfo, String string) throws ExitException {
        String string2 = ResourceManager.getString((String)"deployment.ssv2.title");
        String string3 = ResourceManager.getString((String)"deployment.ssv2.masthead");
        String string4 = ResourceManager.getString((String)"deployment.ssv2.risk");
        String string5 = ResourceManager.getString((String)"deployment.ssv2.moreText");
        URL uRL = null;
        try {
            uRL = new URL("http://java.com/access_old_java");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string6 = ResourceManager.getString((String)"deployment.ssv2.choice");
        String string7 = ResourceManager.getString((String)"deployment.ssv2.choice1");
        String string8 = ResourceManager.getString((String)"deployment.ssv2.choice2", (String)string);
        String string9 = ResourceManager.getString((String)"deployment.ssv2.run.button");
        String string10 = ResourceManager.getString((String)"common.cancel_btn");
        int n = ToolkitStore.getUI().showSSVDialog((Object)component, appInfo, string2, string3, string4, string5, uRL, string6, string7, string8, string9, string10);
        ToolkitStore.getUI();
        if (n == 0) {
            return true;
        }
        ToolkitStore.getUI();
        if (n == 2) {
            return false;
        }
        throw new ExitException(null, 0);
    }

    private static void showCannotUseDialog(Component component, AppInfo appInfo, LocalApplicationProperties localApplicationProperties, String string, int n) throws ExitException {
        if (localApplicationProperties != null && SSV2LATEST_VALUE.equals(localApplicationProperties.get(SSV2VERSION_KEY))) {
            return;
        }
        String string2 = ResourceManager.getString((String)"deployment.ssv2.nodl.title");
        String string3 = null;
        switch (n) {
            case 0: {
                string3 = "deployment.ssv2.nodl.blocked";
                break;
            }
            case 3: {
                string3 = "deployment.ssv2.nodl.fx";
                break;
            }
            case 4: {
                string3 = "deployment.ssv2.nodl.invalid";
                break;
            }
            default: {
                string3 = "deployment.ssv2.nodl.masthead";
            }
        }
        String string4 = ResourceManager.getString((String)string3, (String)string);
        String string5 = ResourceManager.getString((String)"deployment.ssv2.nodl.button");
        String string6 = ResourceManager.getString((String)"common.cancel_btn");
        String string7 = ResourceManager.getString((String)"deployment.ssv2.moreText");
        URL uRL = null;
        try {
            uRL = new URL("http://java.com/access_old_java");
        }
        catch (Exception exception) {
            // empty catch block
        }
        UIFactory uIFactory = ToolkitStore.getUI();
        ToolkitStore.getUI();
        int n2 = uIFactory.showMessageDialog((Object)component, appInfo, 2, string2, string4, null, null, string5, string6, null, uRL, string7, 0);
        ToolkitStore.getUI();
        if (n2 != 0) {
            throw new ExitException(null, 0);
        }
        if (localApplicationProperties != null) {
            localApplicationProperties.put(SSV2VERSION_KEY, SSV2LATEST_VALUE);
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
    }

    public static boolean useLatest(AppInfo appInfo, String string) throws ExitException {
        int n = SecuritySettings.isSSVModeNever() ? 0 : 2;
        SecureStaticVersioning.showCannotUseDialog(null, appInfo, SecureStaticVersioning.getLap(appInfo), string, n);
        return true;
    }
}

