/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.BlueJSyntaxView;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.prefmgr.PrefMgr;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;

public class MoeSyntaxView
extends BlueJSyntaxView {
    public static final short TAG_WIDTH = 14;
    protected static final int BREAKPOINT_OFFSET = 16;
    protected static final int LEFT_MARGIN = 24;
    private static boolean syntaxHighlighting = PrefMgr.getFlag((String)"bluej.editor.syntaxHilighting");
    protected Font lineNumberFont;
    protected Font smallLineNumberFont;
    protected FontMetrics lineNumberMetrics;
    public static final String BREAKPOINT = "break";
    public static final String STEPMARK = "step";
    static final Image breakImage = Config.getImageAsIcon((String)"image.editor.breakmark").getImage();
    static final Image stepImage = Config.getImageAsIcon((String)"image.editor.stepmark").getImage();
    static final Image breakStepImage = Config.getImageAsIcon((String)"image.editor.breakstepmark").getImage();

    public MoeSyntaxView(Element elem) {
        super(elem, 24);
    }

    public static void resetSyntaxHighlighting() {
        syntaxHighlighting = PrefMgr.getFlag((String)"bluej.editor.syntaxHilighting");
    }

    @Override
    protected void initialise(Graphics g) {
        super.initialise(g);
        this.lineNumberFont = this.defaultFont.deriveFont(9.0f);
        this.smallLineNumberFont = this.defaultFont.deriveFont(7.0f);
        Container c = this.getContainer();
        this.lineNumberMetrics = c.getFontMetrics(this.lineNumberFont);
    }

    protected void drawLineNumber(Graphics g, int lineNumber, int x, int y) {
        g.setColor(Color.darkGray);
        String number = Integer.toString(lineNumber);
        int stringWidth = this.lineNumberMetrics.stringWidth(number);
        int xoffset = 16 - stringWidth - 4;
        if (xoffset < -2) {
            ++xoffset;
        }
        if (xoffset < -2) {
            g.setFont(this.smallLineNumberFont);
            g.drawString(number, x - 3, y);
        } else {
            g.setFont(this.lineNumberFont);
            g.drawString(number, x + xoffset, y);
        }
        g.setFont(this.defaultFont);
    }

    protected void paintLineMarkers(int lineIndex, Graphics g, int x, int y, MoeSyntaxDocument document, Element line) {
        if (PrefMgr.getFlag((String)"bluej.editor.displayLineNumbers")) {
            this.drawLineNumber(g, lineIndex + 1, x, y);
        }
        if (this.hasTag(line, BREAKPOINT)) {
            if (this.hasTag(line, STEPMARK)) {
                g.drawImage(breakStepImage, x - 1, y + 3 - breakStepImage.getHeight(null), null);
            } else {
                g.drawImage(breakImage, x - 1, y + 3 - breakImage.getHeight(null), null);
            }
        } else if (this.hasTag(line, STEPMARK)) {
            g.drawImage(stepImage, x - 1, y + 3 - stepImage.getHeight(null), null);
        }
    }

    @Override
    public void paintTaggedLine(Segment lineText, int lineIndex, Graphics g, int x, int y, MoeSyntaxDocument document, Color def, Element line, TabExpander tx) {
        this.paintLineMarkers(lineIndex, g, x - 24, y, document, line);
        if (document.getParsedNode() != null && syntaxHighlighting) {
            this.paintSyntaxLine(lineText, lineIndex, x, y, g, document, def, tx);
        } else {
            this.paintPlainLine(lineIndex, g, x, y);
        }
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        Rectangle bounds = allocation.getBounds();
        if (Boolean.FALSE.equals(this.getDocument().getProperty("compiled"))) {
            g.setColor(Color.lightGray);
            g.fillRect(0, 0, bounds.x + 14, bounds.y + bounds.height);
        }
        Rectangle clip = g.getClipBounds();
        g.setColor(new Color(240, 240, 240));
        g.drawLine(bounds.x + 24 - 1, clip.y, bounds.x + 24 - 1, clip.y + clip.height);
        int spos = this.viewToModel(bounds.x, clip.y, allocation, new Position.Bias[1]);
        int epos = this.viewToModel(bounds.x, clip.y + clip.height - 1, allocation, new Position.Bias[1]);
        MoeSyntaxDocument document = (MoeSyntaxDocument)this.getDocument();
        if (document.getParsedNode() != null) {
            Element map = this.getElement();
            int firstLine = map.getElementIndex(spos);
            int lastLine = map.getElementIndex(epos);
            this.paintScopeMarkers(g, document, allocation, firstLine, lastLine, false);
        }
        super.paint(g, allocation);
        g.setColor(Color.black);
        g.drawLine(bounds.x + 14, 0, bounds.x + 14, bounds.y + bounds.height);
    }
}

