/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.editor.moe.Token;
import bluej.utility.Debug;
import bluej.utility.Utility;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.StyleContext;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public class MoePrinter {
    static final String CONTINUED_LABEL = Config.getString((String)"editor.printer.continued");
    private final int HEADER_SPACE = 30;
    private final int FOOTER_SPACE = 20;
    private final int LINE_NUMBER_WIDTH = 20;
    private final int PADDING = 5;
    private Book pages = new Book();
    private static int titleFontSize = Config.getPropInteger((String)"bluej.fontsize.printTitle", (int)14);
    private static Font titleFont = new Font("SansSerif", 1, titleFontSize);
    private static Font smallTitleFont = new Font("SansSerif", 1, 10);
    private static Font footerFont = new Font("SansSerif", 2, 9);
    private static Font lineNumberFont = new Font("SansSerif", 0, 6);
    private String className;
    private int tabSize = Config.getPropInteger((String)"bluej.editor.tabsize", (int)4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean printDocument(PrinterJob printJob, MoeSyntaxDocument document, boolean lineNumbers, boolean syntaxHighlighting, String className, Font font, PageFormat format) {
        ArrayList<PrintLine> lines = new ArrayList<PrintLine>();
        this.className = className;
        Integer tabSizeAsInteger = (Integer)document.getProperty("tabSize");
        if (tabSizeAsInteger != null) {
            this.tabSize = tabSizeAsInteger;
        }
        try {
            document.readLock();
            Element root = document.getDefaultRootElement();
            int count = root.getElementCount();
            for (int i = 0; i < count; ++i) {
                Element lineElement = root.getElement(i);
                lines.add(this.removeNewLines(new PrintLine(document, lineElement, i + 1)));
            }
        }
        finally {
            document.readUnlock();
        }
        return this.printText(printJob, lines, font, document, lineNumbers, syntaxHighlighting, format);
    }

    private PrintLine removeNewLines(PrintLine line) {
        int lastChar;
        int length = line.length();
        int n = lastChar = length > 0 ? (int)line.charAt(line.length() - 1) : 97;
        while (lastChar == 10 || lastChar == 13 || lastChar == 32 || lastChar == 9) {
            line.chopLast();
            length = line.length();
            lastChar = length > 0 ? (int)line.charAt(line.length() - 1) : 97;
        }
        return line;
    }

    private synchronized boolean printText(PrinterJob job, List<PrintLine> text, Font font, MoeSyntaxDocument document, boolean lineNumbers, boolean syntaxHighlighting, PageFormat format) {
        try {
            this.pages = this.paginateText(text, format, document, lineNumbers, syntaxHighlighting, font);
            job.setPageable(this.pages);
            job.print();
            return true;
        }
        catch (Exception e) {
            Debug.reportError((String)("Exception thrown during printing: " + e));
            e.printStackTrace();
            return false;
        }
    }

    private Book paginateText(List<PrintLine> text, PageFormat pageFormat, MoeSyntaxDocument document, boolean lineNumbers, boolean syntaxHighlighting, Font font) {
        Book book = new Book();
        int height = (int)pageFormat.getImageableHeight() - 50;
        int linesPerPage = height / (font.getSize() + 2);
        this.wrapLines(text, pageFormat, lineNumbers, font);
        int numberOfPages = text.size() / linesPerPage + 1;
        ListIterator<PrintLine> li = text.listIterator();
        for (int pageNum = 1; pageNum <= numberOfPages; ++pageNum) {
            ArrayList<PrintLine> pageText = new ArrayList<PrintLine>();
            for (int lineCount = 0; li.hasNext() && lineCount < linesPerPage; ++lineCount) {
                pageText.add(li.next());
            }
            book.append(new MoePage(pageText, document, lineNumbers, syntaxHighlighting, font), pageFormat);
        }
        return book;
    }

    private void wrapLines(List<PrintLine> text, PageFormat format, boolean lineNumbers, Font font) {
        StyleContext context = new StyleContext();
        FontMetrics fontMetrics = context.getFontMetrics(font);
        int maxWidth = (int)format.getImageableWidth() - 10;
        if (lineNumbers) {
            maxWidth -= 20;
        }
        int fontWidth = fontMetrics.charWidth('m');
        int chars = maxWidth / fontWidth;
        ListIterator<PrintLine> li = text.listIterator();
        while (li.hasNext()) {
            PrintLine pl = li.next();
            String currentLine = Utility.convertTabsToSpaces((String)pl.toString(), (int)this.tabSize);
            int currentLineLength = currentLine.length();
            int width = fontMetrics.stringWidth(currentLine);
            if (width <= maxWidth) continue;
            int[] tabSpaces = Utility.calculateTabSpaces((String)pl.toString(), (int)this.tabSize);
            li.remove();
            int begin = 0;
            int end = 0;
            for (double iterations = (double)(currentLineLength / chars + 1); iterations > 0.0; iterations -= 1.0) {
                end = Utility.advanceChars((String)pl.toString(), (int[])tabSpaces, (int)begin, (int)chars);
                PrintLine newSubString = pl.substring(begin, end);
                if (newSubString.length() != 0) {
                    li.add(newSubString);
                }
                begin = Utility.advanceChars((String)pl.toString(), (int[])tabSpaces, (int)begin, (int)chars);
            }
        }
    }

    private class PrintLine
    implements CharSequence {
        private MoeSyntaxDocument document;
        private int startOffset;
        private int endOffset;
        private int lineNumber;

        public PrintLine(MoeSyntaxDocument document, int startOffset, int endOffset, int lineNumber) {
            this.document = document;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.lineNumber = lineNumber;
        }

        public PrintLine(MoeSyntaxDocument document, Element e, int lineNumber) {
            this.document = document;
            this.startOffset = e.getStartOffset();
            this.endOffset = e.getEndOffset();
            this.lineNumber = lineNumber;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        @Override
        public int length() {
            return this.endOffset - this.startOffset;
        }

        @Override
        public String toString() {
            try {
                if (this.length() == 0) {
                    return "";
                }
                return this.document.getText(this.startOffset, this.length());
            }
            catch (BadLocationException e) {
                Debug.reportError((String)("PrintLine.toString(), offsets: " + this.startOffset + " and " + this.endOffset), (Throwable)e);
                return null;
            }
        }

        @Override
        public char charAt(int n) {
            return this.toString().charAt(n);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.toString().subSequence(start, end);
        }

        public void chopLast() {
            if (this.endOffset > this.startOffset) {
                --this.endOffset;
            }
        }

        public PrintLine substring(int begin, int end) {
            return new PrintLine(this.document, begin + this.startOffset, end + this.startOffset, this.lineNumber);
        }

        public Segment getSegment() {
            try {
                Segment seg = new Segment();
                this.document.getText(this.getStartOffset(), this.getEndOffset() - this.getStartOffset(), seg);
                return seg;
            }
            catch (BadLocationException e) {
                Debug.reportError((String)("PrintLine.getSegment(), offsets: " + this.startOffset + " and " + this.endOffset), (Throwable)e);
                return null;
            }
        }
    }

    class MoePage
    implements Printable {
        private List<PrintLine> text;
        private MoeSyntaxDocument document;
        private boolean lineNumbers;
        private boolean syntaxHighlighting;
        private Font font;

        MoePage(List<PrintLine> text, MoeSyntaxDocument document, boolean lineNumbers, boolean syntaxHighlighting, Font font) {
            this.text = text;
            this.font = font;
            this.document = document;
            this.lineNumbers = lineNumbers;
            this.syntaxHighlighting = syntaxHighlighting;
        }

        @Override
        public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
            g.setFont(this.font);
            g.setColor(Color.black);
            int xPosition = (int)pageFormat.getImageableX();
            int yPosition = (int)pageFormat.getImageableY();
            int width = (int)pageFormat.getImageableWidth();
            int height = (int)pageFormat.getImageableHeight();
            StyleContext context = new StyleContext();
            FontMetrics fontMetrics = context.getFontMetrics(this.font);
            Color[] colors = MoeSyntaxDocument.getColors();
            Color def = Color.black;
            this.printHeader(g, pageIndex, xPosition, yPosition, width, 30);
            int textYPosition = yPosition + 30;
            int textXPosition = xPosition + 5 + (this.lineNumbers ? 20 : 0);
            g.drawRect(xPosition, textYPosition, width, height - 50);
            int lineNumberXPosition = xPosition + 5;
            int lastLineNumber = 0;
            if (this.lineNumbers) {
                g.drawLine(xPosition + 20, textYPosition, xPosition + 20, yPosition + height - 20);
            }
            ListIterator<PrintLine> li = this.text.listIterator();
            while (li.hasNext()) {
                int position = textYPosition + (this.font.getSize() + 2) * (li.nextIndex() + 1);
                PrintLine line = li.next();
                if (this.lineNumbers && line.getLineNumber() != lastLineNumber) {
                    g.setColor(Color.black);
                    g.setFont(lineNumberFont);
                    g.drawString(Integer.toString(line.getLineNumber()), lineNumberXPosition, position);
                    lastLineNumber = line.getLineNumber();
                    g.setFont(this.font);
                }
                int x = textXPosition;
                Token tokens = this.document.getParser().getMarkTokensFor(line.getStartOffset(), Math.min(line.getEndOffset(), this.document.getLength()) - line.getStartOffset(), 0, (Document)this.document);
                int offset = 0;
                while (tokens.id != 100) {
                    byte id = tokens.id;
                    int length = tokens.length;
                    Color color = id == 0 ? def : (id < colors.length ? colors[id] : def);
                    if (this.syntaxHighlighting) {
                        g.setColor(color == null ? def : color);
                    }
                    Segment lineSeg = line.getSegment();
                    lineSeg.count = length;
                    lineSeg.offset += offset;
                    if (lineSeg.count == 0) {
                        char[] chars = new char[]{' '};
                        Segment nonBlank = new Segment(chars, 0, 1);
                        x = Utilities.drawTabbedText(nonBlank, x, position, g, null, 0);
                    } else {
                        TabExpander tab = Utility.makeTabExpander((String)lineSeg.toString(), (int)MoePrinter.this.tabSize, (FontMetrics)fontMetrics);
                        x = Utilities.drawTabbedText(lineSeg, x, position, g, tab, offset);
                    }
                    offset += length;
                    tokens = tokens.next;
                }
            }
            int footerYPosition = yPosition + height - 20;
            this.printFooter(g, xPosition, footerYPosition, width, 20);
            return 0;
        }

        private void printHeader(Graphics g, int pageIndex, int xPos, int yPos, int width, int height) {
            g.setColor(Color.lightGray);
            g.fillRect(xPos, yPos, width, height);
            g.setColor(Color.black);
            g.drawRect(xPos, yPos, width, height);
            int titleYPos = yPos + 30 - this.font.getSize() + 2;
            String title = "Class " + MoePrinter.this.className;
            if (pageIndex == 0) {
                g.setFont(titleFont);
            } else {
                if (!"".equals(CONTINUED_LABEL) && !"editor.printer.continued".equals(CONTINUED_LABEL)) {
                    title = title + " (" + CONTINUED_LABEL + ")";
                }
                g.setFont(smallTitleFont);
            }
            g.drawString(title, xPos + 5, titleYPos);
            g.setFont(smallTitleFont);
            FontMetrics pfm = g.getFontMetrics(smallTitleFont);
            String pageInfo = pageIndex + 1 + "/" + MoePrinter.this.pages.getNumberOfPages();
            int pageInfoX = xPos + width - 5 - pfm.stringWidth(pageInfo);
            g.drawString(pageInfo, pageInfoX, titleYPos);
            g.setFont(this.font);
        }

        private void printFooter(Graphics g, int xPos, int yPos, int width, int height) {
            g.setFont(footerFont);
            FontMetrics pfm = g.getFontMetrics(footerFont);
            int footerTextYPos = yPos + 20 - this.font.getSize() + 2;
            Date today = new Date();
            DateFormat dateFormat = DateFormat.getDateTimeInstance();
            String date = dateFormat.format(today);
            int pageInfoX = xPos + width - 5 - pfm.stringWidth(date);
            g.drawString(date, pageInfoX, footerTextYPos);
            g.setFont(this.font);
        }
    }
}

