/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.editor.moe.MoeBorderHighlighterPainter;
import bluej.editor.moe.MoeDocumentListener;
import bluej.editor.moe.MoeEditor;
import bluej.editor.moe.MoeHighlighter;
import java.awt.Color;
import javax.swing.JEditorPane;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;

public class MoeErrorManager
implements MoeDocumentListener {
    private static final int ERR_DISPLAY_DELAY = 1000;
    private static final Color ERROR_HIGHLIGHT_GRADIENT1 = new Color(240, 128, 128);
    private static final Color ERROR_HIGHLIGHT_GRADIENT2 = new Color(240, 190, 190);
    private static final Color ERROR_HIGHLIGHT_SELECTED1 = ERROR_HIGHLIGHT_GRADIENT1;
    private static final Color ERROR_HIGHLIGHT_SELECTED2 = ERROR_HIGHLIGHT_GRADIENT2;
    private MoeEditor editor;
    private Object errorHighlightTag = null;
    private Timer timer;

    public MoeErrorManager(MoeEditor editor) {
        this.editor = editor;
    }

    public void addErrorHighlight(int startPos, int endPos) {
        JEditorPane sourcePane = this.editor.getSourcePane();
        try {
            MoeHighlighter highlighter = (MoeHighlighter)sourcePane.getHighlighter();
            MoeBorderHighlighterPainter painter = new MoeBorderHighlighterPainter(Color.RED, ERROR_HIGHLIGHT_GRADIENT1, ERROR_HIGHLIGHT_GRADIENT2, ERROR_HIGHLIGHT_SELECTED1, ERROR_HIGHLIGHT_SELECTED2);
            this.errorHighlightTag = highlighter.addHighlight(startPos, endPos, painter);
        }
        catch (BadLocationException ble) {
            throw new RuntimeException(ble);
        }
    }

    public void removeErrorHighlight() {
        if (this.errorHighlightTag != null) {
            JEditorPane sourcePane = this.editor.getSourcePane();
            sourcePane.getHighlighter().removeHighlight(this.errorHighlightTag);
            this.errorHighlightTag = null;
        }
    }

    public void insertUpdate(DocumentEvent e) {
    }

    public void removeUpdate(DocumentEvent e) {
    }

    public String getErrorAtPosition(int pos) {
        return null;
    }

    @Override
    public void parseError(int position, int size, String message) {
    }

    @Override
    public void reparsingRange(int position, int size) {
    }
}

