/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.CodeCompleteCellRenderer;
import bluej.editor.moe.MoeEditor;
import bluej.parser.AssistContent;
import bluej.parser.SourceLocation;
import bluej.parser.lexer.LocatableToken;
import bluej.prefmgr.PrefMgr;
import bluej.utility.JavaUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.html.HTMLEditorKit;

public class CodeCompletionDisplay
extends JFrame
implements ListSelectionListener,
MouseListener {
    private static final Color msgTextColor = new Color(200, 170, 100);
    private MoeEditor editor;
    private WindowListener editorListener;
    private AssistContent[] values;
    private String prefix;
    private String suggestionType;
    private SourceLocation prefixBegin;
    private SourceLocation prefixEnd;
    private JList methodList;
    private JEditorPane methodDescription;
    private JComponent pane;
    private CodeCompleteGlassPane myGlassPane;

    public CodeCompletionDisplay(MoeEditor ed, String suggestionType, AssistContent[] values, LocatableToken location) {
        this.values = values;
        this.suggestionType = suggestionType;
        this.makePanel();
        this.editor = ed;
        if (location != null) {
            this.prefixBegin = new SourceLocation(location.getLine(), location.getColumn());
            this.prefixEnd = new SourceLocation(location.getEndLine(), location.getEndColumn());
            this.prefix = location.getText();
        } else {
            this.prefixEnd = this.prefixBegin = this.editor.getCaretLocation();
            this.prefix = "";
        }
        this.populatePanel();
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                CodeCompletionDisplay.this.methodList.requestFocusInWindow();
                CodeCompletionDisplay.this.editor.getSourcePane().getCaret().setVisible(true);
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                CodeCompletionDisplay.this.doClose();
            }
        });
        this.editorListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CodeCompletionDisplay.this.doClose();
            }

            @Override
            public void windowIconified(WindowEvent e) {
                CodeCompletionDisplay.this.doClose();
            }
        };
        ed.addWindowListener(this.editorListener);
    }

    private void doClose() {
        this.editor.removeWindowListener(this.editorListener);
        this.dispose();
    }

    private void makePanel() {
        GridLayout gridL = new GridLayout(1, 2);
        this.pane = (JComponent)this.getContentPane();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(gridL);
        JPanel methodPanel = new JPanel();
        this.methodDescription = new JEditorPane();
        CompoundBorder mdBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(0, 10, 5, 10));
        this.methodDescription.setBorder(mdBorder);
        this.methodDescription.setEditable(false);
        this.methodDescription.setOpaque(false);
        this.methodDescription.setEditorKit(new HTMLEditorKit());
        this.methodDescription.setEditable(false);
        InputMap inputMap = new InputMap(){

            @Override
            public Object get(KeyStroke keyStroke) {
                Object action = super.get(keyStroke);
                if ("caret-up".equals(action) || "caret-down".equals(action)) {
                    return null;
                }
                return action;
            }
        };
        inputMap.setParent(this.methodDescription.getInputMap(0));
        this.methodDescription.setInputMap(0, inputMap);
        this.methodDescription.setBackground(new Color(0, 0, 0, 0));
        this.methodDescription.setFont(this.methodDescription.getFont().deriveFont((float)PrefMgr.getEditorFontSize()));
        this.methodList = new JList();
        this.methodList.setSelectionMode(0);
        this.methodList.addListSelectionListener(this);
        this.methodList.addMouseListener(this);
        this.methodList.requestFocusInWindow();
        this.methodList.setCellRenderer(new CodeCompleteCellRenderer(this.suggestionType));
        this.methodList.setOpaque(false);
        inputMap = new InputMap(){

            @Override
            public Object get(final KeyStroke keyStroke) {
                char keyChar;
                if (keyStroke.getKeyCode() == 27) {
                    return null;
                }
                if (keyStroke.getKeyChar() == '\b' && keyStroke.getKeyEventType() == 400) {
                    return new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (CodeCompletionDisplay.this.prefix.length() > 0) {
                                SourceLocation back = new SourceLocation(CodeCompletionDisplay.this.prefixEnd.getLine(), CodeCompletionDisplay.this.prefixEnd.getColumn() - 1);
                                CodeCompletionDisplay.this.editor.setSelection(back, CodeCompletionDisplay.this.prefixEnd);
                                CodeCompletionDisplay.this.editor.insertText("", false);
                                CodeCompletionDisplay.this.prefix = CodeCompletionDisplay.this.prefix.substring(0, CodeCompletionDisplay.this.prefix.length() - 1);
                                CodeCompletionDisplay.this.prefixEnd = CodeCompletionDisplay.this.editor.getCaretLocation();
                                CodeCompletionDisplay.this.updatePrefix();
                            }
                        }
                    };
                }
                Object actionName = super.get(keyStroke);
                if (actionName == null && keyStroke.getKeyEventType() == 400 && ((keyChar = keyStroke.getKeyChar()) >= ' ' && keyChar < '\u007f' || keyChar > '\u009f' && keyChar < '\uffff')) {
                    return new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            CodeCompletionDisplay.this.editor.insertText("" + keyStroke.getKeyChar(), false);
                            CodeCompletionDisplay.this.prefix = CodeCompletionDisplay.this.prefix + String.valueOf(keyStroke.getKeyChar());
                            CodeCompletionDisplay.this.prefixEnd = CodeCompletionDisplay.this.editor.getCaretLocation();
                            CodeCompletionDisplay.this.updatePrefix();
                        }
                    };
                }
                return actionName;
            }
        };
        inputMap.setParent(this.methodList.getInputMap(1));
        this.methodList.setInputMap(1, inputMap);
        ActionMap actionMap = new ActionMap(){

            @Override
            public Action get(Object key) {
                if (key instanceof Action) {
                    return (Action)key;
                }
                return super.get(key);
            }
        };
        actionMap.setParent(this.methodList.getActionMap());
        this.methodList.setActionMap(actionMap);
        Font mlFont = this.methodList.getFont();
        mlFont = mlFont.deriveFont((float)PrefMgr.getEditorFontSize());
        FontMetrics metrics = this.methodList.getFontMetrics(mlFont);
        Dimension size = new Dimension(metrics.charWidth('m') * 30, metrics.getHeight() * 15);
        GradientFillScrollPane scrollPane = new GradientFillScrollPane(this.methodList, new Color(250, 246, 229), new Color(233, 210, 132));
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setPreferredSize(size);
        methodPanel.add(scrollPane);
        methodPanel.setFont(mlFont);
        scrollPane = new GradientFillScrollPane(this.methodDescription, new Color(250, 246, 229), new Color(240, 220, 140));
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setPreferredSize(size);
        mainPanel.add(methodPanel);
        mainPanel.add(scrollPane);
        this.pane.add(mainPanel);
        inputMap = new InputMap();
        inputMap.setParent(this.pane.getRootPane().getInputMap(1));
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        inputMap.put(keyStroke, "escapeAction");
        keyStroke = KeyStroke.getKeyStroke(10, 0);
        inputMap.put(keyStroke, "completeAction");
        this.pane.getRootPane().setInputMap(1, inputMap);
        actionMap = new ActionMap(){

            @Override
            public Action get(Object key) {
                if (key instanceof Action) {
                    return (Action)key;
                }
                return super.get(key);
            }
        };
        actionMap.put("escapeAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeCompletionDisplay.this.doClose();
            }
        });
        actionMap.put("completeAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeCompletionDisplay.this.codeComplete();
            }
        });
        this.pane.getRootPane().setActionMap(actionMap);
        this.setDefaultCloseOperation(2);
        this.setUndecorated(true);
        this.setGlassPane(this.getCodeCompleteGlassPane());
        this.pack();
    }

    private void updatePrefix() {
        Vector<AssistContent> listData = new Vector<AssistContent>();
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.values[i].getDisplayName().startsWith(this.prefix)) continue;
            listData.add(this.values[i]);
        }
        this.methodList.setListData(listData);
        this.methodList.setSelectedIndex(0);
        this.getGlassPane().setVisible(listData.size() == 0);
    }

    private void populatePanel() {
        this.updatePrefix();
    }

    private void codeComplete() {
        AssistContent selected = (AssistContent)this.methodList.getSelectedValue();
        if (selected != null) {
            String completion = selected.getCompletionText();
            String completionSel = selected.getCompletionTextSel();
            String completionPost = selected.getCompletionTextPost();
            boolean hasParameters = selected.hasParameters();
            this.editor.setSelection(this.prefixBegin, this.prefixEnd);
            this.editor.insertText(completion, false);
            SourceLocation selLoc = this.editor.getCaretLocation();
            this.editor.insertText(completionSel, false);
            this.editor.insertText(completionPost, hasParameters);
            if (hasParameters) {
                this.editor.setSelection(selLoc.getLine(), selLoc.getColumn(), completionSel.length());
            }
        }
        this.setVisible(false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int count = e.getClickCount();
        if (count == 2) {
            this.codeComplete();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        AssistContent selected = (AssistContent)this.methodList.getSelectedValue();
        if (selected != null) {
            String jdHtml = selected.getJavadoc();
            jdHtml = jdHtml != null ? JavaUtils.javadocToHtml((String)jdHtml) : "";
            String sig = CodeCompletionDisplay.escapeAngleBrackets(selected.getReturnType()) + " <b>" + CodeCompletionDisplay.escapeAngleBrackets(selected.getDisplayMethodName()) + "</b>" + CodeCompletionDisplay.escapeAngleBrackets(selected.getDisplayMethodParams());
            jdHtml = "<h3>" + selected.getDeclaringClass() + "</h3>" + "<blockquote><tt>" + sig + "</tt></blockquote><br>" + jdHtml;
            this.methodDescription.setText(jdHtml);
            this.methodDescription.setCaretPosition(0);
        } else {
            this.methodDescription.setText("");
        }
    }

    private static String escapeAngleBrackets(String sig) {
        return sig.replace("<", "&lt;").replace(">", "&gt;");
    }

    private CodeCompleteGlassPane getCodeCompleteGlassPane() {
        if (this.myGlassPane == null) {
            this.myGlassPane = new CodeCompleteGlassPane();
        }
        return this.myGlassPane;
    }

    class CodeCompleteGlassPane
    extends JComponent {
        CodeCompleteGlassPane() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            Color origColor = g.getColor();
            Font origFont = g.getFont();
            g.setColor(msgTextColor);
            g.setFont(origFont.deriveFont(20.0f));
            g.drawString(Config.getString((String)"editor.completion.noMatch"), 30, 60);
            g.setColor(origColor);
            g.setFont(origFont);
        }
    }

    private static class GradientFillScrollPane
    extends JScrollPane {
        private Color topColor;
        private Color bottomColor;

        private GradientFillScrollPane(Component view, Color topColor, Color bottomColor) {
            super(view);
            this.getViewport().setOpaque(false);
            this.topColor = topColor;
            this.bottomColor = bottomColor;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                int w = this.getWidth();
                int h = this.getHeight();
                GradientPaint gp = new GradientPaint(0.0f, 0.0f, this.topColor, 0.0f, h, this.bottomColor);
                Paint origPaint = g2d.getPaint();
                g2d.setPaint(gp);
                g2d.fillRect(0, 0, w, h);
                g2d.setPaint(origPaint);
            }
        }
    }
}

