/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.global;

public class TransactionalSupport {
    static final boolean DEBUG = System.getProperty(TransactionalSupport.class.getName()) != null;
    private final Object transactionLock = new Object();
    private final ThreadLocal interruptedFlag = new ThreadLocal();
    private final ThreadLocal lockRead = new ThreadLocal();
    private final ThreadLocal lockWrite = new ThreadLocal();
    private boolean lockedExclusively = false;
    private boolean lockedShared = false;
    private int sharedLockCount = 0;

    public void beginTrans(boolean bl) {
        this.beginTrans(bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beginTrans(boolean bl, boolean bl2) {
        if (DEBUG) {
            System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Starting transaction: mutable = " + bl + ", failEarly = " + bl2);
        }
        Object object = this.transactionLock;
        synchronized (object) {
            boolean bl3 = false;
            do {
                if ((bl3 = bl ? this.lockExclusively() : this.lockShared()) || bl2) continue;
                if (DEBUG) {
                    System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Couldn't start transaction. Going to wait for some time");
                }
                boolean bl4 = false;
                do {
                    bl4 = false;
                    try {
                        this.transactionLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        this.interruptedFlag.set(new Object());
                        bl4 = true;
                        Thread.interrupted();
                    }
                } while (bl4);
            } while (!bl3 && !bl2);
            return bl3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTrans() {
        Object object = this.transactionLock;
        synchronized (object) {
            int n;
            Integer n2 = (Integer)this.lockRead.get();
            Integer n3 = (Integer)this.lockWrite.get();
            if (n2 == null) {
                this.unlockShared();
            } else {
                if (DEBUG) {
                    System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Releasing ownership for a shared lock");
                }
                if ((n = n2.intValue()) > 1) {
                    this.lockRead.set(n - 1);
                } else {
                    this.lockRead.set(null);
                    this.unlockShared();
                }
            }
            if (n3 == null) {
                if (DEBUG) {
                    System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Unlocking an exclusive lock");
                }
                this.lockedExclusively = false;
            } else {
                if (DEBUG) {
                    System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Releasing ownership for an exclusive lock");
                }
                if ((n = n3.intValue()) > 1) {
                    this.lockWrite.set(n - 1);
                } else {
                    this.lockWrite.set(null);
                    if (DEBUG) {
                        System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Unlocking an exclusive lock");
                    }
                    this.lockedExclusively = false;
                }
            }
            this.transactionLock.notifyAll();
        }
        this.rethrowInterrupt();
    }

    private boolean lockExclusively() {
        if (this.lockedShared) {
            return this.promoteToExclusive();
        }
        if (this.lockedExclusively) {
            return this.relockExclusively();
        }
        if (DEBUG) {
            System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Grabbing an exclusive lock for transaction");
        }
        this.lockedExclusively = true;
        this.lockWrite.set(1);
        return true;
    }

    private boolean lockShared() {
        if (this.lockedExclusively) {
            return this.relockExclusively();
        }
        if (DEBUG) {
            System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Grabbing shared lock for transaction");
        }
        this.lockedShared = true;
        Integer n = (Integer)this.lockRead.get();
        if (n == null) {
            this.lockRead.set(1);
            ++this.sharedLockCount;
        } else {
            this.lockRead.set(n + 1);
        }
        boolean bl = true;
        return bl;
    }

    private boolean promoteToExclusive() {
        boolean bl;
        if (this.sharedLockCount > 1) {
            System.err.println("WARNING: [" + Thread.currentThread().getName() + "] Cant promote a shared lock held by " + this.sharedLockCount + " threads!");
            return false;
        }
        Integer n = (Integer)this.lockRead.get();
        if (n != null) {
            if (DEBUG) {
                System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Promoting a previously owned shared lock to the exclusive one");
            }
            this.lockedShared = false;
            this.sharedLockCount = 0;
            this.lockedExclusively = true;
            this.lockWrite.set(n + 1);
            this.lockRead.set(null);
            bl = true;
        } else {
            if (DEBUG) {
                System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Failed to promote a previously owned shared lock");
            }
            bl = false;
        }
        return bl;
    }

    private boolean relockExclusively() {
        boolean bl;
        Integer n = (Integer)this.lockWrite.get();
        if (n != null) {
            if (DEBUG) {
                System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Relocking a previously owned exclusive lock");
            }
            this.lockWrite.set(n + 1);
            bl = true;
        } else {
            if (DEBUG) {
                System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Failed to relock an exclusive lock. Not an owner.");
            }
            bl = false;
        }
        return bl;
    }

    private void rethrowInterrupt() {
        if (this.interruptedFlag.get() != null) {
            Thread.currentThread().interrupt();
            this.interruptedFlag.set(null);
        }
    }

    private void unlockShared() {
        if (DEBUG) {
            System.out.println("DEBUG: [" + Thread.currentThread().getName() + "] Unlocking a shared lock");
        }
        this.lockedShared = false;
        if (this.sharedLockCount > 0) {
            --this.sharedLockCount;
        }
    }
}

