/*
 * Decompiled with CFR 0.152.
 */
package bluej.doclet.doclets.internal.toolkit.builders;

import bluej.doclet.doclets.internal.toolkit.Configuration;
import bluej.doclet.doclets.internal.toolkit.FieldWriter;
import bluej.doclet.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import bluej.doclet.doclets.internal.toolkit.util.VisibleMemberMap;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FieldBuilder
extends AbstractMemberBuilder {
    private ClassDoc classDoc;
    private VisibleMemberMap visibleMemberMap;
    private FieldWriter writer;
    private List fields;
    private int currentFieldIndex;

    private FieldBuilder(Configuration configuration) {
        super(configuration);
    }

    public static FieldBuilder getInstance(Configuration configuration, ClassDoc classDoc, FieldWriter writer) {
        FieldBuilder builder = new FieldBuilder(configuration);
        builder.classDoc = classDoc;
        builder.writer = writer;
        builder.visibleMemberMap = new VisibleMemberMap(classDoc, 2, configuration.nodeprecated);
        builder.fields = new ArrayList(builder.visibleMemberMap.getLeafClassMembers(configuration));
        if (configuration.getMemberComparator() != null) {
            Collections.sort(builder.fields, configuration.getMemberComparator());
        }
        return builder;
    }

    @Override
    public String getName() {
        return "FieldDetails";
    }

    @Override
    public void invokeMethod(String methodName, Class[] paramClasses, Object[] params) throws Exception {
        Method method = this.getClass().getMethod(methodName, paramClasses);
        method.invoke((Object)this, params);
    }

    public List members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    @Override
    public boolean hasMembersToDocument() {
        return this.fields.size() > 0;
    }

    public void buildFieldDoc(List elements) {
        if (this.writer == null) {
            return;
        }
        this.currentFieldIndex = 0;
        while (this.currentFieldIndex < this.fields.size()) {
            this.build(elements);
            ++this.currentFieldIndex;
        }
    }

    public void buildHeader() {
        this.writer.writeHeader(this.classDoc, this.configuration.getText("doclet.Field_Detail"));
    }

    public void buildFieldHeader() {
        this.writer.writeFieldHeader((FieldDoc)this.fields.get(this.currentFieldIndex), this.currentFieldIndex == 0);
    }

    public void buildSignature() {
        this.writer.writeSignature((FieldDoc)this.fields.get(this.currentFieldIndex));
    }

    public void buildDeprecationInfo() {
        this.writer.writeDeprecated((FieldDoc)this.fields.get(this.currentFieldIndex));
    }

    public void buildFieldComments() {
        if (!this.configuration.nocomment) {
            this.writer.writeComments((FieldDoc)this.fields.get(this.currentFieldIndex));
        }
    }

    public void buildTagInfo() {
        this.writer.writeTags((FieldDoc)this.fields.get(this.currentFieldIndex));
    }

    public void buildFieldFooter() {
        this.writer.writeFieldFooter();
    }

    public void buildFooter() {
        this.writer.writeFooter(this.classDoc);
    }

    public FieldWriter getWriter() {
        return this.writer;
    }
}

