/*
 * Decompiled with CFR 0.152.
 */
package bluej.doclet.doclets.formats.html;

import bluej.doclet.doclets.formats.html.ConfigurationImpl;
import bluej.doclet.doclets.formats.html.SubWriterHolderWriter;
import bluej.doclet.doclets.internal.toolkit.util.ClassUseMapper;
import bluej.doclet.doclets.internal.toolkit.util.DirectoryManager;
import bluej.doclet.doclets.internal.toolkit.util.DocletAbortException;
import bluej.doclet.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class PackageUseWriter
extends SubWriterHolderWriter {
    final PackageDoc pkgdoc;
    final SortedMap usingPackageToUsedClasses = new TreeMap();

    public PackageUseWriter(ConfigurationImpl configuration, ClassUseMapper mapper, String filename, PackageDoc pkgdoc) throws IOException {
        super(configuration, DirectoryManager.getDirectoryPath(pkgdoc), filename, DirectoryManager.getRelativePath(pkgdoc.name()));
        this.pkgdoc = pkgdoc;
        ClassDoc[] content = pkgdoc.allClasses();
        for (int i = 0; i < content.length; ++i) {
            ClassDoc usedClass = content[i];
            Set usingClasses = (Set)mapper.classToClass.get(usedClass.qualifiedName());
            if (usingClasses == null) continue;
            for (ClassDoc usingClass : usingClasses) {
                PackageDoc usingPackage = usingClass.containingPackage();
                TreeSet<ClassDoc> usedClasses = (TreeSet<ClassDoc>)this.usingPackageToUsedClasses.get(usingPackage.name());
                if (usedClasses == null) {
                    usedClasses = new TreeSet<ClassDoc>();
                    this.usingPackageToUsedClasses.put(Util.getPackageName(usingPackage), usedClasses);
                }
                usedClasses.add(usedClass);
            }
        }
    }

    public static void generate(ConfigurationImpl configuration, ClassUseMapper mapper, PackageDoc pkgdoc) {
        String filename = "package-use.html";
        try {
            PackageUseWriter pkgusegen = new PackageUseWriter(configuration, mapper, filename, pkgdoc);
            pkgusegen.generatePackageUseFile();
            pkgusegen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generatePackageUseFile() throws IOException {
        this.printPackageUseHeader();
        if (this.usingPackageToUsedClasses.isEmpty()) {
            this.printText("doclet.ClassUse_No.usage.of.0", this.pkgdoc.name());
            this.p();
        } else {
            this.generatePackageUse();
        }
        this.printPackageUseFooter();
    }

    protected void generatePackageUse() throws IOException {
        if (this.configuration.packages.length > 1) {
            this.generatePackageList();
        }
        this.generateClassList();
    }

    protected void generatePackageList() throws IOException {
        this.tableIndexSummary();
        this.tableHeaderStart("#CCCCFF");
        this.printText("doclet.ClassUse_Packages.that.use.0", this.getPackageLink(this.pkgdoc, Util.getPackageName(this.pkgdoc), false));
        this.tableHeaderEnd();
        Iterator it = this.usingPackageToUsedClasses.keySet().iterator();
        while (it.hasNext()) {
            PackageDoc pkg = this.configuration.root.packageNamed((String)it.next());
            this.generatePackageUse(pkg);
        }
        this.tableEnd();
        this.space();
        this.p();
    }

    protected void generateClassList() throws IOException {
        for (String packageName : this.usingPackageToUsedClasses.keySet()) {
            PackageDoc usingPackage = this.configuration.root.packageNamed(packageName);
            if (usingPackage != null) {
                this.anchor(usingPackage.name());
            }
            this.tableIndexSummary();
            this.tableHeaderStart("#CCCCFF");
            this.printText("doclet.ClassUse_Classes.in.0.used.by.1", this.getPackageLink(this.pkgdoc, Util.getPackageName(this.pkgdoc), false), this.getPackageLink(usingPackage, Util.getPackageName(usingPackage), false));
            this.tableHeaderEnd();
            Iterator itc = ((Collection)this.usingPackageToUsedClasses.get(packageName)).iterator();
            while (itc.hasNext()) {
                this.printClassRow((ClassDoc)itc.next(), packageName);
            }
            this.tableEnd();
            this.space();
            this.p();
        }
    }

    protected void printClassRow(ClassDoc usedClass, String packageName) {
        String path = this.pathString(usedClass, "class-use/" + usedClass.name() + ".html");
        this.trBgcolorStyle("white", "TableRowColor");
        this.summaryRow(0);
        this.bold();
        this.printHyperLink(path, packageName, usedClass.name(), true);
        this.boldEnd();
        this.println();
        this.br();
        this.printNbsps();
        this.printIndexComment((Doc)usedClass);
        this.summaryRowEnd();
        this.trEnd();
    }

    protected void generatePackageUse(PackageDoc pkg) throws IOException {
        this.trBgcolorStyle("white", "TableRowColor");
        this.summaryRow(0);
        this.printHyperLink("", pkg.name(), Util.getPackageName(pkg), true);
        this.summaryRowEnd();
        this.summaryRow(0);
        if (pkg != null) {
            this.printSummaryComment((Doc)pkg);
        }
        this.space();
        this.summaryRowEnd();
        this.trEnd();
    }

    protected void printPackageUseHeader() {
        String packageLabel = this.configuration.getText("doclet.Package");
        String name = this.pkgdoc.name();
        this.printHtmlHeader(this.configuration.getText("doclet.Window_ClassUse_Header", packageLabel, name), null, true);
        this.printTop();
        this.navLinks(true);
        this.hr();
        this.center();
        this.h2();
        this.boldText("doclet.ClassUse_Title", packageLabel, name);
        this.h2End();
        this.centerEnd();
    }

    protected void printPackageUseFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    @Override
    protected void navLinkPackage() {
        this.navCellStart();
        this.printHyperLink("package-summary.html", "", this.configuration.getText("doclet.Package"), true, "NavBarFont1");
        this.navCellEnd();
    }

    @Override
    protected void navLinkClassUse() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.navClassUse");
        this.fontEnd();
        this.navCellEnd();
    }

    @Override
    protected void navLinkTree() {
        this.navCellStart();
        this.printHyperLink("package-tree.html", "", this.configuration.getText("doclet.Tree"), true, "NavBarFont1");
        this.navCellEnd();
    }
}

