/*
 * Decompiled with CFR 0.152.
 */
package bluej.doclet.doclets.formats.html;

import bluej.doclet.doclets.formats.html.ConfigurationImpl;
import bluej.doclet.doclets.formats.html.HtmlDocletWriter;
import bluej.doclet.doclets.formats.html.LinkInfoImpl;
import bluej.doclet.doclets.internal.toolkit.util.DocletAbortException;
import bluej.doclet.doclets.internal.toolkit.util.IndexBuilder;
import bluej.doclet.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import java.io.IOException;
import java.util.List;

public class AllClassesFrameWriter
extends HtmlDocletWriter {
    public static final String OUTPUT_FILE_NAME_FRAMES = "allclasses-frame.html";
    public static final String OUTPUT_FILE_NAME_NOFRAMES = "allclasses-noframe.html";
    protected IndexBuilder indexbuilder;

    public AllClassesFrameWriter(ConfigurationImpl configuration, String filename, IndexBuilder indexbuilder) throws IOException {
        super(configuration, filename);
        this.indexbuilder = indexbuilder;
    }

    public static void generate(ConfigurationImpl configuration, IndexBuilder indexbuilder) {
        String filename = OUTPUT_FILE_NAME_FRAMES;
        try {
            AllClassesFrameWriter allclassgen = new AllClassesFrameWriter(configuration, filename, indexbuilder);
            allclassgen.generateAllClassesFile(true);
            allclassgen.close();
            filename = OUTPUT_FILE_NAME_NOFRAMES;
            allclassgen = new AllClassesFrameWriter(configuration, filename, indexbuilder);
            allclassgen.generateAllClassesFile(false);
            allclassgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generateAllClassesFile(boolean wantFrames) throws IOException {
        String label = this.configuration.getText("doclet.All_Classes");
        this.printHtmlHeader(label, null, false);
        this.printAllClassesTableHeader();
        this.printAllClasses(wantFrames);
        this.printAllClassesTableFooter();
        this.printBodyHtmlEnd();
    }

    protected void printAllClasses(boolean wantFrames) {
        for (int i = 0; i < this.indexbuilder.elements().length; ++i) {
            Character unicode = (Character)this.indexbuilder.elements()[i];
            this.generateContents(this.indexbuilder.getMemberList(unicode), wantFrames);
        }
    }

    protected void generateContents(List classlist, boolean wantFrames) {
        for (int i = 0; i < classlist.size(); ++i) {
            ClassDoc cd = (ClassDoc)classlist.get(i);
            if (!Util.isCoreClass(cd)) continue;
            String label = this.italicsClassName(cd, false);
            if (wantFrames) {
                this.printLink(new LinkInfoImpl(1, cd, label, "classFrame"));
            } else {
                this.printLink(new LinkInfoImpl(cd, label));
            }
            this.br();
        }
    }

    protected void printAllClassesTableHeader() {
        this.fontSizeStyle("+1", "FrameHeadingFont");
        this.boldText("doclet.All_Classes");
        this.fontEnd();
        this.br();
        this.table();
        this.tr();
        this.tdNowrap();
        this.fontStyle("FrameItemFont");
    }

    protected void printAllClassesTableFooter() {
        this.fontEnd();
        this.tdEnd();
        this.trEnd();
        this.tableEnd();
    }
}

