/*
 * Decompiled with CFR 0.152.
 */
package bluej.doclet.doclets.formats.html;

import bluej.doclet.doclets.formats.html.AbstractMemberWriter;
import bluej.doclet.doclets.formats.html.LinkInfoImpl;
import bluej.doclet.doclets.formats.html.SubWriterHolderWriter;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Type;

public abstract class AbstractExecutableMemberWriter
extends AbstractMemberWriter {
    public AbstractExecutableMemberWriter(SubWriterHolderWriter writer, ClassDoc classdoc) {
        super(writer, classdoc);
    }

    public AbstractExecutableMemberWriter(SubWriterHolderWriter writer) {
        super(writer);
    }

    protected int writeTypeParameters(ExecutableMemberDoc member) {
        LinkInfoImpl linkInfo = new LinkInfoImpl(32, member, false);
        String typeParameters = this.writer.getTypeParameterLinks(linkInfo);
        if (linkInfo.displayLength > 0) {
            this.writer.print(typeParameters + " ");
            this.writer.displayLength += linkInfo.displayLength + 1;
        }
        return linkInfo.displayLength;
    }

    protected void writeSignature(ExecutableMemberDoc member) {
        this.writer.displayLength = 0;
        this.writer.pre();
        this.writer.writeAnnotationInfo((ProgramElementDoc)member);
        this.printModifiers((MemberDoc)member);
        this.writeTypeParameters(member);
        if (this.configuration().linksource && member.position().line() != this.classdoc.position().line()) {
            this.writer.printSrcLink((ProgramElementDoc)member, member.name());
        } else {
            this.bold(member.name());
        }
        this.writeParameters(member);
        this.writeExceptions(member);
        this.writer.preEnd();
    }

    @Override
    protected void writeDeprecatedLink(ProgramElementDoc member) {
        ExecutableMemberDoc emd = (ExecutableMemberDoc)member;
        this.writer.printDocLink(3, (MemberDoc)emd, emd.qualifiedName() + emd.flatSignature(), false);
    }

    @Override
    protected void writeSummaryLink(int context, ClassDoc cd, ProgramElementDoc member) {
        ExecutableMemberDoc emd = (ExecutableMemberDoc)member;
        String name = emd.name();
        this.writer.bold();
        this.writer.printDocLink(context, cd, (MemberDoc)emd, name, false);
        this.writer.boldEnd();
        this.writer.displayLength = name.length();
        this.writeParameters(emd, false);
    }

    @Override
    protected void writeInheritedSummaryLink(ClassDoc cd, ProgramElementDoc member) {
        this.writer.printDocLink(3, cd, (MemberDoc)member, member.name(), false);
    }

    protected void writeParam(ExecutableMemberDoc member, Parameter param, boolean isVarArg) {
        if (param.type() != null) {
            this.writer.printLink(new LinkInfoImpl(18, param.type(), isVarArg));
        }
        if (param.name().length() > 0) {
            this.writer.space();
            this.writer.print(param.name());
        }
    }

    protected void writeParameters(ExecutableMemberDoc member) {
        this.writeParameters(member, true);
    }

    protected void writeParameters(ExecutableMemberDoc member, boolean includeAnnotations) {
        boolean foundAnnotations;
        this.print('(');
        Parameter[] params = member.parameters();
        String indent = this.makeSpace(this.writer.displayLength);
        if (this.configuration().linksource) {
            indent = indent + this.makeSpace(member.name().length());
        }
        for (int paramstart = 0; paramstart < params.length; ++paramstart) {
            Parameter param = params[paramstart];
            if (param.name().startsWith("this$")) continue;
            if (includeAnnotations && (foundAnnotations = this.writer.writeAnnotationInfo(indent.length(), (Doc)member, param))) {
                this.writer.println();
                this.writer.print(indent);
            }
            this.writeParam(member, param, paramstart == params.length - 1 && member.isVarArgs());
            break;
        }
        for (int i = paramstart + 1; i < params.length; ++i) {
            this.writer.print(',');
            this.writer.println();
            this.writer.print(indent);
            if (includeAnnotations && (foundAnnotations = this.writer.writeAnnotationInfo(indent.length(), (Doc)member, params[i]))) {
                this.writer.println();
                this.writer.print(indent);
            }
            this.writeParam(member, params[i], i == params.length - 1 && member.isVarArgs());
        }
        this.writer.print(')');
    }

    protected void writeExceptions(ExecutableMemberDoc member) {
        Type[] exceptions = member.thrownExceptionTypes();
        if (exceptions.length > 0) {
            LinkInfoImpl memberTypeParam = new LinkInfoImpl(3, member, false);
            int retlen = this.getReturnTypeLength(member);
            this.writer.getTypeParameterLinks(memberTypeParam);
            String indent = this.makeSpace(this.modifierString((MemberDoc)member).length() + member.name().length() + (retlen += memberTypeParam.displayLength == 0 ? 0 : memberTypeParam.displayLength + 1) - 4);
            this.writer.println();
            this.writer.print(indent);
            this.writer.print("throws ");
            indent = indent + "       ";
            this.writer.printLink(new LinkInfoImpl(3, exceptions[0]));
            for (int i = 1; i < exceptions.length; ++i) {
                this.writer.println(",");
                this.writer.print(indent);
                this.writer.printLink(new LinkInfoImpl(3, exceptions[i]));
            }
        }
    }

    protected int getReturnTypeLength(ExecutableMemberDoc member) {
        if (member instanceof MethodDoc) {
            MethodDoc method = (MethodDoc)member;
            Type rettype = method.returnType();
            if (rettype.isPrimitive()) {
                return rettype.typeName().length() + rettype.dimension().length();
            }
            LinkInfoImpl linkInfo = new LinkInfoImpl(3, rettype);
            this.writer.getLink(linkInfo);
            return linkInfo.displayLength;
        }
        return -1;
    }

    protected ClassDoc implementsMethodInIntfac(MethodDoc method, ClassDoc[] intfacs) {
        for (int i = 0; i < intfacs.length; ++i) {
            MethodDoc[] methods = intfacs[i].methods();
            if (methods.length <= 0) continue;
            for (int j = 0; j < methods.length; ++j) {
                if (!methods[j].name().equals(method.name()) || !methods[j].signature().equals(method.signature())) continue;
                return intfacs[i];
            }
        }
        return null;
    }

    protected String getErasureAnchor(ExecutableMemberDoc emd) {
        StringBuffer buf = new StringBuffer(emd.name() + "(");
        Parameter[] params = emd.parameters();
        boolean foundTypeVariable = false;
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            Type t = params[i].type();
            foundTypeVariable = foundTypeVariable || t.asTypeVariable() != null;
            buf.append(t.isPrimitive() ? t.typeName() : t.asClassDoc().qualifiedName());
            buf.append(t.dimension());
        }
        buf.append(")");
        return foundTypeVariable ? buf.toString() : null;
    }
}

