/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class BasicHashtableEntry
extends VMObject {
    private static CIntegerField hashField;
    private static AddressField nextField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("BasicHashtableEntry");
        hashField = type.getCIntegerField("_hash");
        nextField = type.getAddressField("_next");
    }

    public long hash() {
        return hashField.getValue(this.addr) & 0xFFFFFFFFL;
    }

    private long nextAddressValue() {
        JVMDebugger dbg = VM.getVM().getDebugger();
        Address nextValue = nextField.getValue(this.addr);
        return nextValue != null ? dbg.getAddressValue(nextValue) : 0L;
    }

    public boolean isShared() {
        return (this.nextAddressValue() & 1L) != 0L;
    }

    public BasicHashtableEntry next() {
        Address nextValue = nextField.getValue(this.addr);
        Address next = nextValue != null ? nextValue.andWithMask(-2L) : null;
        return (BasicHashtableEntry)VMObjectFactory.newObject(this.getClass(), next);
    }

    public BasicHashtableEntry(Address addr) {
        super(addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                BasicHashtableEntry.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

