/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import sun.awt.CGraphicsConfig;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.CGLLayer;
import sun.java2d.opengl.CGLSurfaceData;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.macosx.CFRetainedResource;
import sun.lwawt.macosx.CPlatformResponder;
import sun.lwawt.macosx.CWrapper;
import sun.lwawt.macosx.LWCToolkit;
import sun.lwawt.macosx.event.NSEvent;

public class CPlatformView
extends CFRetainedResource {
    private LWWindowPeer peer;
    private SurfaceData surfaceData;
    private CGLLayer windowLayer;
    private CPlatformResponder responder;

    private native long nativeCreateView(int var1, int var2, int var3, int var4, long var5);

    public CPlatformView() {
        super(0L, true);
    }

    public void initialize(LWWindowPeer lWWindowPeer, CPlatformResponder cPlatformResponder) {
        this.peer = lWWindowPeer;
        this.responder = cPlatformResponder;
        if (!LWCToolkit.getSunAwtDisableCALayers()) {
            this.windowLayer = new CGLLayer(lWWindowPeer);
        }
        this.setPtr(this.nativeCreateView(0, 0, 0, 0, this.getWindowLayerPtr()));
    }

    public long getAWTView() {
        return this.ptr;
    }

    public boolean isOpaque() {
        return this.peer.isOpaque();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        CWrapper.NSView.setFrame(this.ptr, n, n2, n3, n4);
    }

    public Rectangle getBounds() {
        return this.peer.getBounds();
    }

    public Object getDestination() {
        return this.peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterFullScreenMode(long l) {
        Rectangle rectangle;
        CWrapper.NSView.enterFullScreenMode(this.ptr);
        Insets insets = this.peer.getInsets();
        long l2 = CWrapper.NSWindow.screen(l);
        try {
            rectangle = CWrapper.NSScreen.frame(l2).getBounds();
        }
        finally {
            CWrapper.NSObject.release(l2);
        }
        this.peer.notifyReshape(rectangle.x - insets.left, rectangle.y - insets.bottom, rectangle.width + insets.left + insets.right, rectangle.height + insets.top + insets.bottom);
    }

    public void exitFullScreenMode() {
        CWrapper.NSView.exitFullScreenMode(this.ptr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawImageOnPeer(VolatileImage volatileImage, int n, int n2, int n3, int n4) {
        Graphics graphics = this.peer.getGraphics();
        try {
            graphics.drawImage(volatileImage, n, n2, n3, n4, n, n2, n3, n4, null);
        }
        finally {
            graphics.dispose();
        }
    }

    public Image createBackBuffer() {
        Rectangle rectangle = this.peer.getBounds();
        BufferedImage bufferedImage = null;
        if (!rectangle.isEmpty()) {
            int n = this.isOpaque() ? 1 : 3;
            bufferedImage = this.peer.getGraphicsConfiguration().createCompatibleImage(rectangle.width, rectangle.height, n);
        }
        return bufferedImage;
    }

    public SurfaceData replaceSurfaceData() {
        if (!LWCToolkit.getSunAwtDisableCALayers()) {
            this.surfaceData = this.windowLayer.replaceSurfaceData();
        } else if (this.surfaceData == null) {
            CGraphicsConfig cGraphicsConfig = (CGraphicsConfig)this.peer.getGraphicsConfiguration();
            this.surfaceData = cGraphicsConfig.createSurfaceData(this);
        } else {
            this.validateSurface();
        }
        return this.surfaceData;
    }

    private void validateSurface() {
        if (this.surfaceData != null) {
            ((CGLSurfaceData)this.surfaceData).validate();
        }
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.peer.getGraphicsConfiguration();
    }

    public SurfaceData getSurfaceData() {
        return this.surfaceData;
    }

    @Override
    public void dispose() {
        if (!LWCToolkit.getSunAwtDisableCALayers()) {
            this.windowLayer.dispose();
        }
        super.dispose();
    }

    public long getWindowLayerPtr() {
        if (!LWCToolkit.getSunAwtDisableCALayers()) {
            return this.windowLayer.getPointer();
        }
        return 0L;
    }

    private void deliverMouseEvent(NSEvent nSEvent) {
        int n = nSEvent.getX();
        int n2 = this.getBounds().height - nSEvent.getY();
        if (nSEvent.getType() == 22) {
            this.responder.handleScrollEvent(n, n2, nSEvent.getModifierFlags(), nSEvent.getScrollDeltaX(), nSEvent.getScrollDeltaY());
        } else {
            this.responder.handleMouseEvent(nSEvent.getType(), nSEvent.getModifierFlags(), nSEvent.getButtonNumber(), nSEvent.getClickCount(), n, n2, nSEvent.getAbsX(), nSEvent.getAbsY());
        }
    }

    private void deliverKeyEvent(NSEvent nSEvent) {
        this.responder.handleKeyEvent(nSEvent.getType(), nSEvent.getModifierFlags(), nSEvent.getCharactersIgnoringModifiers(), nSEvent.getKeyCode(), true);
    }

    private void deliverWindowDidExposeEvent() {
        Rectangle rectangle = this.peer.getBounds();
        this.peer.notifyExpose(0, 0, rectangle.width, rectangle.height);
    }

    private void deliverWindowDidExposeEvent(float f, float f2, float f3, float f4) {
        this.peer.notifyExpose((int)f, (int)f2, (int)f3, (int)f4);
    }
}

