/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AudioFloatConverter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public abstract class AudioFloatInputStream {
    public static AudioFloatInputStream getInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        return new DirectAudioFloatInputStream(AudioSystem.getAudioInputStream(uRL));
    }

    public static AudioFloatInputStream getInputStream(File file) throws UnsupportedAudioFileException, IOException {
        return new DirectAudioFloatInputStream(AudioSystem.getAudioInputStream(file));
    }

    public static AudioFloatInputStream getInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        return new DirectAudioFloatInputStream(AudioSystem.getAudioInputStream(inputStream));
    }

    public static AudioFloatInputStream getInputStream(AudioInputStream audioInputStream) {
        return new DirectAudioFloatInputStream(audioInputStream);
    }

    public static AudioFloatInputStream getInputStream(AudioFormat audioFormat, byte[] byArray, int n, int n2) {
        AudioFloatConverter audioFloatConverter = AudioFloatConverter.getConverter(audioFormat);
        if (audioFloatConverter != null) {
            return new BytaArrayAudioFloatInputStream(audioFloatConverter, byArray, n, n2);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        long l = audioFormat.getFrameSize() == -1 ? -1L : (long)(n2 / audioFormat.getFrameSize());
        AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, audioFormat, l);
        return AudioFloatInputStream.getInputStream(audioInputStream);
    }

    public abstract AudioFormat getFormat();

    public abstract long getFrameLength();

    public abstract int read(float[] var1, int var2, int var3) throws IOException;

    public int read(float[] fArray) throws IOException {
        return this.read(fArray, 0, fArray.length);
    }

    public float read() throws IOException {
        float[] fArray = new float[1];
        int n = this.read(fArray, 0, 1);
        if (n == -1 || n == 0) {
            return 0.0f;
        }
        return fArray[0];
    }

    public abstract long skip(long var1) throws IOException;

    public abstract int available() throws IOException;

    public abstract void close() throws IOException;

    public abstract void mark(int var1);

    public abstract boolean markSupported();

    public abstract void reset() throws IOException;

    private static class DirectAudioFloatInputStream
    extends AudioFloatInputStream {
        private AudioInputStream stream;
        private AudioFloatConverter converter;
        private int framesize_pc;
        private byte[] buffer;

        public DirectAudioFloatInputStream(AudioInputStream audioInputStream) {
            this.converter = AudioFloatConverter.getConverter(audioInputStream.getFormat());
            if (this.converter == null) {
                AudioFormat audioFormat;
                AudioFormat audioFormat2 = audioInputStream.getFormat();
                AudioFormat[] audioFormatArray = AudioSystem.getTargetFormats(AudioFormat.Encoding.PCM_SIGNED, audioFormat2);
                if (audioFormatArray.length != 0) {
                    audioFormat = audioFormatArray[0];
                } else {
                    float f = audioFormat2.getSampleRate();
                    int n = audioFormat2.getSampleSizeInBits();
                    int n2 = audioFormat2.getFrameSize();
                    float f2 = audioFormat2.getFrameRate();
                    n = 16;
                    n2 = audioFormat2.getChannels() * (n / 8);
                    f2 = f;
                    audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, f, n, audioFormat2.getChannels(), n2, f2, false);
                }
                audioInputStream = AudioSystem.getAudioInputStream(audioFormat, audioInputStream);
                this.converter = AudioFloatConverter.getConverter(audioInputStream.getFormat());
            }
            this.framesize_pc = audioInputStream.getFormat().getFrameSize() / audioInputStream.getFormat().getChannels();
            this.stream = audioInputStream;
        }

        @Override
        public AudioFormat getFormat() {
            return this.stream.getFormat();
        }

        @Override
        public long getFrameLength() {
            return this.stream.getFrameLength();
        }

        @Override
        public int read(float[] fArray, int n, int n2) throws IOException {
            int n3;
            int n4 = n2 * this.framesize_pc;
            if (this.buffer == null || this.buffer.length < n4) {
                this.buffer = new byte[n4];
            }
            if ((n3 = this.stream.read(this.buffer, 0, n4)) == -1) {
                return -1;
            }
            this.converter.toFloatArray(this.buffer, fArray, n, n3 / this.framesize_pc);
            return n3 / this.framesize_pc;
        }

        @Override
        public long skip(long l) throws IOException {
            long l2 = l * (long)this.framesize_pc;
            long l3 = this.stream.skip(l2);
            if (l3 == -1L) {
                return -1L;
            }
            return l3 / (long)this.framesize_pc;
        }

        @Override
        public int available() throws IOException {
            return this.stream.available() / this.framesize_pc;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }

        @Override
        public void mark(int n) {
            this.stream.mark(n * this.framesize_pc);
        }

        @Override
        public boolean markSupported() {
            return this.stream.markSupported();
        }

        @Override
        public void reset() throws IOException {
            this.stream.reset();
        }
    }

    private static class BytaArrayAudioFloatInputStream
    extends AudioFloatInputStream {
        private int pos = 0;
        private int markpos = 0;
        private AudioFloatConverter converter;
        private AudioFormat format;
        private byte[] buffer;
        private int buffer_offset;
        private int buffer_len;
        private int framesize_pc;

        public BytaArrayAudioFloatInputStream(AudioFloatConverter audioFloatConverter, byte[] byArray, int n, int n2) {
            this.converter = audioFloatConverter;
            this.format = audioFloatConverter.getFormat();
            this.buffer = byArray;
            this.buffer_offset = n;
            this.framesize_pc = this.format.getFrameSize() / this.format.getChannels();
            this.buffer_len = n2 / this.framesize_pc;
        }

        @Override
        public AudioFormat getFormat() {
            return this.format;
        }

        @Override
        public long getFrameLength() {
            return this.buffer_len;
        }

        @Override
        public int read(float[] fArray, int n, int n2) throws IOException {
            if (fArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || n2 > fArray.length - n) {
                throw new IndexOutOfBoundsException();
            }
            if (this.pos >= this.buffer_len) {
                return -1;
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.pos + n2 > this.buffer_len) {
                n2 = this.buffer_len - this.pos;
            }
            this.converter.toFloatArray(this.buffer, this.buffer_offset + this.pos * this.framesize_pc, fArray, n, n2);
            this.pos += n2;
            return n2;
        }

        @Override
        public long skip(long l) throws IOException {
            if (this.pos >= this.buffer_len) {
                return -1L;
            }
            if (l <= 0L) {
                return 0L;
            }
            if ((long)this.pos + l > (long)this.buffer_len) {
                l = this.buffer_len - this.pos;
            }
            this.pos = (int)((long)this.pos + l);
            return l;
        }

        @Override
        public int available() throws IOException {
            return this.buffer_len - this.pos;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void mark(int n) {
            this.markpos = this.pos;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void reset() throws IOException {
            this.pos = this.markpos;
        }
    }
}

