/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaMenuBarUI;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class AquaRootPaneUI
extends BasicRootPaneUI
implements AncestorListener,
WindowListener,
ContainerListener {
    private static final AquaUtils.RecyclableSingleton<AquaRootPaneUI> sRootPaneUI = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaRootPaneUI>(AquaRootPaneUI.class);
    static final int kDefaultButtonPaintDelayBetweenFrames = 50;
    JButton fCurrentDefaultButton = null;
    Timer fTimer = null;
    static final boolean sUseScreenMenuBar = AquaMenuBarUI.getScreenMenuBarProperty();

    public static ComponentUI createUI(JComponent jComponent) {
        return sRootPaneUI.get();
    }

    @Override
    public void installUI(JComponent jComponent) {
        Container container;
        Color color;
        Container container2;
        super.installUI(jComponent);
        jComponent.addAncestorListener(this);
        if (jComponent.isShowing() && jComponent.isEnabled()) {
            this.updateDefaultButton((JRootPane)jComponent);
        }
        if ((container2 = jComponent.getParent()) != null && container2 instanceof JFrame && ((color = ((Window)(container = (JFrame)container2)).getBackground()) == null || color instanceof UIResource)) {
            ((Frame)container).setBackground(UIManager.getColor("Panel.background"));
        }
        if (sUseScreenMenuBar) {
            container = (JRootPane)jComponent;
            container.addContainerListener(this);
            ((JRootPane)container).getLayeredPane().addContainerListener(this);
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.stopTimer();
        jComponent.removeAncestorListener(this);
        if (sUseScreenMenuBar) {
            JRootPane jRootPane = (JRootPane)jComponent;
            jRootPane.removeContainerListener(this);
            jRootPane.getLayeredPane().removeContainerListener(this);
        }
        super.uninstallUI(jComponent);
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        Window window;
        JMenuBar jMenuBar;
        MenuBarUI menuBarUI;
        if (containerEvent.getContainer() instanceof JRootPane) {
            JRootPane jRootPane = (JRootPane)containerEvent.getContainer();
            if (containerEvent.getChild() == jRootPane.getLayeredPane()) {
                JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
                jLayeredPane.addContainerListener(this);
            }
        } else if (containerEvent.getChild() instanceof JMenuBar && (menuBarUI = (jMenuBar = (JMenuBar)containerEvent.getChild()).getUI()) instanceof AquaMenuBarUI && (window = SwingUtilities.getWindowAncestor(jMenuBar)) != null && window instanceof JFrame) {
            ((AquaMenuBarUI)menuBarUI).setScreenMenuBar((JFrame)window);
        }
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        Window window;
        JMenuBar jMenuBar;
        MenuBarUI menuBarUI;
        if (containerEvent.getContainer() instanceof JRootPane) {
            JRootPane jRootPane = (JRootPane)containerEvent.getContainer();
            if (containerEvent.getChild() == jRootPane.getLayeredPane()) {
                JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
                jLayeredPane.removeContainerListener(this);
            }
        } else if (containerEvent.getChild() instanceof JMenuBar && (menuBarUI = (jMenuBar = (JMenuBar)containerEvent.getChild()).getUI()) instanceof AquaMenuBarUI && (window = SwingUtilities.getWindowAncestor(jMenuBar)) != null && window instanceof JFrame) {
            ((AquaMenuBarUI)menuBarUI).clearScreenMenuBar((JFrame)window);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JRootPane jRootPane;
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if ("defaultButton".equals(string) || "temporaryDefaultButton".equals(string)) {
            JRootPane jRootPane2 = (JRootPane)propertyChangeEvent.getSource();
            if (jRootPane2.isShowing() && jRootPane2.isEnabled()) {
                this.updateDefaultButton(jRootPane2);
            }
        } else if (("enabled".equals(string) || "Frame.active".equals(string)) && (jRootPane = (JRootPane)propertyChangeEvent.getSource()).isShowing()) {
            if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                this.updateDefaultButton((JRootPane)propertyChangeEvent.getSource());
            } else {
                this.stopTimer();
            }
        }
    }

    synchronized void stopTimer() {
        if (this.fTimer != null) {
            this.fTimer.stop();
            this.fTimer = null;
        }
    }

    synchronized void updateDefaultButton(JRootPane jRootPane) {
        JButton jButton;
        this.fCurrentDefaultButton = jButton = jRootPane.getDefaultButton();
        this.stopTimer();
        if (jButton != null) {
            this.fTimer = new Timer(50, new DefaultButtonPainter(jRootPane));
            this.fTimer.start();
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        JRootPane jRootPane;
        JComponent jComponent;
        JComponent jComponent2 = ancestorEvent.getComponent();
        Window window = SwingUtilities.getWindowAncestor(jComponent2);
        if (window != null) {
            window.removeWindowListener(this);
            window.addWindowListener(this);
        }
        if ((jComponent = ancestorEvent.getComponent()) instanceof JRootPane && (jRootPane = (JRootPane)jComponent).isEnabled() && jRootPane.getDefaultButton() != null) {
            this.updateDefaultButton((JRootPane)jComponent);
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        AquaRootPaneUI.updateComponentTreeUIActivation((Component)windowEvent.getSource(), Boolean.TRUE);
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        AquaRootPaneUI.updateComponentTreeUIActivation((Component)windowEvent.getSource(), Boolean.FALSE);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        window.removeWindowListener(this);
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowStateChanged(WindowEvent windowEvent) {
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    public void windowLostFocus(WindowEvent windowEvent) {
    }

    private static void updateComponentTreeUIActivation(Component component, Object object) {
        if (component instanceof JInternalFrame) {
            Object object2 = object = ((JInternalFrame)component).isSelected() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (component instanceof JComponent) {
            ((JComponent)component).putClientProperty("Frame.active", object);
        }
        Component[] componentArray = null;
        if (component instanceof JMenu) {
            componentArray = ((JMenu)component).getMenuComponents();
        } else if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray == null) {
            return;
        }
        for (Component component2 : componentArray) {
            AquaRootPaneUI.updateComponentTreeUIActivation(component2, object);
        }
    }

    class DefaultButtonPainter
    implements ActionListener {
        JRootPane root;

        public DefaultButtonPainter(JRootPane jRootPane) {
            this.root = jRootPane;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = this.root.getDefaultButton();
            if (jButton != null && jButton.isShowing()) {
                if (jButton.isEnabled()) {
                    jButton.repaint();
                }
            } else {
                AquaRootPaneUI.this.stopTimer();
            }
        }
    }
}

