/*
 * Decompiled with CFR 0.152.
 */
package com.apple.eawt;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.AppEventListener;
import com.apple.eawt.AppForegroundListener;
import com.apple.eawt.AppHiddenListener;
import com.apple.eawt.AppReOpenedListener;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.OpenURIHandler;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.PrintFilesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import com.apple.eawt.QuitStrategy;
import com.apple.eawt.ScreenSleepListener;
import com.apple.eawt.SystemSleepListener;
import com.apple.eawt.UserSessionListener;
import com.apple.eawt._AppEventLegacyHandler;
import com.apple.eawt._AppMenuBarHandler;
import com.apple.eawt._OpenAppHandler;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

class _AppEventHandler {
    private static final int NOTIFY_ABOUT = 1;
    private static final int NOTIFY_PREFS = 2;
    private static final int NOTIFY_OPEN_APP = 3;
    private static final int NOTIFY_REOPEN_APP = 4;
    private static final int NOTIFY_QUIT = 5;
    private static final int NOTIFY_SHUTDOWN = 6;
    private static final int NOTIFY_ACTIVE_APP_GAINED = 7;
    private static final int NOTIFY_ACTIVE_APP_LOST = 8;
    private static final int NOTIFY_APP_HIDDEN = 9;
    private static final int NOTIFY_APP_SHOWN = 10;
    private static final int NOTIFY_USER_SESSION_ACTIVE = 11;
    private static final int NOTIFY_USER_SESSION_INACTIVE = 12;
    private static final int NOTIFY_SCREEN_SLEEP = 13;
    private static final int NOTIFY_SCREEN_WAKE = 14;
    private static final int NOTIFY_SYSTEM_SLEEP = 15;
    private static final int NOTIFY_SYSTEM_WAKE = 16;
    private static final int REGISTER_USER_SESSION = 1;
    private static final int REGISTER_SCREEN_SLEEP = 2;
    private static final int REGISTER_SYSTEM_SLEEP = 3;
    static final _AppEventHandler instance = new _AppEventHandler();
    final _AboutDispatcher aboutDispatcher = new _AboutDispatcher();
    final _PreferencesDispatcher preferencesDispatcher = new _PreferencesDispatcher();
    final _OpenFileDispatcher openFilesDispatcher = new _OpenFileDispatcher();
    final _PrintFileDispatcher printFilesDispatcher = new _PrintFileDispatcher();
    final _OpenURIDispatcher openURIDispatcher = new _OpenURIDispatcher();
    final _QuitDispatcher quitDispatcher = new _QuitDispatcher();
    final _OpenAppDispatcher openAppDispatcher = new _OpenAppDispatcher();
    final _AppReOpenedDispatcher reOpenAppDispatcher = new _AppReOpenedDispatcher();
    final _AppForegroundDispatcher foregroundAppDispatcher = new _AppForegroundDispatcher();
    final _HiddenAppDispatcher hiddenAppDispatcher = new _HiddenAppDispatcher();
    final _UserSessionDispatcher userSessionDispatcher = new _UserSessionDispatcher();
    final _ScreenSleepDispatcher screenSleepDispatcher = new _ScreenSleepDispatcher();
    final _SystemSleepDispatcher systemSleepDispatcher = new _SystemSleepDispatcher();
    final _AppEventLegacyHandler legacyHandler = new _AppEventLegacyHandler(this);
    QuitStrategy defaultQuitAction = QuitStrategy.SYSTEM_EXIT_0;
    QuitResponse currentQuitResponse;

    private static native void nativeOpenCocoaAboutWindow();

    private static native void nativeReplyToAppShouldTerminate(boolean var0);

    private static native void nativeRegisterForNotification(int var0);

    static _AppEventHandler getInstance() {
        return instance;
    }

    _AppEventHandler() {
        String string = System.getProperty("apple.eawt.quitStrategy");
        if (string == null) {
            return;
        }
        if ("CLOSE_ALL_WINDOWS".equals(string)) {
            this.setDefaultQuitStrategy(QuitStrategy.CLOSE_ALL_WINDOWS);
        } else if ("SYSTEM_EXIT_O".equals(string)) {
            this.setDefaultQuitStrategy(QuitStrategy.SYSTEM_EXIT_0);
        } else {
            System.err.println("unrecognized apple.eawt.quitStrategy: " + string);
        }
    }

    void addListener(AppEventListener appEventListener) {
        if (appEventListener instanceof AppReOpenedListener) {
            this.reOpenAppDispatcher.addListener((AppReOpenedListener)appEventListener);
        }
        if (appEventListener instanceof AppForegroundListener) {
            this.foregroundAppDispatcher.addListener((AppForegroundListener)appEventListener);
        }
        if (appEventListener instanceof AppHiddenListener) {
            this.hiddenAppDispatcher.addListener((AppHiddenListener)appEventListener);
        }
        if (appEventListener instanceof UserSessionListener) {
            this.userSessionDispatcher.addListener((UserSessionListener)appEventListener);
        }
        if (appEventListener instanceof ScreenSleepListener) {
            this.screenSleepDispatcher.addListener((ScreenSleepListener)appEventListener);
        }
        if (appEventListener instanceof SystemSleepListener) {
            this.systemSleepDispatcher.addListener((SystemSleepListener)appEventListener);
        }
    }

    void removeListener(AppEventListener appEventListener) {
        if (appEventListener instanceof AppReOpenedListener) {
            this.reOpenAppDispatcher.removeListener((AppReOpenedListener)appEventListener);
        }
        if (appEventListener instanceof AppForegroundListener) {
            this.foregroundAppDispatcher.removeListener((AppForegroundListener)appEventListener);
        }
        if (appEventListener instanceof AppHiddenListener) {
            this.hiddenAppDispatcher.removeListener((AppHiddenListener)appEventListener);
        }
        if (appEventListener instanceof UserSessionListener) {
            this.userSessionDispatcher.removeListener((UserSessionListener)appEventListener);
        }
        if (appEventListener instanceof ScreenSleepListener) {
            this.screenSleepDispatcher.removeListener((ScreenSleepListener)appEventListener);
        }
        if (appEventListener instanceof SystemSleepListener) {
            this.systemSleepDispatcher.removeListener((SystemSleepListener)appEventListener);
        }
    }

    void openCocoaAboutWindow() {
        _AppEventHandler.nativeOpenCocoaAboutWindow();
    }

    void setDefaultQuitStrategy(QuitStrategy quitStrategy) {
        this.defaultQuitAction = quitStrategy;
    }

    synchronized QuitResponse obtainQuitResponse() {
        if (this.currentQuitResponse != null) {
            return this.currentQuitResponse;
        }
        this.currentQuitResponse = new QuitResponse(this);
        return this.currentQuitResponse;
    }

    synchronized void cancelQuit() {
        this.currentQuitResponse = null;
        _AppEventHandler.nativeReplyToAppShouldTerminate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void performQuit() {
        this.currentQuitResponse = null;
        try {
            if (this.defaultQuitAction == QuitStrategy.SYSTEM_EXIT_0) {
                System.exit(0);
            }
            if (this.defaultQuitAction != QuitStrategy.CLOSE_ALL_WINDOWS) {
                throw new RuntimeException("Unknown quit action");
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Frame[] frameArray = Frame.getFrames();
                    for (int i = frameArray.length - 1; i >= 0; --i) {
                        Frame frame = frameArray[i];
                        frame.dispatchEvent(new WindowEvent(frame, 201));
                    }
                }
            });
        }
        finally {
            _AppEventHandler.nativeReplyToAppShouldTerminate(false);
        }
    }

    private static void handlePrintFiles(List<String> list) {
        _AppEventHandler.instance.printFilesDispatcher.dispatch(new _NativeEvent(list));
    }

    private static void handleOpenFiles(List<String> list, String string) {
        _AppEventHandler.instance.openFilesDispatcher.dispatch(new _NativeEvent(list, string));
    }

    private static void handleOpenURI(String string) {
        _AppEventHandler.instance.openURIDispatcher.dispatch(new _NativeEvent(string));
    }

    private static void handleNativeNotification(int n) {
        switch (n) {
            case 1: {
                _AppEventHandler.instance.aboutDispatcher.dispatch(new _NativeEvent(new Object[0]));
                break;
            }
            case 2: {
                _AppEventHandler.instance.preferencesDispatcher.dispatch(new _NativeEvent(new Object[0]));
                break;
            }
            case 3: {
                _AppEventHandler.instance.openAppDispatcher.dispatch(new _NativeEvent(new Object[0]));
                break;
            }
            case 4: {
                _AppEventHandler.instance.reOpenAppDispatcher.dispatch(new _NativeEvent(new Object[0]), new Object[0]);
                break;
            }
            case 5: {
                _AppEventHandler.instance.quitDispatcher.dispatch(new _NativeEvent(new Object[0]));
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                _AppEventHandler.instance.foregroundAppDispatcher.dispatch(new _NativeEvent(Boolean.TRUE), new Object[0]);
                break;
            }
            case 8: {
                _AppEventHandler.instance.foregroundAppDispatcher.dispatch(new _NativeEvent(Boolean.FALSE), new Object[0]);
                break;
            }
            case 9: {
                _AppEventHandler.instance.hiddenAppDispatcher.dispatch(new _NativeEvent(Boolean.TRUE), new Object[0]);
                break;
            }
            case 10: {
                _AppEventHandler.instance.hiddenAppDispatcher.dispatch(new _NativeEvent(Boolean.FALSE), new Object[0]);
                break;
            }
            case 11: {
                _AppEventHandler.instance.userSessionDispatcher.dispatch(new _NativeEvent(Boolean.TRUE), new Object[0]);
                break;
            }
            case 12: {
                _AppEventHandler.instance.userSessionDispatcher.dispatch(new _NativeEvent(Boolean.FALSE), new Object[0]);
                break;
            }
            case 13: {
                _AppEventHandler.instance.screenSleepDispatcher.dispatch(new _NativeEvent(Boolean.TRUE), new Object[0]);
                break;
            }
            case 14: {
                _AppEventHandler.instance.screenSleepDispatcher.dispatch(new _NativeEvent(Boolean.FALSE), new Object[0]);
                break;
            }
            case 15: {
                _AppEventHandler.instance.systemSleepDispatcher.dispatch(new _NativeEvent(Boolean.TRUE), new Object[0]);
                break;
            }
            case 16: {
                _AppEventHandler.instance.systemSleepDispatcher.dispatch(new _NativeEvent(Boolean.FALSE), new Object[0]);
                break;
            }
            default: {
                System.err.println("EAWT unknown native notification: " + n);
            }
        }
    }

    abstract class _QueuingAppEventDispatcher<H>
    extends _AppEventDispatcher<H> {
        List<_NativeEvent> queuedEvents;

        _QueuingAppEventDispatcher() {
            this.queuedEvents = new LinkedList<_NativeEvent>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void dispatch(_NativeEvent _NativeEvent2) {
            _QueuingAppEventDispatcher _QueuingAppEventDispatcher2 = this;
            synchronized (_QueuingAppEventDispatcher2) {
                if (this.queuedEvents != null) {
                    this.queuedEvents.add(_NativeEvent2);
                    return;
                }
            }
            super.dispatch(_NativeEvent2);
        }

        @Override
        synchronized void setHandler(H h) {
            this._handler = h;
            if (this.queuedEvents != null) {
                List<_NativeEvent> list = this.queuedEvents;
                this.queuedEvents = null;
                if (list.size() != 0) {
                    for (_NativeEvent _NativeEvent2 : list) {
                        this.dispatch(_NativeEvent2);
                    }
                }
            }
            if (h == _AppEventHandler.this.legacyHandler) {
                return;
            }
            _AppEventHandler.this.legacyHandler.blockLegacyAPI();
        }
    }

    abstract class _AppEventDispatcher<H> {
        H _handler;

        _AppEventDispatcher() {
        }

        void dispatch(final _NativeEvent _NativeEvent2) {
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object h;
                    _AppEventDispatcher _AppEventDispatcher2 = _AppEventDispatcher.this;
                    synchronized (_AppEventDispatcher2) {
                        h = _AppEventDispatcher.this._handler;
                    }
                    if (h == null) {
                        _AppEventDispatcher.this.performDefaultAction(_NativeEvent2);
                    } else {
                        _AppEventDispatcher.this.performUsing(h, _NativeEvent2);
                    }
                }
            });
        }

        synchronized void setHandler(H h) {
            this._handler = h;
            if (h == _AppEventHandler.this.legacyHandler) {
                return;
            }
            _AppEventHandler.this.legacyHandler.blockLegacyAPI();
        }

        void performDefaultAction(_NativeEvent _NativeEvent2) {
        }

        abstract void performUsing(H var1, _NativeEvent var2);
    }

    abstract class _BooleanAppEventMultiplexor<L, E>
    extends _AppEventMultiplexor<L> {
        _BooleanAppEventMultiplexor() {
        }

        @Override
        void performOnListeners(List<L> list, _NativeEvent _NativeEvent2) {
            boolean bl = Boolean.TRUE.equals(_NativeEvent2.get(0));
            E e = this.createEvent(bl);
            if (bl) {
                for (L l : list) {
                    this.performTrueEventOn(l, e);
                }
            } else {
                for (L l : list) {
                    this.performFalseEventOn(l, e);
                }
            }
        }

        abstract E createEvent(boolean var1);

        abstract void performTrueEventOn(L var1, E var2);

        abstract void performFalseEventOn(L var1, E var2);
    }

    abstract class _AppEventMultiplexor<L> {
        final List<L> _listeners = new ArrayList<L>(0);
        boolean nativeListenerRegistered;

        _AppEventMultiplexor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatch(final _NativeEvent _NativeEvent2, Object ... objectArray) {
            ArrayList<L> arrayList;
            _AppEventMultiplexor _AppEventMultiplexor2 = this;
            synchronized (_AppEventMultiplexor2) {
                if (this._listeners.size() == 0) {
                    return;
                }
                arrayList = new ArrayList<L>(this._listeners);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    _AppEventMultiplexor.this.performOnListeners(arrayList, _NativeEvent2);
                }
            });
        }

        synchronized void addListener(L l) {
            if (!this.nativeListenerRegistered) {
                this.registerNativeListener();
                this.nativeListenerRegistered = true;
            }
            this._listeners.add(l);
        }

        synchronized void removeListener(L l) {
            this._listeners.remove(l);
        }

        abstract void performOnListeners(List<L> var1, _NativeEvent var2);

        void registerNativeListener() {
        }
    }

    static class _NativeEvent {
        Object[] args;

        public _NativeEvent(Object ... objectArray) {
            this.args = objectArray;
        }

        <T> T get(int n) {
            if (this.args == null) {
                return null;
            }
            return (T)this.args[n];
        }
    }

    class _QuitDispatcher
    extends _AppEventDispatcher<QuitHandler> {
        _QuitDispatcher() {
        }

        @Override
        void performDefaultAction(_NativeEvent _NativeEvent2) {
            _AppEventHandler.this.obtainQuitResponse().performQuit();
        }

        @Override
        void performUsing(QuitHandler quitHandler, _NativeEvent _NativeEvent2) {
            QuitResponse quitResponse = _AppEventHandler.this.obtainQuitResponse();
            quitHandler.handleQuitRequestWith(new AppEvent.QuitEvent(), quitResponse);
        }
    }

    class _OpenURIDispatcher
    extends _QueuingAppEventDispatcher<OpenURIHandler> {
        _OpenURIDispatcher() {
        }

        @Override
        void performUsing(OpenURIHandler openURIHandler, _NativeEvent _NativeEvent2) {
            String string = (String)_NativeEvent2.get(0);
            try {
                openURIHandler.openURI(new AppEvent.OpenURIEvent(new URI(string)));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
        }
    }

    class _PrintFileDispatcher
    extends _QueuingAppEventDispatcher<PrintFilesHandler> {
        _PrintFileDispatcher() {
        }

        @Override
        void performUsing(PrintFilesHandler printFilesHandler, _NativeEvent _NativeEvent2) {
            List list = (List)_NativeEvent2.get(0);
            ArrayList<File> arrayList = new ArrayList<File>(list.size());
            for (String string : list) {
                arrayList.add(new File(string));
            }
            printFilesHandler.printFiles(new AppEvent.PrintFilesEvent(arrayList));
        }
    }

    class _OpenFileDispatcher
    extends _QueuingAppEventDispatcher<OpenFilesHandler> {
        _OpenFileDispatcher() {
        }

        @Override
        void performUsing(OpenFilesHandler openFilesHandler, _NativeEvent _NativeEvent2) {
            List list = (List)_NativeEvent2.get(0);
            ArrayList<File> arrayList = new ArrayList<File>(list.size());
            for (String string : list) {
                arrayList.add(new File(string));
            }
            String string = (String)_NativeEvent2.get(1);
            openFilesHandler.openFiles(new AppEvent.OpenFilesEvent(arrayList, string));
        }
    }

    class _SystemSleepDispatcher
    extends _BooleanAppEventMultiplexor<SystemSleepListener, AppEvent.SystemSleepEvent> {
        _SystemSleepDispatcher() {
        }

        @Override
        AppEvent.SystemSleepEvent createEvent(boolean bl) {
            return new AppEvent.SystemSleepEvent();
        }

        @Override
        void performFalseEventOn(SystemSleepListener systemSleepListener, AppEvent.SystemSleepEvent systemSleepEvent) {
            systemSleepListener.systemAwoke(systemSleepEvent);
        }

        @Override
        void performTrueEventOn(SystemSleepListener systemSleepListener, AppEvent.SystemSleepEvent systemSleepEvent) {
            systemSleepListener.systemAboutToSleep(systemSleepEvent);
        }

        @Override
        void registerNativeListener() {
            _AppEventHandler.nativeRegisterForNotification(3);
        }
    }

    class _ScreenSleepDispatcher
    extends _BooleanAppEventMultiplexor<ScreenSleepListener, AppEvent.ScreenSleepEvent> {
        _ScreenSleepDispatcher() {
        }

        @Override
        AppEvent.ScreenSleepEvent createEvent(boolean bl) {
            return new AppEvent.ScreenSleepEvent();
        }

        @Override
        void performFalseEventOn(ScreenSleepListener screenSleepListener, AppEvent.ScreenSleepEvent screenSleepEvent) {
            screenSleepListener.screenAwoke(screenSleepEvent);
        }

        @Override
        void performTrueEventOn(ScreenSleepListener screenSleepListener, AppEvent.ScreenSleepEvent screenSleepEvent) {
            screenSleepListener.screenAboutToSleep(screenSleepEvent);
        }

        @Override
        void registerNativeListener() {
            _AppEventHandler.nativeRegisterForNotification(2);
        }
    }

    class _UserSessionDispatcher
    extends _BooleanAppEventMultiplexor<UserSessionListener, AppEvent.UserSessionEvent> {
        _UserSessionDispatcher() {
        }

        @Override
        AppEvent.UserSessionEvent createEvent(boolean bl) {
            return new AppEvent.UserSessionEvent();
        }

        @Override
        void performFalseEventOn(UserSessionListener userSessionListener, AppEvent.UserSessionEvent userSessionEvent) {
            userSessionListener.userSessionDeactivated(userSessionEvent);
        }

        @Override
        void performTrueEventOn(UserSessionListener userSessionListener, AppEvent.UserSessionEvent userSessionEvent) {
            userSessionListener.userSessionActivated(userSessionEvent);
        }

        @Override
        void registerNativeListener() {
            _AppEventHandler.nativeRegisterForNotification(1);
        }
    }

    class _HiddenAppDispatcher
    extends _BooleanAppEventMultiplexor<AppHiddenListener, AppEvent.AppHiddenEvent> {
        _HiddenAppDispatcher() {
        }

        @Override
        AppEvent.AppHiddenEvent createEvent(boolean bl) {
            return new AppEvent.AppHiddenEvent();
        }

        @Override
        void performFalseEventOn(AppHiddenListener appHiddenListener, AppEvent.AppHiddenEvent appHiddenEvent) {
            appHiddenListener.appUnhidden(appHiddenEvent);
        }

        @Override
        void performTrueEventOn(AppHiddenListener appHiddenListener, AppEvent.AppHiddenEvent appHiddenEvent) {
            appHiddenListener.appHidden(appHiddenEvent);
        }
    }

    class _AppForegroundDispatcher
    extends _BooleanAppEventMultiplexor<AppForegroundListener, AppEvent.AppForegroundEvent> {
        _AppForegroundDispatcher() {
        }

        @Override
        AppEvent.AppForegroundEvent createEvent(boolean bl) {
            return new AppEvent.AppForegroundEvent();
        }

        @Override
        void performFalseEventOn(AppForegroundListener appForegroundListener, AppEvent.AppForegroundEvent appForegroundEvent) {
            appForegroundListener.appMovedToBackground(appForegroundEvent);
        }

        @Override
        void performTrueEventOn(AppForegroundListener appForegroundListener, AppEvent.AppForegroundEvent appForegroundEvent) {
            appForegroundListener.appRaisedToForeground(appForegroundEvent);
        }
    }

    class _AppReOpenedDispatcher
    extends _AppEventMultiplexor<AppReOpenedListener> {
        _AppReOpenedDispatcher() {
        }

        @Override
        void performOnListeners(List<AppReOpenedListener> list, _NativeEvent _NativeEvent2) {
            AppEvent.AppReOpenedEvent appReOpenedEvent = new AppEvent.AppReOpenedEvent();
            for (AppReOpenedListener appReOpenedListener : list) {
                appReOpenedListener.appReOpened(appReOpenedEvent);
            }
        }
    }

    class _OpenAppDispatcher
    extends _QueuingAppEventDispatcher<_OpenAppHandler> {
        _OpenAppDispatcher() {
        }

        @Override
        void performUsing(_OpenAppHandler _OpenAppHandler2, _NativeEvent _NativeEvent2) {
            _OpenAppHandler2.handleOpenApp();
        }
    }

    class _PreferencesDispatcher
    extends _AppEventDispatcher<PreferencesHandler> {
        _PreferencesDispatcher() {
        }

        @Override
        synchronized void setHandler(PreferencesHandler preferencesHandler) {
            super.setHandler(preferencesHandler);
            _AppMenuBarHandler.getInstance().setPreferencesMenuItemVisible(preferencesHandler != null);
            _AppMenuBarHandler.getInstance().setPreferencesMenuItemEnabled(preferencesHandler != null);
        }

        @Override
        void performUsing(PreferencesHandler preferencesHandler, _NativeEvent _NativeEvent2) {
            preferencesHandler.handlePreferences(new AppEvent.PreferencesEvent());
        }
    }

    class _AboutDispatcher
    extends _AppEventDispatcher<AboutHandler> {
        _AboutDispatcher() {
        }

        @Override
        void performDefaultAction(_NativeEvent _NativeEvent2) {
            _AppEventHandler.this.openCocoaAboutWindow();
        }

        @Override
        void performUsing(AboutHandler aboutHandler, _NativeEvent _NativeEvent2) {
            aboutHandler.handleAbout(new AppEvent.AboutEvent());
        }
    }
}

