/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.internal.toolkit.util;

import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.ProgramElementDoc;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class Extern {
    private Map<String, Item> packageToItemMap;
    private final Configuration configuration;
    private boolean linkoffline = false;

    public Extern(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean isExternal(ProgramElementDoc doc) {
        if (this.packageToItemMap == null) {
            return false;
        }
        return this.packageToItemMap.get(doc.containingPackage().name()) != null;
    }

    public String getExternalLink(String pkgName, String relativepath, String link) {
        Item fnd = this.findPackageItem(pkgName);
        if (fnd != null) {
            String externlink = fnd.path + link;
            if (fnd.relative) {
                return relativepath + externlink;
            }
            return externlink;
        }
        return null;
    }

    public boolean url(String url, String pkglisturl, DocErrorReporter reporter, boolean linkoffline) {
        this.linkoffline = linkoffline;
        String errMsg = this.composeExternPackageList(url, pkglisturl);
        if (errMsg != null) {
            reporter.printWarning(errMsg);
            return false;
        }
        return true;
    }

    private Item findPackageItem(String pkgName) {
        if (this.packageToItemMap == null) {
            return null;
        }
        return this.packageToItemMap.get(pkgName);
    }

    private String composeExternPackageList(String urlOrDirPath, String pkgListUrlOrDirPath) {
        urlOrDirPath = this.adjustEndFileSeparator(urlOrDirPath);
        return this.isUrl(pkgListUrlOrDirPath = this.adjustEndFileSeparator(pkgListUrlOrDirPath)) ? this.fetchURLComposeExternPackageList(urlOrDirPath, pkgListUrlOrDirPath) : this.readFileComposeExternPackageList(urlOrDirPath, pkgListUrlOrDirPath);
    }

    private String adjustEndFileSeparator(String url) {
        String filesep = "/";
        if (!url.endsWith(filesep)) {
            url = url + filesep;
        }
        return url;
    }

    private String fetchURLComposeExternPackageList(String urlpath, String pkglisturlpath) {
        String link = pkglisturlpath + "package-list";
        try {
            this.readPackageList(new URL(link).openStream(), urlpath, false);
        }
        catch (MalformedURLException exc) {
            return this.configuration.getText("doclet.MalformedURL", link);
        }
        catch (IOException exc) {
            return this.configuration.getText("doclet.URL_error", link);
        }
        return null;
    }

    private String readFileComposeExternPackageList(String path, String pkgListPath) {
        String link = pkgListPath + "package-list";
        if (!new File(pkgListPath).isAbsolute() && !this.linkoffline) {
            link = this.configuration.destDirName + link;
        }
        try {
            File file = new File(link);
            if (!file.exists() || !file.canRead()) {
                return this.configuration.getText("doclet.File_error", link);
            }
            this.readPackageList(new FileInputStream(file), path, !new File(path).isAbsolute() && !this.isUrl(path));
        }
        catch (FileNotFoundException exc) {
            return this.configuration.getText("doclet.File_error", link);
        }
        catch (IOException exc) {
            return this.configuration.getText("doclet.File_error", link);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPackageList(InputStream input, String path, boolean relative) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(input));
        StringBuffer strbuf = new StringBuffer();
        try {
            int c;
            while ((c = in.read()) >= 0) {
                char ch = (char)c;
                if (ch == '\n' || ch == '\r') {
                    if (strbuf.length() <= 0) continue;
                    String packname = strbuf.toString();
                    String packpath = path + packname.replace('.', '/') + '/';
                    new Item(packname, packpath, relative);
                    strbuf.setLength(0);
                    continue;
                }
                strbuf.append(ch);
            }
        }
        finally {
            input.close();
        }
    }

    public boolean isUrl(String urlCandidate) {
        try {
            new URL(urlCandidate);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private class Item {
        final String packageName;
        final String path;
        final boolean relative;

        Item(String packageName, String path, boolean relative) {
            this.packageName = packageName;
            this.path = path;
            this.relative = relative;
            if (Extern.this.packageToItemMap == null) {
                Extern.this.packageToItemMap = new HashMap();
            }
            if (!Extern.this.packageToItemMap.containsKey(packageName)) {
                Extern.this.packageToItemMap.put(packageName, this);
            }
        }

        public String toString() {
            return this.packageName + (this.relative ? " -> " : " => ") + this.path;
        }
    }
}

