/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.internal.toolkit.builders;

import com.javafx.tools.doclets.internal.toolkit.Configuration;
import com.javafx.tools.doclets.internal.toolkit.ConstructorWriter;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import com.javafx.tools.doclets.internal.toolkit.builders.XMLNode;
import com.javafx.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.ProgramElementDoc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorBuilder
extends AbstractMemberBuilder {
    public static final String NAME = "ConstructorDetails";
    private int currentConstructorIndex;
    private ClassDoc classDoc;
    private VisibleMemberMap visibleMemberMap;
    private ConstructorWriter writer;
    private List<ProgramElementDoc> constructors;

    private ConstructorBuilder(Configuration configuration) {
        super(configuration);
    }

    public static ConstructorBuilder getInstance(Configuration configuration, ClassDoc classDoc, ConstructorWriter writer) {
        ConstructorBuilder builder = new ConstructorBuilder(configuration);
        builder.classDoc = classDoc;
        builder.writer = writer;
        builder.visibleMemberMap = new VisibleMemberMap(classDoc, 3, configuration.nodeprecated);
        builder.constructors = new ArrayList<ProgramElementDoc>(builder.visibleMemberMap.getMembersFor(classDoc));
        for (int i = 0; i < builder.constructors.size(); ++i) {
            if (!builder.constructors.get(i).isProtected() && !builder.constructors.get(i).isPrivate()) continue;
            writer.setFoundNonPubConstructor(true);
        }
        if (configuration.getMemberComparator() != null) {
            Collections.sort(builder.constructors, configuration.getMemberComparator());
        }
        return builder;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean hasMembersToDocument() {
        return this.constructors.size() > 0;
    }

    public List<ProgramElementDoc> members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public ConstructorWriter getWriter() {
        return this.writer;
    }

    public void buildConstructorDoc(XMLNode node, Content memberDetailsTree) {
        if (this.writer == null) {
            return;
        }
        int size = this.constructors.size();
        if (size > 0) {
            Content constructorDetailsTree = this.writer.getConstructorDetailsTreeHeader(this.classDoc, memberDetailsTree);
            this.currentConstructorIndex = 0;
            while (this.currentConstructorIndex < size) {
                Content constructorDocTree = this.writer.getConstructorDocTreeHeader((ConstructorDoc)this.constructors.get(this.currentConstructorIndex), constructorDetailsTree);
                this.buildChildren(node, constructorDocTree);
                constructorDetailsTree.addContent(this.writer.getConstructorDoc(constructorDocTree, this.currentConstructorIndex == size - 1));
                ++this.currentConstructorIndex;
            }
            memberDetailsTree.addContent(this.writer.getConstructorDetails(constructorDetailsTree));
        }
    }

    public void buildSignature(XMLNode node, Content constructorDocTree) {
        constructorDocTree.addContent(this.writer.getSignature((ConstructorDoc)this.constructors.get(this.currentConstructorIndex)));
    }

    public void buildDeprecationInfo(XMLNode node, Content constructorDocTree) {
        this.writer.addDeprecated((ConstructorDoc)this.constructors.get(this.currentConstructorIndex), constructorDocTree);
    }

    public void buildConstructorComments(XMLNode node, Content constructorDocTree) {
        if (!this.configuration.nocomment) {
            this.writer.addComments((ConstructorDoc)this.constructors.get(this.currentConstructorIndex), constructorDocTree);
        }
    }

    public void buildTagInfo(XMLNode node, Content constructorDocTree) {
        this.writer.addTags((ConstructorDoc)this.constructors.get(this.currentConstructorIndex), constructorDocTree);
    }
}

