/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.JarClassLoader;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class ProxyURLStreamHandlerFactory
implements URLStreamHandlerFactory,
LookupListener {
    private static final Logger LOG = Logger.getLogger(ProxyURLStreamHandlerFactory.class.getName());
    private static boolean proxyFactoryInitialized;
    private final URLStreamHandlerFactory delegate;
    private final URLStreamHandler originalJarHandler;
    private Lookup.Result<URLStreamHandlerFactory> r;
    private URLStreamHandlerFactory[] handlers;

    public static synchronized void register() {
        LOG.log(Level.FINE, "register: {0}", proxyFactoryInitialized);
        LOG.log(Level.FINER, null, new Exception("Initialized by"));
        if (!proxyFactoryInitialized) {
            Object object;
            URLStreamHandler uRLStreamHandler;
            block12: {
                uRLStreamHandler = null;
                if (!ProxyURLStreamHandlerFactory.class.getClassLoader().getClass().getName().equals("com.sun.jnlp.JNLPClassLoader")) {
                    try {
                        ArrayList<Field> arrayList = new ArrayList<Field>();
                        for (Field field : URL.class.getDeclaredFields()) {
                            if (field.getType() != URLStreamHandler.class) continue;
                            arrayList.add(field);
                        }
                        if (arrayList.size() != 1) {
                            throw new Exception("No, or multiple, URLStreamHandler-valued fields in URL: " + arrayList);
                        }
                        object = (Field)arrayList.get(0);
                        ((Field)object).setAccessible(true);
                        uRLStreamHandler = (URLStreamHandler)((Field)object).get(new URL("jar:file:/sample.jar!/"));
                        LOG.log(Level.FINE, "found originalJarHandler: {0}", uRLStreamHandler);
                    }
                    catch (Throwable throwable) {
                        if (uRLStreamHandler != null) break block12;
                        LOG.log(Level.SEVERE, "No way to find original stream handler for jar protocol", throwable);
                    }
                }
            }
            try {
                URL.setURLStreamHandlerFactory(new ProxyURLStreamHandlerFactory(null, uRLStreamHandler));
            }
            catch (Error error) {
                LOG.log(Level.CONFIG, "Problems registering URLStreamHandlerFactory, trying reflection", error);
                try {
                    object = null;
                    for (Field field : URL.class.getDeclaredFields()) {
                        LOG.log(Level.FINEST, "Found field {0}", field);
                        if (field.getType() != URLStreamHandlerFactory.class) continue;
                        LOG.log(Level.FINEST, "Clearing field {0}");
                        field.setAccessible(true);
                        object = (URLStreamHandlerFactory)field.get(null);
                        LOG.log(Level.CONFIG, "Previous value was {0}", object);
                        field.set(null, null);
                        LOG.config("Field is supposed to be empty");
                        break;
                    }
                    if (object != null && object.getClass().getName().equals(ProxyURLStreamHandlerFactory.class.getName())) {
                        object = null;
                    }
                    URL.setURLStreamHandlerFactory(new ProxyURLStreamHandlerFactory((URLStreamHandlerFactory)object, uRLStreamHandler));
                }
                catch (Throwable throwable) {
                    LOG.log(Level.SEVERE, "No way to register URLStreamHandlerFactory; NetBeans is unlikely to work", throwable);
                }
            }
            proxyFactoryInitialized = true;
        }
    }

    private ProxyURLStreamHandlerFactory(URLStreamHandlerFactory uRLStreamHandlerFactory, URLStreamHandler uRLStreamHandler) {
        this.delegate = uRLStreamHandlerFactory;
        this.originalJarHandler = uRLStreamHandler;
        LOG.log(Level.FINE, "new ProxyURLStreamHandlerFactory. delegate={0} originalJarHandler={1}", new Object[]{uRLStreamHandlerFactory, uRLStreamHandler});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URLStreamHandler createURLStreamHandler(String string) {
        URLStreamHandlerFactory[] uRLStreamHandlerFactoryArray;
        if (string.equals("jar")) {
            return this.originalJarHandler != null ? new JarClassLoader.JarURLStreamHandler(this.originalJarHandler) : null;
        }
        if (string.equals("file") || string.equals("http") || string.equals("https") || string.equals("resource")) {
            return null;
        }
        if (this.delegate != null && (uRLStreamHandlerFactoryArray = this.delegate.createURLStreamHandler(string)) != null) {
            return uRLStreamHandlerFactoryArray;
        }
        URLStreamHandlerFactory[] uRLStreamHandlerFactoryArray2 = this;
        synchronized (this) {
            if (this.handlers == null) {
                this.r = Lookup.getDefault().lookupResult(URLStreamHandlerFactory.class);
                this.r.addLookupListener((LookupListener)this);
                this.resultChanged(null);
            }
            uRLStreamHandlerFactoryArray = this.handlers;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (URLStreamHandlerFactory uRLStreamHandlerFactory : uRLStreamHandlerFactoryArray) {
                URLStreamHandler uRLStreamHandler = uRLStreamHandlerFactory.createURLStreamHandler(string);
                if (uRLStreamHandler == null) continue;
                return uRLStreamHandler;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultChanged(LookupEvent lookupEvent) {
        Collection collection = this.r.allInstances();
        ProxyURLStreamHandlerFactory proxyURLStreamHandlerFactory = this;
        synchronized (proxyURLStreamHandlerFactory) {
            this.handlers = collection.toArray(new URLStreamHandlerFactory[0]);
        }
    }
}

