/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;

public class Installer
extends JFrame
implements ActionListener {
    private static final String nl = System.getProperty("line.separator");
    private static final char slash = File.separatorChar;
    private static final String colon = File.pathSeparator;
    private static String jdkFile = "/jmods/jdk.compiler.jmod";
    private static String javaFxFile = "/lib/javafx.graphics.jar";
    static final int BUFFER_SIZE = 8192;
    JTextField directoryField;
    JTextField javaField;
    JTextField javaFxField;
    JLabel textLabel1;
    JLabel textLabel2;
    JButton browseDirButton;
    JButton browseJdkButton;
    JButton browseJavaFxButton;
    JButton installButton;
    JButton cancelButton;
    JProgressBar progress;
    UpdateProgress progressUpdater;
    String currentDirectory = System.getProperty("user.dir");
    String osname = System.getProperty("os.name");
    String architecture = System.getProperty("os.arch");
    String javaVersion = System.getProperty("java.specification.version");
    boolean isJDK12;
    boolean isJDK13;
    String installationDir = "";
    String javaPath = this.findJavaPath();
    String javaFxPath = "";
    Properties properties;
    long myTotalBytes = 400000L;

    public static void main(String[] args) {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    new Installer();
                }
            });
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
    }

    public Installer() {
        this.loadProperties();
        String installDirName = this.getProperty("installDirName");
        this.installationDir = this.currentDirectory.endsWith(installDirName) ? this.currentDirectory : this.currentDirectory + File.separator + installDirName;
        try {
            this.myTotalBytes = Integer.parseInt(this.getProperty("pkgJarSize"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.progressUpdater = new UpdateProgress();
        this.makeWindow();
        String requiredJavaVersion = this.getProperty("requiredJavaVersion");
        if (this.javaVersion.compareTo(requiredJavaVersion) < 0) {
            this.notifyError(this.getProperty("jdkError1") + this.javaVersion + " " + this.getProperty("jdkError2"), this.getProperty("jdkMsg"));
        }
    }

    private void loadProperties() {
        InputStream propStream = ClassLoader.getSystemResourceAsStream("installer.props");
        this.properties = new Properties();
        try {
            this.properties.load(propStream);
        }
        catch (IOException ioe) {
            System.err.println("Error loading installer configuration:");
            ioe.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private String findJavaPath() {
        String javaHome = System.getProperty("java.home");
        if (this.isJDKPath(javaHome)) {
            return javaHome;
        }
        if (javaHome.endsWith("jre") && this.isJDKPath(javaHome = javaHome.substring(0, javaHome.length() - 4))) {
            return javaHome;
        }
        String shortVersion = this.javaVersion.substring(0, this.javaVersion.length() - 2);
        String[] tryPaths = new String[]{"C:\\jdk" + this.javaVersion, "C:\\jdk" + shortVersion, "D:\\jdk" + this.javaVersion, "D:\\jdk" + shortVersion, "/usr/java", "/usr/local/java", "/usr/jdk" + this.javaVersion, "/usr/jdk" + shortVersion, "/usr/local/jdk" + this.javaVersion, "/usr/local/jdk" + shortVersion, "/System/Library/Frameworks/JavaVM.framework"};
        for (int i = 0; i < tryPaths.length; ++i) {
            if (!this.isJDKPath(tryPaths[i])) continue;
            return tryPaths[i];
        }
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.browseDirButton) {
            this.getInstallDirectory();
        } else if (src == this.browseJdkButton) {
            this.getJDKDirectory();
        } else if (src == this.browseJavaFxButton) {
            this.getJavaFxDirectory();
        } else if (src == this.installButton) {
            this.installButton.setEnabled(false);
            InstallThread p = new InstallThread();
            p.setPriority(2);
            p.start();
        } else if (src == this.cancelButton) {
            this.doCancel();
        }
    }

    private void doCancel() {
        System.exit(0);
    }

    private void getInstallDirectory() {
        String dirName = this.getDirName("Select installation directory");
        if (dirName != null) {
            this.installationDir = dirName.endsWith(this.getProperty("installDirName")) ? dirName : dirName + File.separator + this.getProperty("installDirName");
            this.directoryField.setText(this.installationDir);
            this.checkInstallDir(this.installationDir, false);
        }
    }

    private void getJDKDirectory() {
        String dirName = this.getDirName("Select JDK directory");
        if (dirName != null) {
            this.javaPath = dirName;
            this.javaField.setText(this.javaPath);
            if (!this.isJDKPath(this.javaPath)) {
                this.jdkPathProblem();
            }
        }
    }

    private void getJavaFxDirectory() {
        String dirName = this.getDirName("Select JavaFX directory");
        if (dirName != null) {
            this.javaFxPath = dirName;
            this.javaFxField.setText(this.javaFxPath);
            if (!this.isJavaFxPath(this.javaFxPath)) {
                this.javaFxPathProblem();
            }
        }
    }

    public void doInstall() {
        this.readInputValues();
        if (!this.isJDKPath(this.javaPath)) {
            this.jdkPathProblem();
            return;
        }
        if (!this.isJavaFxPath(this.javaFxPath)) {
            this.javaFxPathProblem();
            return;
        }
        try {
            if (!this.checkInstallDir(this.installationDir, true)) {
                return;
            }
            this.unpackTo();
            if (this.getProperty("exeName") != null) {
                if (this.osname == null) {
                    this.writeWindows();
                    this.writeUnix(false);
                } else if (this.osname.startsWith("Windows")) {
                    this.writeWindows();
                } else if (this.osname.startsWith("Mac")) {
                    this.writeUnix(true);
                } else {
                    this.writeUnix(false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.finish("Installation FAILED: ", e.getMessage());
            return;
        }
        if (this.getProperty("exeName") != null) {
            this.finish(this.getProperty("appName") + " has been installed to " + this.installationDir, "To run it, execute \"" + this.getProperty("exeName") + "\".");
        } else {
            this.finish("The package has been installed to " + this.installationDir, " ");
        }
    }

    private void readInputValues() {
        this.installationDir = this.directoryField.getText();
        this.javaPath = this.javaField.getText();
        this.javaFxPath = this.javaFxField.getText();
    }

    public boolean isJDKPath(String path) {
        String jdkFilePath = path + jdkFile;
        return new File(jdkFilePath).exists();
    }

    public boolean isJavaFxPath(String path) {
        String javaFxFilePath = path + javaFxFile;
        return new File(javaFxFilePath).exists();
    }

    public void setStatus(final String text) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Installer.this.textLabel1.setText(text);
                Installer.this.textLabel1.repaint();
            }
        });
    }

    public void finish(String msg1, String msg2) {
        this.textLabel1.setText(msg1);
        this.textLabel2.setText(msg2);
        this.installButton.setEnabled(false);
        this.cancelButton.setText("Done");
        this.getRootPane().setDefaultButton(this.cancelButton);
    }

    public void notifyError(String error, String msg) {
        JOptionPane.showMessageDialog(this, error);
        this.finish(msg, "Installation aborted.");
    }

    private void jdkPathProblem() {
        this.notifyProblem("The Java directory you have specified is not a valid \nJDK directory. It must contain the file \n" + jdkFile);
    }

    private void javaFxPathProblem() {
        this.notifyProblem("JavaFX must be installed, via package manager or downloaded\nfrom openjfx.io  The JavaFX directory you have specified\nis not a valid JavaFX directory. It must contain the file\n" + javaFxFile);
    }

    private boolean checkInstallDir(String dirName, boolean make) {
        File installDir = new File(dirName);
        if (installDir.exists()) {
            if (installDir.isDirectory()) {
                return true;
            }
            this.notifyProblem("The name you specified exists\nand is not a directory. Cannot\ninstall there.");
            return false;
        }
        File parent = installDir.getParentFile();
        if (parent.exists()) {
            if (parent.isDirectory()) {
                if (make) {
                    installDir.mkdir();
                }
                return true;
            }
            this.notifyProblem(parent.getAbsolutePath() + " is not\na directory. Cannot install there.");
            return false;
        }
        this.notifyProblem("The directory " + parent.getAbsolutePath() + "\ndoes not exist.\nPlease check the path and enter again.");
        return false;
    }

    private void notifyProblem(final String problem) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(Installer.this, problem);
                Installer.this.installButton.setEnabled(true);
            }
        });
    }

    public void makeWindow() {
        Color backgroundColour = this.colorFromString(this.getProperty("color.background"));
        this.setBackground(backgroundColour);
        String title = this.getProperty("title");
        if (title != null) {
            this.setTitle(title);
        }
        JPanel mainPanel = (JPanel)this.getContentPane();
        mainPanel.setLayout(new BorderLayout(15, 15));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        mainPanel.setBackground(backgroundColour);
        URL logoUrl = ClassLoader.getSystemResource(this.getProperty("gif.logo"));
        Image img = this.getToolkit().createImage(logoUrl);
        JLabel logoLabel = new JLabel(new ImageIcon(img));
        mainPanel.add((Component)logoLabel, "North");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBackground(backgroundColour);
        this.installButton = new JButton("Install");
        buttonPanel.add(this.installButton);
        this.installButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        buttonPanel.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        mainPanel.add((Component)buttonPanel, "South");
        Box centrePanel = new Box(1);
        Box dirPanel = new Box(0);
        dirPanel.add(Box.createHorizontalGlue());
        dirPanel.add(new JLabel("Directory to install to:"));
        this.directoryField = new JTextField(this.installationDir, 16);
        dirPanel.add(this.directoryField);
        this.browseDirButton = new JButton("Browse");
        this.browseDirButton.addActionListener(this);
        dirPanel.add(this.browseDirButton);
        centrePanel.add(dirPanel);
        centrePanel.add(Box.createVerticalStrut(5));
        Box jdkDirPanel = new Box(0);
        jdkDirPanel.add(Box.createHorizontalGlue());
        jdkDirPanel.add(new JLabel("Java (JDK) directory:"));
        this.javaField = new JTextField(this.javaPath, 16);
        jdkDirPanel.add(this.javaField);
        this.browseJdkButton = new JButton("Browse");
        this.browseJdkButton.addActionListener(this);
        jdkDirPanel.add(this.browseJdkButton);
        centrePanel.add(jdkDirPanel);
        centrePanel.add(Box.createVerticalStrut(5));
        Box javaFxDirPanel = new Box(0);
        javaFxDirPanel.add(Box.createHorizontalGlue());
        javaFxDirPanel.add(new JLabel("JavaFX directory:"));
        this.javaFxField = new JTextField("", 16);
        javaFxDirPanel.add(this.javaFxField);
        this.browseJavaFxButton = new JButton("Browse");
        this.browseJavaFxButton.addActionListener(this);
        javaFxDirPanel.add(this.browseJavaFxButton);
        centrePanel.add(javaFxDirPanel);
        centrePanel.add(Box.createVerticalStrut(24));
        this.progress = new JProgressBar();
        centrePanel.add(this.progress);
        centrePanel.add(Box.createVerticalStrut(5));
        JPanel labelPanel = new JPanel(new GridLayout(0, 1));
        labelPanel.setBackground(backgroundColour);
        this.textLabel1 = new JLabel(" ", 2);
        labelPanel.add(this.textLabel1);
        this.textLabel2 = new JLabel(" ", 2);
        labelPanel.add(this.textLabel2);
        centrePanel.add(labelPanel);
        String tagline = this.getProperty("tagline");
        if (tagline != null) {
            this.textLabel2.setText(tagline);
        }
        mainPanel.add((Component)centrePanel, "Center");
        this.getRootPane().setDefaultButton(this.installButton);
        this.pack();
        this.setLocation(100, 100);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }

            @Override
            public void windowActivated(WindowEvent e) {
                Installer.this.installButton.requestFocus();
            }
        });
    }

    public void writeUnix(boolean isMacOS) throws IOException {
        File outputFile = new File(this.installationDir, this.getProperty("exeName"));
        FileWriter out = new FileWriter(outputFile.toString());
        out.write("#!/bin/sh\n");
        out.write("APPBASE=\"" + this.installationDir + "\"\n");
        out.write("JAVAPATH=\"" + this.javaPath + "\"\n");
        out.write("JAVAFXPATH=\"" + this.javaFxPath + "\"\n");
        String javaName = "$JAVAPATH/bin/java";
        String commands = isMacOS ? this.getProperty("commands.mac").toString() : this.getProperty("commands.unix").toString();
        commands = commands + "\n" + this.getProperty("javafx.classpath.unix").toString();
        if (commands != null) {
            out.write(commands);
            out.write("\n");
        }
        out.write("\"" + javaName + "\" " + this.getProperty("javaOpts.unix") + " " + this.getProperty("mainClass") + " " + this.getProperty("arguments.unix") + " \"$@\"\n");
        out.close();
        try {
            String[] cmdArray = new String[]{"chmod", "755", outputFile.toString()};
            Runtime.getRuntime().exec(cmdArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeWindows() throws IOException {
        File outputFile = new File(this.installationDir, this.getProperty("exeName") + ".bat");
        FileWriter out = new FileWriter(outputFile.toString());
        out.write("@echo off\r\n");
        out.write("set APPBASE=\"" + this.installationDir + "\"\r\n");
        out.write("set JAVAFXPATH=\"" + this.javaFxPath + "\"\r\n");
        String commands = this.getProperty("commands.win").toString();
        if (commands != null) {
            commands = this.replace(commands, '~', "%APPBASE%");
            commands = this.replace(commands, '!', "\"" + this.javaPath + "\"");
            commands = this.replace(commands, '@', this.architecture);
            out.write(commands);
            out.write("\r\n");
        }
        out.write(this.getProperty("javafx.classpath.win").toString() + "\r\n");
        out.write("\"" + this.javaPath + "\\bin\\java\" " + this.getProperty("javaOpts.win") + " " + this.getProperty("mainClass") + " " + this.getProperty("arguments.win") + " %1 %2 %3 %4 %5 %6 %7 %8 %9\r\n");
        out.close();
    }

    public void unpackTo() {
        try {
            InputStream in = ClassLoader.getSystemResourceAsStream(this.getProperty("pkgJar"));
            this.dumpJar(this.installationDir, new ProgressTrackerStream(in));
        }
        catch (Exception e) {
            this.notifyError("Installer failed to open: " + e, "Could not open install file.");
        }
    }

    public void makeDirsFor(String start, String path) {
        String sofar = null;
        StringTokenizer tok = new StringTokenizer(path, "/", false);
        sofar = start;
        while (tok.hasMoreTokens()) {
            String part = tok.nextToken();
            if (!tok.hasMoreTokens()) continue;
            File d = new File(sofar + File.separatorChar + part);
            sofar = d.toString();
            d.mkdirs();
        }
    }

    public void dumpJar(String dir, InputStream in) throws IOException, ZipException {
        ZipEntry z;
        this.makeDirsFor(dir, "");
        long bytesRead = 0L;
        ZipInputStream zip = new ZipInputStream(in);
        byte[] buffer = new byte[8192];
        while ((z = zip.getNextEntry()) != null) {
            int len;
            FileOutputStream out;
            String name = dir + "/" + z.getName();
            if (z.isDirectory()) {
                File d = new File(name);
                d.mkdirs();
                continue;
            }
            if (z.getName().indexOf(47) != -1) {
                this.makeDirsFor(dir, z.getName());
            }
            try {
                out = new FileOutputStream(name);
            }
            catch (FileNotFoundException e) {
                throw new IOException("Couldn't write to specified file/directory");
            }
            this.setStatus("extracting: " + name);
            while ((len = zip.read(buffer, 0, 8192)) != -1) {
                bytesRead += (long)len;
                out.write(buffer, 0, len);
            }
            out.close();
            if (z.getTime() != -1L) {
                File f = new File(name);
                f.setLastModified(z.getTime());
            }
            zip.closeEntry();
        }
        zip.close();
        this.progress.setValue(100);
    }

    String replace(String src, char pattern, String subst) {
        char[] patterns = new char[]{pattern};
        String patString = new String(patterns);
        StringTokenizer tokenizer = new StringTokenizer(src, patString, true);
        StringBuffer ret = new StringBuffer();
        while (tokenizer.hasMoreElements()) {
            String tok = tokenizer.nextToken();
            if (tok.length() == 1 && tok.equals(patString)) {
                ret.append(subst);
                continue;
            }
            ret.append(tok);
        }
        return ret.toString();
    }

    public String getDirName(String title) {
        JFileChooser newChooser = new JFileChooser();
        newChooser.setDialogTitle(title);
        newChooser.setFileSelectionMode(1);
        int result = newChooser.showDialog(this, "Choose");
        if (result == 0) {
            return newChooser.getSelectedFile().getPath();
        }
        return null;
    }

    public String getProperty(String key) {
        return (String)this.properties.get("install." + key);
    }

    private Color colorFromString(String value) {
        StringTokenizer tok = new StringTokenizer(value, " \t,", false);
        int r = Integer.valueOf(tok.nextToken());
        int g = Integer.valueOf(tok.nextToken());
        int b = Integer.valueOf(tok.nextToken());
        return new Color(r, g, b);
    }

    private void updateProgress(int value) {
        this.progressUpdater.value = value;
        try {
            EventQueue.invokeAndWait(this.progressUpdater);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        JTextField f = new JTextField();
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        Keymap map = f.getKeymap();
        map.removeKeyStrokeBinding(enter);
    }

    private class UpdateProgress
    implements Runnable {
        int value;

        private UpdateProgress() {
        }

        @Override
        public void run() {
            Installer.this.progress.setValue(this.value);
        }
    }

    class InstallThread
    extends Thread {
        InstallThread() {
        }

        @Override
        public void run() {
            Installer.this.doInstall();
        }
    }

    private class ProgressTrackerStream
    extends InputStream {
        InputStream underlying;
        long readCount = 0L;
        long markerIncrement;
        long nextMarker;

        public ProgressTrackerStream(InputStream over) {
            this.markerIncrement = Installer.this.myTotalBytes / 100L;
            this.nextMarker = Installer.this.myTotalBytes / 100L;
            this.underlying = over;
        }

        @Override
        public int read() throws IOException {
            int r = this.underlying.read();
            if (r != -1) {
                ++this.readCount;
            }
            if (this.readCount > this.nextMarker) {
                Installer.this.updateProgress((int)(this.readCount / this.markerIncrement));
                this.nextMarker += this.markerIncrement;
            }
            return r;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int r = this.underlying.read(b, off, len);
            this.readCount += (long)r;
            if (this.readCount > this.nextMarker) {
                Installer.this.updateProgress((int)(this.readCount / this.markerIncrement));
                this.nextMarker += this.markerIncrement;
            }
            return r;
        }
    }
}

