/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.springframework.mock.web.MockServletContext;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockServletConfig
implements ServletConfig {
    private final ServletContext servletContext;
    private final String servletName;
    private final Map<String, String> initParameters = new LinkedHashMap<String, String>();

    public MockServletConfig() {
        this(null, "");
    }

    public MockServletConfig(String servletName) {
        this(null, servletName);
    }

    public MockServletConfig(ServletContext servletContext) {
        this(servletContext, "");
    }

    public MockServletConfig(ServletContext servletContext, String servletName) {
        this.servletContext = servletContext != null ? servletContext : new MockServletContext();
        this.servletName = servletName;
    }

    public String getServletName() {
        return this.servletName;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void addInitParameter(String name, String value) {
        Assert.notNull(name, "Parameter name must not be null");
        this.initParameters.put(name, value);
    }

    public String getInitParameter(String name) {
        Assert.notNull(name, "Parameter name must not be null");
        return this.initParameters.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration((Collection)this.initParameters.keySet());
    }
}

