/*
 * Decompiled with CFR 0.152.
 */
package de.mbenning.weather.wunderground.impl.services;

import de.mbenning.weather.wunderground.api.domain.DataGraphSpan;
import de.mbenning.weather.wunderground.api.domain.HttpProxy;
import de.mbenning.weather.wunderground.impl.services.base.AbstractDataReaderService;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.Scanner;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@Scope(value="prototype")
@Qualifier(value="httpDataReaderService")
public class HttpDataReaderService
extends AbstractDataReaderService {
    private HttpURLConnection connection = null;
    private String url = ResourceBundle.getBundle("wunderground-core").getString("wunderground.core.http.url");
    private Date weatherDate;
    private boolean isDateChanged = false;
    @Autowired
    @Qualifier(value="httpProxy")
    private HttpProxy httpProxy;

    public void init() throws IOException {
        if (this.scanner == null && this.connection == null && this.weatherStation != null || this.isStationChanged || this.isDateChanged) {
            this.datasets = new ArrayList();
            this.currentLine = 1L;
            if (this.httpProxy != null && this.httpProxy.isEnabled()) {
                System.setProperty("proxySet", "true");
                System.setProperty("http.proxyHost", this.httpProxy.getUrl());
                System.setProperty("http.proxyPort", Integer.toString(this.httpProxy.getPort()));
                if (this.httpProxy.getUsername() != null && !this.httpProxy.getUsername().equalsIgnoreCase("")) {
                    System.setProperty("http.proxyUser", this.httpProxy.getUsername());
                }
                if (this.httpProxy.getPassword() != null && !this.httpProxy.getPassword().equalsIgnoreCase("")) {
                    System.setProperty("http.proxyPassword", this.httpProxy.getPassword());
                }
            }
            URL url = new URL(this.url.replace("{1}", this.weatherStation.getStationId()));
            if (this.weatherDate != null) {
                if (this.dataGraphSpan.equals((Object)DataGraphSpan.DAY)) {
                    DateTime waetherDateTime = new DateTime(this.weatherDate.getTime());
                    StringBuilder dateUrl = new StringBuilder(this.url.replace("{1}", this.weatherStation.getStationId()));
                    dateUrl.append("&day=").append(waetherDateTime.get(DateTimeFieldType.dayOfMonth())).append("&");
                    dateUrl.append("year=").append(waetherDateTime.get(DateTimeFieldType.year())).append("&");
                    dateUrl.append("month=").append(waetherDateTime.get(DateTimeFieldType.monthOfYear())).append("&");
                    url = new URL(dateUrl.toString());
                } else if (this.dataGraphSpan.equals((Object)DataGraphSpan.MONTH)) {
                    DateTime weatherDateTime = new DateTime(this.weatherDate.getTime());
                    StringBuilder dateUrl = new StringBuilder(this.url.replace("{1}", this.weatherStation.getStationId()));
                    dateUrl.append("&month=").append(weatherDateTime.get(DateTimeFieldType.monthOfYear())).append("&");
                    dateUrl.append("year=").append(weatherDateTime.get(DateTimeFieldType.year())).append("&");
                    dateUrl.append("graphspan=month");
                    url = new URL(dateUrl.toString());
                }
            }
            this.connection = (HttpURLConnection)url.openConnection();
            this.connection.setRequestMethod("GET");
            this.connection.setUseCaches(false);
            this.scanner = new Scanner(this.connection.getInputStream());
            String line = this.scanner.nextLine();
            if (line == null || !StringUtils.hasText(line)) {
                this.scanner.nextLine();
            }
            this.isStationChanged = false;
            this.isDateChanged = false;
        }
    }

    public Date getWeatherDate() {
        return this.weatherDate;
    }

    public void setWeatherDate(Date weatherDate) {
        this.isDateChanged = true;
        this.weatherDate = weatherDate;
    }

    public HttpProxy getHttpProxy() {
        return this.httpProxy;
    }

    public void setHttpProxy(HttpProxy httpProxy) {
        this.httpProxy = httpProxy;
    }

    public boolean isDateChanged() {
        return this.isDateChanged;
    }

    public void setDateChanged(boolean isDateChanged) {
        this.isDateChanged = isDateChanged;
    }
}

