/*
 * Decompiled with CFR 0.152.
 */
package rmiextension.wrappers;

import bluej.extensions.BField;
import bluej.extensions.BObject;
import bluej.extensions.ClassNotFoundException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import greenfoot.util.GreenfootUtil;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import rmiextension.wrappers.RField;
import rmiextension.wrappers.RObject;
import rmiextension.wrappers.WrapperPool;

public class RFieldImpl
extends UnicastRemoteObject
implements RField {
    private BField bField;

    public RFieldImpl(BField bField) throws RemoteException {
        this.bField = bField;
        if (bField == null) {
            throw new NullPointerException("Argument can't be null");
        }
    }

    @Override
    public int getModifiers() {
        return this.bField.getModifiers();
    }

    @Override
    public String getName() {
        return this.bField.getName();
    }

    @Override
    public Class<?> getType() {
        return this.bField.getType();
    }

    @Override
    public RObject getValue(RObject onThis) throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        try {
            Object fieldValue = this.bField.getValue(null);
            if (fieldValue instanceof BObject) {
                BObject bFieldValue = (BObject)fieldValue;
                String newInstanceName = "noName";
                try {
                    String className = bFieldValue.getBClass().getName();
                    className = GreenfootUtil.extractClassName(className);
                    newInstanceName = className.substring(0, 1).toLowerCase() + className.substring(1);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                bFieldValue.addToBench(newInstanceName);
                RObject wrapper = WrapperPool.instance().getWrapper(bFieldValue);
                return wrapper;
            }
            return null;
        }
        catch (ProjectNotOpenException e) {
            e.printStackTrace();
        }
        catch (PackageNotFoundException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return null;
    }
}

