/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.record;

import bluej.Config;
import bluej.debugger.gentype.JavaType;
import bluej.stride.framedjava.elements.CallElement;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.elements.NormalMethodElement;
import bluej.stride.framedjava.elements.VarElement;
import bluej.utility.Debug;
import greenfoot.Actor;
import greenfoot.ObjectTracker;
import greenfoot.World;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import rmiextension.wrappers.RObject;

public class GreenfootRecorder {
    private IdentityHashMap<Object, String> objectNames = new IdentityHashMap();
    private LinkedList<CodeElement> code = new LinkedList();
    private World world;
    public static final String METHOD_ACCESS = "private";
    public static final String METHOD_RETURN = "void";
    public static final String METHOD_NAME = "prepare";

    public synchronized void createActor(Object actor, String[] args, JavaType[] paramTypes) {
        Class<?> theClass = actor.getClass();
        String name = this.nameActor(actor);
        if (name != null) {
            this.code.add((CodeElement)new VarElement(null, theClass.getCanonicalName(), name, "new " + theClass.getCanonicalName() + "(" + GreenfootRecorder.withCommas(args, paramTypes, false) + ")"));
            assert (((VarElement)this.code.getLast()).isEnable());
        }
    }

    public synchronized String nameActor(Object actor) {
        try {
            RObject rObject = ObjectTracker.getRObject(actor);
            if (rObject != null) {
                String name = rObject.getInstanceName();
                this.objectNames.put(actor, name);
                return name;
            }
            return null;
        }
        catch (RemoteException e) {
            Debug.reportError((String)"Error naming actor", (Throwable)e);
            return null;
        }
    }

    private static String withCommas(String[] args, JavaType[] paramTypes, boolean isVarArgs) {
        if (args == null) {
            return "";
        }
        StringBuffer commaArgs = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].trim();
            if (arg.startsWith("{") && arg.endsWith("}")) {
                String paramTypeName;
                if (isVarArgs && i >= paramTypes.length - 1) {
                    paramTypeName = paramTypes[paramTypes.length - 1].toString();
                    paramTypeName = paramTypeName.substring(0, paramTypeName.length() - 2);
                } else {
                    paramTypeName = paramTypes[i].toString();
                }
                arg = "new " + paramTypeName + " " + arg;
            }
            commaArgs.append(arg);
            if (i == args.length - 1) continue;
            commaArgs.append(", ");
        }
        return commaArgs.toString();
    }

    public synchronized void addActorToWorld(Actor actor, int x, int y) {
        String actorObjectName = this.objectNames.get(actor);
        if (null == actorObjectName) {
            return;
        }
        this.code.add((CodeElement)this.callElement("addObject(" + actorObjectName + "," + String.valueOf(x) + "," + String.valueOf(y) + ")"));
    }

    public synchronized void callActorMethod(Object obj, String actorName, Method method, String[] args, JavaType[] paramTypes) {
        if (obj != null && null == this.objectNames.get(obj) && obj != this.world) {
            return;
        }
        String name = this.world != null && this.world == obj ? method.getName() : actorName + "." + method.getName();
        this.code.add((CodeElement)this.callElement(name + "(" + GreenfootRecorder.withCommas(args, paramTypes, method.isVarArgs()) + ")"));
    }

    public void callStaticMethod(String className, Method method, String[] args, JavaType[] argTypes) {
        this.callActorMethod(null, className, method, args, argTypes);
    }

    public synchronized void clearCode(boolean simulationStarted) {
        this.code.clear();
        if (simulationStarted) {
            this.objectNames.clear();
        }
    }

    public synchronized void reset() {
        this.objectNames.clear();
        this.clearCode(false);
    }

    public synchronized void setWorld(World newWorld) {
        this.world = newWorld;
    }

    public synchronized void moveActor(Actor actor, int xCell, int yCell) {
        String actorObjectName = this.objectNames.get(actor);
        if (null == actorObjectName) {
            return;
        }
        this.code.add((CodeElement)this.callElement(actorObjectName + ".setLocation(" + String.valueOf(xCell) + "," + String.valueOf(yCell) + ")"));
    }

    public void removeActor(Actor obj) {
        String actorObjectName = this.objectNames.get(obj);
        if (null == actorObjectName) {
            return;
        }
        this.code.add((CodeElement)this.callElement("removeObject(" + actorObjectName + ")"));
        this.objectNames.remove(obj);
    }

    public synchronized List<CodeElement> getCode() {
        return new LinkedList<CodeElement>(this.code);
    }

    public NormalMethodElement getPrepareMethod() {
        StringBuffer documentation = new StringBuffer();
        documentation.append(Config.getString((String)"record.method.comment1")).append("\n");
        documentation.append(Config.getString((String)"record.method.comment2"));
        return new NormalMethodElement(METHOD_ACCESS, METHOD_RETURN, METHOD_NAME, null, this.code, documentation.toString());
    }

    public CallElement getPrepareMethodCall() {
        return this.callElement("prepare()");
    }

    private CallElement callElement(String content) {
        return new CallElement(content, content);
    }
}

