/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.platforms.ide;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import bluej.Config;
import bluej.extensions.ProjectNotOpenException;
import bluej.extensions.SourceType;
import bluej.runtime.ExecServer;
import bluej.utility.BlueJFileReader;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.Utility;
import greenfoot.GreenfootImage;
import greenfoot.UserInfo;
import greenfoot.UserInfoVisitor;
import greenfoot.platforms.GreenfootUtilDelegate;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import rmiextension.BlueJRMIClient;

public class GreenfootUtilDelegateIDE
implements GreenfootUtilDelegate {
    private static GreenfootUtilDelegateIDE instance = new GreenfootUtilDelegateIDE();

    public static GreenfootUtilDelegateIDE getInstance() {
        return instance;
    }

    private GreenfootUtilDelegateIDE() {
    }

    public void createSkeleton(String className, String superClassName, File file, String templateFileName, String projCharsetName) throws IOException {
        Hashtable<String, String> translations = new Hashtable<String, String>();
        ((Dictionary)translations).put("CLASSNAME", className);
        if (superClassName != null) {
            ((Dictionary)translations).put("EXTENDSANDSUPERCLASSNAME", "extends " + superClassName);
            ((Dictionary)translations).put("EXTENDSSUPERCLASSNAME", "extends=\"" + superClassName + "\"");
        } else {
            ((Dictionary)translations).put("EXTENDSANDSUPERCLASSNAME", "");
            ((Dictionary)translations).put("EXTENDSSUPERCLASSNAME", "");
        }
        String baseName = "greenfoot/templates/" + templateFileName;
        File template = Config.getLanguageFile((String)baseName);
        if (!template.canRead()) {
            template = Config.getDefaultLanguageFile((String)baseName);
        }
        BlueJFileReader.translateFile((File)template, (File)file, translations, (Charset)Charset.forName("UTF-8"), (Charset)this.selectCharset(projCharsetName));
    }

    public void duplicate(String originalClassName, String destinationClassName, File originalFile, File destination, SourceType type) throws IOException {
        Hashtable<String, String> translations = new Hashtable<String, String>();
        ((Dictionary)translations).put(originalClassName, destinationClassName);
        BlueJFileReader.duplicateFile((File)originalFile, (File)destination, translations);
    }

    private Charset selectCharset(String projCharsetName) {
        Charset projCharset;
        try {
            projCharset = Charset.forName(projCharsetName);
        }
        catch (UnsupportedCharsetException uce) {
            projCharset = Charset.forName("UTF-8");
        }
        catch (IllegalCharsetNameException icne) {
            projCharset = Charset.forName("UTF-8");
        }
        return projCharset;
    }

    @Override
    public URL getResource(String path) {
        return ExecServer.getCurrentClassLoader().getResource(path);
    }

    @Override
    public Iterable<String> getSoundFiles() {
        ArrayList<String> files = new ArrayList<String>();
        try {
            URL url = this.getResource("sounds");
            if (url != null && "file".equals(url.getProtocol())) {
                for (String file : new File(url.toURI()).list()) {
                    files.add(file);
                }
            }
        }
        catch (URISyntaxException e) {
            Debug.reportError((String)"Bad URI in getResources", (Throwable)e);
        }
        return files;
    }

    @Override
    public String getGreenfootLogoPath() {
        File libDir = Config.getGreenfootLibDir();
        return libDir.getAbsolutePath() + "/imagelib/other/greenfoot.png";
    }

    @Override
    public void displayMessage(Component parent, String messageText) {
        DialogManager.showText((Component)parent, (String)messageText);
    }

    @Override
    public boolean isStorageSupported() {
        return this.getUserName() != null && !this.getUserName().isEmpty();
    }

    @Override
    public String getUserName() {
        return Config.getPropString((String)"greenfoot.player.name", (String)"Player1");
    }

    @Override
    public UserInfo getCurrentUserInfo() {
        if (this.getUserName() == null || this.getUserName().isEmpty()) {
            return null;
        }
        ArrayList<UserInfo> all = this.getAllDataSorted(true);
        if (all == null) {
            return null;
        }
        for (int i = 0; i < all.size(); ++i) {
            if (!this.getUserName().equals(all.get(i).getUserName())) continue;
            return all.get(i);
        }
        return UserInfoVisitor.allocate(this.getUserName(), -1, this.getUserName());
    }

    private UserInfo makeStorage(String[] line, int rank, boolean useSingleton) {
        UserInfo r = null;
        try {
            int i;
            int column = 0;
            r = UserInfoVisitor.allocate(line[column++], rank, useSingleton ? this.getUserName() : null);
            r.setScore(Integer.parseInt(line[column++]));
            for (i = 0; i < 10; ++i) {
                r.setInt(i, Integer.parseInt(line[column++]));
            }
            for (i = 0; i < 5; ++i) {
                r.setString(i, line[column++]);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return r;
    }

    private String[] makeLine(String userName, UserInfo data) {
        String[] line = new String[17];
        int column = 0;
        line[column++] = userName;
        line[column++] = Integer.toString(data.getScore());
        try {
            int i;
            for (i = 0; i < 10; ++i) {
                line[column++] = Integer.toString(data.getInt(i));
            }
            for (i = 0; i < 5; ++i) {
                line[column++] = data.getString(i);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return line;
    }

    @Override
    public boolean storeCurrentUserInfo(UserInfo data) {
        List<String[]> all;
        if (this.getUserName() == null || this.getUserName().isEmpty()) {
            return false;
        }
        try {
            CSVReader csv = new CSVReader((Reader)new InputStreamReader((InputStream)new FileInputStream("storage.csv"), "UTF-8"));
            all = csv.readAll();
            csv.close();
        }
        catch (FileNotFoundException e) {
            all = new ArrayList();
        }
        catch (IOException e) {
            Debug.message((String)("Error reading user data: " + e.getMessage()));
            return false;
        }
        Iterator lineIt = all.iterator();
        while (lineIt.hasNext()) {
            String[] line = (String[])lineIt.next();
            if (line.length <= 1 || !this.getUserName().equals(line[0])) continue;
            lineIt.remove();
            break;
        }
        if (data != null) {
            all.add(this.makeLine(this.getUserName(), data));
        }
        try {
            CSVWriter csvOut = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream("storage.csv"), "UTF-8"));
            csvOut.writeAll(all);
            csvOut.close();
            return true;
        }
        catch (IOException e) {
            Debug.message((String)("Error storing user data: " + e.getMessage()));
            return false;
        }
    }

    private ArrayList<UserInfo> getAllDataSorted(boolean useSingleton) {
        try {
            ArrayList<UserInfo> ret = new ArrayList<UserInfo>();
            CSVReader csv = new CSVReader((Reader)new InputStreamReader((InputStream)new FileInputStream("storage.csv"), "UTF-8"));
            List all = csv.readAll();
            Collections.sort(all, new Comparator<String[]>(){

                @Override
                public int compare(String[] o1, String[] o2) {
                    return -(Integer.parseInt(o1[1]) - Integer.parseInt(o2[1]));
                }
            });
            int rank = 1;
            for (String[] line : all) {
                ret.add(this.makeStorage(line, rank, useSingleton));
                ++rank;
            }
            csv.close();
            return ret;
        }
        catch (FileNotFoundException e) {
            return new ArrayList<UserInfo>();
        }
        catch (IOException e) {
            Debug.message((String)("Error reading user data: " + e.getMessage()));
            return null;
        }
    }

    @Override
    public List<UserInfo> getTopUserInfo(int limit) {
        ArrayList<UserInfo> ret = this.getAllDataSorted(false);
        if (ret == null) {
            return null;
        }
        if (ret.size() <= limit || limit <= 0) {
            return ret;
        }
        return ret.subList(0, limit);
    }

    @Override
    public GreenfootImage getUserImage(String userName) {
        return null;
    }

    @Override
    public List<UserInfo> getNearbyUserInfo(int maxAmount) {
        if (this.getUserName() == null || this.getUserName().isEmpty()) {
            return null;
        }
        ArrayList<UserInfo> all = this.getAllDataSorted(false);
        if (all == null) {
            return null;
        }
        int index = -1;
        for (int i = 0; i < all.size(); ++i) {
            if (this.getUserName() == null || !this.getUserName().equals(all.get(i).getUserName())) continue;
            index = i;
            break;
        }
        if (index == -1 || maxAmount == 0) {
            return new ArrayList<UserInfo>();
        }
        int availableBefore = index;
        int availableAfter = all.size() - 1 - index;
        int desiredBefore = maxAmount / 2;
        int desiredAfter = Math.max(0, maxAmount - 1) / 2;
        if (availableAfter + availableBefore + 1 <= maxAmount) {
            return all;
        }
        if (availableBefore <= desiredBefore) {
            return all.subList(index - availableBefore, index - availableBefore + maxAmount + 1);
        }
        if (availableAfter <= desiredAfter) {
            return all.subList(index + availableAfter - maxAmount, index + availableAfter + 1);
        }
        return all.subList(index - desiredBefore, index + desiredAfter + 1);
    }

    public static void showApiDoc(String page) throws IOException {
        try {
            String customUrl = Utility.getGreenfootApiDocURL((String)page);
            if (customUrl != null) {
                BlueJRMIClient.instance().getPackage().getProject().openBrowser(customUrl);
            }
        }
        catch (ProjectNotOpenException e) {
            Debug.reportError((Throwable)e);
        }
    }
}

