/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.images;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.extensions.SourceType;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import bluej.utility.EscapeDialog;
import bluej.utility.FileUtility;
import greenfoot.actions.BrowseImagesAction;
import greenfoot.core.GClass;
import greenfoot.core.GPackage;
import greenfoot.core.GProject;
import greenfoot.event.ValidityEvent;
import greenfoot.event.ValidityListener;
import greenfoot.gui.ClassNameVerifier;
import greenfoot.gui.classbrowser.ClassView;
import greenfoot.gui.images.GreenfootImageLibPanel;
import greenfoot.gui.images.ImageCategorySelector;
import greenfoot.gui.images.ImageLibList;
import greenfoot.gui.images.ImageSelectionWatcher;
import greenfoot.gui.images.NewImageDialog;
import greenfoot.gui.images.PopupMenuButton;
import greenfoot.util.ExternalAppLauncher;
import greenfoot.util.GreenfootUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ImageLibFrame
extends EscapeDialog
implements ListSelectionListener,
WindowListener {
    private GClass gclass;
    private GProject proj;
    private BufferedImage defaultIcon;
    private JScrollPane imageScrollPane;
    private ImageLibList projImageList;
    private ImageLibList greenfootImageList;
    private Action okAction;
    private File selectedImageFile;
    private File projImagesDir;
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private int result = 1;
    private JTextField classNameField;
    private SourceType language;
    private JMenuItem editItem;
    private JMenuItem duplicateItem;
    private JMenuItem deleteItem;
    private Timer refreshTimer;
    private static final String COPY_SUFFIX = "Copy";
    private static final String DROPDOWN_ICON_FILE = "menu-button.png";
    private ImageSelectionWatcher selectionWatcher;

    public ImageLibFrame(JFrame owner, ClassView classView, ImageSelectionWatcher watcher) {
        super((Frame)owner, Config.getString((String)"imagelib.title") + " " + classView.getClassName(), true);
        this.selectionWatcher = watcher;
        this.gclass = classView.getGClass();
        this.proj = this.gclass.getPackage().getProject();
        GClass superClass = this.gclass.getSuperclass();
        this.defaultIcon = ImageLibFrame.getClassImage(superClass);
        this.buildUI(owner, this.proj, false, null);
        this.projImageList.select(ImageLibFrame.getSpecifiedImage(this.gclass));
    }

    public ImageLibFrame(JFrame owner, GClass superClass, String title, String defaultName, List<String> description) {
        super((Frame)owner, title, true);
        this.gclass = superClass;
        this.proj = this.gclass.getPackage().getProject();
        this.defaultIcon = ImageLibFrame.getClassImage(superClass);
        this.buildUI(owner, this.proj, true, description);
        this.projImageList.select(null);
        if (defaultName != null) {
            this.classNameField.setText(defaultName);
        }
        this.classNameField.requestFocus();
    }

    private void buildUI(JFrame owner, GProject project, boolean includeClassNameField, List<String> description) {
        this.addWindowListener(this);
        JPanel contentPane = new JPanel();
        this.setContentPane(contentPane);
        contentPane.setLayout(new BoxLayout(this.getContentPane(), 1));
        contentPane.setBorder(BlueJTheme.dialogBorder);
        int spacingLarge = 11;
        this.okAction = this.getOkAction();
        if (description != null) {
            description.forEach(t -> {
                JLabel l = new JLabel((String)t);
                l.setFocusable(false);
                l.setAlignmentX(0.0f);
                l.setFont(l.getFont().deriveFont(1));
                l.setBackground(new Color(0, 0, 0, 0));
                l.setBorder(null);
                contentPane.add(l);
            });
            contentPane.add(ImageLibFrame.fixHeight(Box.createVerticalStrut(spacingLarge)));
        }
        contentPane.add(this.buildClassDetailsPanel(includeClassNameField, project.getDefaultPackage()));
        Box imageSelPanels = new Box(0);
        Box piPanel = new Box(1);
        JLabel piLabel = new JLabel(Config.getString((String)"imagelib.projectImages"));
        piLabel.setAlignmentX(0.0f);
        piPanel.add(piLabel);
        this.imageScrollPane = new JScrollPane();
        File projDir = project.getDir();
        this.projImagesDir = new File(projDir, "images");
        this.projImageList = new ImageLibList(this.projImagesDir, false, this, this.defaultIcon);
        this.imageScrollPane.getViewport().setView(this.projImageList);
        this.imageScrollPane.setBorder(Config.getNormalBorder());
        this.imageScrollPane.setViewportBorder(BorderFactory.createLineBorder(this.projImageList.getBackground(), 4));
        this.imageScrollPane.setAlignmentX(0.0f);
        piPanel.add(this.imageScrollPane);
        imageSelPanels.add(piPanel);
        imageSelPanels.add(GreenfootUtil.createSpacer(0, spacingLarge));
        File imageDir = new File(Config.getGreenfootLibDir(), "imagelib");
        ImageCategorySelector imageCategorySelector = new ImageCategorySelector(imageDir);
        this.greenfootImageList = new ImageLibList(false, this);
        GreenfootImageLibPanel greenfootLibPanel = new GreenfootImageLibPanel(imageCategorySelector, this.greenfootImageList);
        imageSelPanels.add(greenfootLibPanel);
        imageSelPanels.setAlignmentX(0.0f);
        contentPane.add(imageSelPanels);
        this.projImageList.addListSelectionListener(this);
        this.greenfootImageList.addListSelectionListener(this);
        imageCategorySelector.setImageLibList(this.greenfootImageList);
        JPanel borderPanel = new JPanel();
        BorderLayout layout = new BorderLayout();
        borderPanel.setLayout(layout);
        JPopupMenu popupMenu = new JPopupMenu();
        this.editItem = new JMenuItem(Config.getString((String)"imagelib.edit"));
        this.editItem.setToolTipText(Config.getString((String)"imagelib.edit.tooltip"));
        this.editItem.setEnabled(false);
        this.editItem.setFont(PrefMgr.getPopupMenuFont());
        this.editItem.addActionListener(e -> {
            ImageLibList.ImageListEntry entry = (ImageLibList.ImageListEntry)this.projImageList.getSelectedValue();
            if (entry != null && entry.imageFile != null) {
                ExternalAppLauncher.editImage(entry.imageFile);
            }
        });
        this.duplicateItem = new JMenuItem(Config.getString((String)"imagelib.duplicate"));
        this.duplicateItem.setToolTipText(Config.getString((String)"imagelib.duplicate.tooltip"));
        this.duplicateItem.setEnabled(false);
        this.duplicateItem.setFont(PrefMgr.getPopupMenuFont());
        this.duplicateItem.addActionListener(e -> {
            ImageLibList.ImageListEntry entry = (ImageLibList.ImageListEntry)this.projImageList.getSelectedValue();
            if (entry != null && entry.imageFile != null) {
                this.duplicateSelected(entry);
            }
        });
        this.deleteItem = new JMenuItem(Config.getString((String)"imagelib.delete"));
        this.deleteItem.setToolTipText(Config.getString((String)"imagelib.delete.tooltip"));
        this.deleteItem.setEnabled(false);
        this.deleteItem.setFont(PrefMgr.getPopupMenuFont());
        this.deleteItem.addActionListener(e -> {
            ImageLibList.ImageListEntry entry = (ImageLibList.ImageListEntry)this.projImageList.getSelectedValue();
            if (entry != null && entry.imageFile != null) {
                this.confirmDelete(entry);
            }
        });
        JMenuItem newImageItem = new JMenuItem(Config.getString((String)"imagelib.create.button"));
        newImageItem.setToolTipText(Config.getString((String)"imagelib.create.tooltip"));
        newImageItem.setFont(PrefMgr.getPopupMenuFont());
        newImageItem.addActionListener(e -> {
            String name = includeClassNameField ? this.getClassName() : this.gclass.getName();
            NewImageDialog newImage = new NewImageDialog((JDialog)((Object)this), this.projImagesDir, name);
            File file = newImage.displayModal();
            if (file != null) {
                this.projImageList.refresh();
                this.projImageList.select(file);
                this.selectImage(file);
            }
        });
        JMenuItem importImageItem = new JMenuItem(Config.getString((String)"imagelib.browse.button"));
        importImageItem.setFont(PrefMgr.getPopupMenuFont());
        importImageItem.setAction(new BrowseImagesAction(Config.getString((String)"imagelib.browse.button"), (JDialog)((Object)this), this.projImagesDir, this.projImageList));
        popupMenu.add(ImageLibFrame.fixHeight(this.editItem));
        popupMenu.add(ImageLibFrame.fixHeight(this.duplicateItem));
        popupMenu.add(ImageLibFrame.fixHeight(this.deleteItem));
        popupMenu.add(ImageLibFrame.fixHeight(newImageItem));
        popupMenu.add(ImageLibFrame.fixHeight(importImageItem));
        PopupMenuButton dropDownButton = new PopupMenuButton(new ImageIcon(ImageLibFrame.class.getClassLoader().getResource(DROPDOWN_ICON_FILE)), popupMenu);
        borderPanel.setAlignmentX(0.0f);
        borderPanel.add(ImageLibFrame.fixHeight(dropDownButton), "Before");
        contentPane.add(ImageLibFrame.fixHeight(Box.createVerticalStrut(spacingLarge)));
        contentPane.add(ImageLibFrame.fixHeight(borderPanel));
        contentPane.add(ImageLibFrame.fixHeight(Box.createVerticalStrut(spacingLarge)));
        contentPane.add(ImageLibFrame.fixHeight(new JSeparator()));
        JPanel okCancelPanel = new JPanel();
        okCancelPanel.setLayout(new BoxLayout(okCancelPanel, 0));
        JButton okButton = BlueJTheme.getOkButton();
        okButton.setAction(this.okAction);
        JButton cancelButton = BlueJTheme.getCancelButton();
        cancelButton.setVerifyInputWhenFocusTarget(false);
        cancelButton.addActionListener(e -> {
            this.result = 1;
            this.setVisible(false);
            this.dispose();
        });
        okCancelPanel.add(Box.createHorizontalGlue());
        if (Config.isMacOS()) {
            okCancelPanel.add(cancelButton);
            okCancelPanel.add(Box.createHorizontalStrut(spacingLarge));
            okCancelPanel.add(okButton);
        } else {
            okCancelPanel.add(okButton);
            okCancelPanel.add(Box.createHorizontalStrut(spacingLarge));
            okCancelPanel.add(cancelButton);
        }
        okCancelPanel.setAlignmentX(0.0f);
        okCancelPanel.validate();
        contentPane.add(ImageLibFrame.fixHeight(Box.createVerticalStrut(spacingLarge)));
        contentPane.add(ImageLibFrame.fixHeight(okCancelPanel));
        this.getRootPane().setDefaultButton(okButton);
        this.refreshTimer = new Timer(2000, e -> this.projImageList.refreshPreviews());
        this.refreshTimer.start();
        this.pack();
    }

    private JPanel buildClassDetailsPanel(boolean includeClassNameField, GPackage pkg) {
        JPanel classDetailsPanel = new JPanel();
        classDetailsPanel.setLayout(new BoxLayout(classDetailsPanel, 1));
        int spacingLarge = 11;
        int spacingSmall = 5;
        if (includeClassNameField) {
            Box b = new Box(0);
            JLabel classNameLabel = new JLabel(Config.getString((String)"imagelib.className"));
            b.add(classNameLabel);
            this.okAction.setEnabled(false);
            this.classNameField = new JTextField(12);
            final JLabel errorMsgLabel = new JLabel();
            errorMsgLabel.setVisible(false);
            errorMsgLabel.setForeground(Color.RED);
            ClassNameVerifier classNameVerifier = new ClassNameVerifier(this.classNameField, pkg);
            classNameVerifier.addValidityListener(new ValidityListener(){

                @Override
                public void changedToInvalid(ValidityEvent e) {
                    errorMsgLabel.setText(e.getReason());
                    errorMsgLabel.setVisible(true);
                    ImageLibFrame.this.okAction.setEnabled(false);
                }

                @Override
                public void changedToValid(ValidityEvent e) {
                    errorMsgLabel.setVisible(false);
                    ImageLibFrame.this.okAction.setEnabled(true);
                }
            });
            b.add(Box.createHorizontalStrut(spacingLarge));
            b.add(ImageLibFrame.fixHeight(this.classNameField));
            b.add(Box.createHorizontalStrut(spacingLarge));
            SourceType[] items = new SourceType[]{SourceType.Stride, SourceType.Java};
            JComboBox<SourceType> languageSelectionBox = new JComboBox<SourceType>(items);
            languageSelectionBox.addActionListener(e -> {
                this.language = (SourceType)languageSelectionBox.getSelectedItem();
            });
            languageSelectionBox.setSelectedItem(pkg.getDefaultSourceType());
            b.add(languageSelectionBox);
            b.setAlignmentX(0.0f);
            classDetailsPanel.add(b);
            classDetailsPanel.add(errorMsgLabel);
            classDetailsPanel.add(Box.createVerticalStrut(spacingLarge));
        }
        JLabel helpLabel = new JLabel(Config.getString((String)"imagelib.help.selectImage"));
        Font smallFont = helpLabel.getFont().deriveFont(2, 11.0f);
        helpLabel.setFont(smallFont);
        classDetailsPanel.add(ImageLibFrame.fixHeight(helpLabel));
        classDetailsPanel.add(ImageLibFrame.fixHeight(Box.createVerticalStrut(spacingLarge)));
        classDetailsPanel.add(ImageLibFrame.fixHeight(new JSeparator()));
        classDetailsPanel.add(Box.createVerticalStrut(spacingSmall));
        classDetailsPanel.setAlignmentX(0.0f);
        return classDetailsPanel;
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        Object source = lse.getSource();
        if (!lse.getValueIsAdjusting() && source instanceof ImageLibList) {
            ImageLibList sourceList = (ImageLibList)source;
            ImageLibList.ImageListEntry ile = (ImageLibList.ImageListEntry)sourceList.getSelectedValue();
            if (ile != null && ile.imageFile != null) {
                File imageFile = ile.imageFile;
                this.selectImage(imageFile);
                this.setItemButtons(sourceList == this.projImageList);
            } else {
                this.selectImage(null);
                this.setItemButtons(false);
            }
        }
        if (lse.getValueIsAdjusting() && source instanceof ImageLibList) {
            if (lse.getSource() == this.projImageList) {
                this.greenfootImageList.clearSelection();
            } else {
                this.projImageList.clearSelection();
            }
        }
    }

    private void setItemButtons(boolean state) {
        this.editItem.setEnabled(state);
        this.duplicateItem.setEnabled(state);
        this.deleteItem.setEnabled(state);
    }

    private void selectImage(File imageFile) {
        if (imageFile == null || GreenfootUtil.isImage(imageFile)) {
            this.selectedImageFile = imageFile;
            if (this.selectionWatcher != null) {
                this.selectionWatcher.imageSelected(this.selectedImageFile);
            }
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), imageFile.getName() + " " + Config.getString((String)"imagelib.image.invalid.text"), Config.getString((String)"imagelib.image.invalid.title"), 0);
        }
    }

    private static File getSpecifiedImage(GClass gclass) {
        String imageName = gclass.getClassProperty("image");
        if (imageName != null && !imageName.equals("")) {
            return new File(new File("images"), imageName).getAbsoluteFile();
        }
        return null;
    }

    private static BufferedImage getClassImage(GClass gclass) {
        try {
            while (gclass != null) {
                File imageFile = ImageLibFrame.getSpecifiedImage(gclass);
                if (imageFile != null && imageFile.canRead()) {
                    try {
                        return ImageIO.read(imageFile);
                    }
                    catch (IOException e) {
                        Debug.reportError((String)("Can't read image file: " + imageFile.getAbsolutePath()), (Throwable)e);
                    }
                }
                gclass = gclass.getSuperclass();
            }
            return ImageIO.read(new File(GreenfootUtil.getGreenfootLogoPath()));
        }
        catch (IOException e) {
            Debug.reportError((String)"Can't read Greenfoot logo image", (Throwable)e);
            return null;
        }
    }

    private static Component fixHeight(Component src) {
        Dimension d = src.getMaximumSize();
        d.height = src.getPreferredSize().height;
        src.setMaximumSize(d);
        return src;
    }

    public File getSelectedImageFile() {
        return this.selectedImageFile;
    }

    public int getResult() {
        return this.result;
    }

    public String getClassName() {
        return this.classNameField.getText();
    }

    public SourceType getSelectedLanguage() {
        return this.language;
    }

    private AbstractAction getOkAction() {
        return new AbstractAction(Config.getString((String)"okay")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageLibFrame.this.result = 0;
                ImageLibFrame.this.setVisible(false);
                ImageLibFrame.this.dispose();
            }
        };
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.refreshTimer.stop();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.refreshTimer.stop();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    protected void duplicateSelected(ImageLibList.ImageListEntry entry) {
        File srcFile = entry.imageFile;
        File dstFile = null;
        File dir = srcFile.getParentFile();
        String fileName = srcFile.getName();
        int index = fileName.indexOf(46);
        String baseName = null;
        String ext = null;
        if (index != -1) {
            baseName = fileName.substring(0, index);
            ext = fileName.substring(index + 1);
        } else {
            baseName = fileName;
            ext = "";
        }
        baseName = baseName + COPY_SUFFIX;
        try {
            dstFile = GreenfootUtil.createNumberedFile(dir, baseName, ext);
            FileUtility.copyFile((File)srcFile, (File)dstFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (dstFile != null) {
            this.projImageList.select(dstFile);
        }
    }

    private void confirmDelete(ImageLibList.ImageListEntry entry) {
        String text = Config.getString((String)"imagelib.delete.confirm.text") + " " + entry.imageFile.getName() + "?";
        int optionResult = JOptionPane.showConfirmDialog((Component)((Object)this), text, Config.getString((String)"imagelib.delete.confirm.title"), 0);
        if (optionResult == 0) {
            entry.imageFile.delete();
            this.projImageList.refresh();
        }
    }
}

