/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.classbrowser;

import greenfoot.gui.classbrowser.Selectable;
import greenfoot.gui.classbrowser.SelectionListener;
import javax.swing.event.EventListenerList;

public class SelectionManager
implements SelectionListener {
    Selectable selected = null;
    private EventListenerList listenerList = new EventListenerList();

    public Object getSelected() {
        return this.selected;
    }

    protected void fireSelectionChangeEvent(Selectable selectable) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SelectionListener.class) continue;
            ((SelectionListener)listeners[i + 1]).selectionChange(selectable);
        }
    }

    public void addSelectionChangeListener(SelectionListener l) {
        this.listenerList.add(SelectionListener.class, l);
    }

    @Override
    public void selectionChange(Selectable source) {
        if (source == this.selected) {
            if (!source.isSelected()) {
                this.selected = null;
                this.fireSelectionChangeEvent(this.selected);
            }
        } else if (source.isSelected()) {
            this.selected = source;
            this.fireSelectionChangeEvent(this.selected);
        }
    }
}

