/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.classbrowser;

import bluej.Config;
import bluej.extensions.SourceType;
import bluej.utility.DialogManager;
import greenfoot.core.GClass;
import greenfoot.core.GPackage;
import greenfoot.core.GProject;
import greenfoot.core.GreenfootMain;
import greenfoot.core.Simulation;
import greenfoot.core.WorldHandler;
import greenfoot.event.ActorInstantiationListener;
import greenfoot.gui.classbrowser.ClassBrowser;
import greenfoot.gui.classbrowser.ClassButton;
import greenfoot.gui.classbrowser.SelectionListener;
import greenfoot.gui.classbrowser.role.ActorClassRole;
import greenfoot.gui.classbrowser.role.ClassRole;
import greenfoot.gui.classbrowser.role.NormalClassRole;
import greenfoot.gui.classbrowser.role.WorldClassRole;
import greenfoot.gui.input.mouse.LocationTracker;
import greenfoot.platforms.ide.GreenfootUtilDelegateIDE;
import greenfoot.record.InteractionListener;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;

public class ClassView
extends ClassButton {
    GClass gClass;
    private ClassRole role;
    ClassBrowser classBrowser;
    private String superclass;
    private InteractionListener interactionListener;

    public ClassView(ClassBrowser classBrowser, GClass gClass, InteractionListener interactionListener) {
        this.classBrowser = classBrowser;
        this.interactionListener = interactionListener;
        this.init(gClass);
    }

    public boolean isCoreClass() {
        return this.gClass.isActorClass() || this.gClass.isWorldClass();
    }

    public void updateSuperClass() {
        String superClassGuess = this.getSuperclass();
        if (superClassGuess == null || superClassGuess.equals(this.superclass)) {
            return;
        }
        this.superclass = this.getSuperclass();
        if (this.classBrowser != null) {
            this.classBrowser.consolidateLayout(this);
        }
    }

    private ClassRole determineRole(GProject project) {
        ClassRole classRole = null;
        classRole = this.gClass.isActorClass() ? new ActorClassRole(project) : (this.gClass.isWorldClass() ? new WorldClassRole(project, false) : (this.gClass.isActorSubclass() ? new ActorClassRole(project) : (this.gClass.isWorldSubclass() ? new WorldClassRole(project, true) : NormalClassRole.getInstance())));
        return classRole;
    }

    public void setSuperclass(String superclass) {
        this.superclass = superclass;
    }

    private void init(GClass gClass) {
        this.gClass = gClass;
        gClass.setClassView(this);
        this.superclass = this.getSuperclass();
        this.initUI();
        this.update();
    }

    public Class<?> getRealClass() {
        return this.gClass.getJavaClass();
    }

    public GClass getGClass() {
        return this.gClass;
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu popupMenu = this.role.createPopupMenu(this.classBrowser, this, this.interactionListener, this.isUncompiled(), this.hasKnownError());
        popupMenu.setInvoker(this);
        return popupMenu;
    }

    private void setRole(ClassRole role) {
        WorldHandler.getInstance().removeWorldListener(this.role);
        this.role = role;
        WorldHandler.getInstance().addWorldListener(this.role);
    }

    private void update() {
        this.clearUI();
        this.setRole(this.determineRole(this.classBrowser.getProject()));
        this.role.buildUI(this, this.gClass);
        this.updateSuperClass();
    }

    public ClassRole getRole() {
        return this.role;
    }

    public String getQualifiedClassName() {
        return this.gClass.getQualifiedName();
    }

    public String getClassName() {
        return this.gClass.getName();
    }

    @Override
    public void select() {
        this.setSelected(true);
        this.fireSelectionChangeEvent();
    }

    @Override
    public boolean deselect() {
        if (this.isSelected()) {
            this.setSelected(false);
            this.fireSelectionChangeEvent();
            return true;
        }
        return false;
    }

    public void createInstance() {
        Simulation.getInstance().runLater(new Runnable(){

            @Override
            public void run() {
                Class<?> realClass = ClassView.this.getRealClass();
                try {
                    if (realClass == null) {
                        return;
                    }
                    Constructor<?> constructor = realClass.getConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    Object newObject = Simulation.newInstance(constructor);
                    ClassView.this.interactionListener.createdActor(newObject, new String[0], null);
                    ActorInstantiationListener invocationListener = GreenfootMain.getInstance().getInvocationListener();
                    if (invocationListener != null) {
                        invocationListener.localObjectCreated(newObject, LocationTracker.instance().getMouseButtonEvent());
                    }
                    return;
                }
                catch (LinkageError le) {
                    le.printStackTrace();
                }
                catch (NoSuchMethodException le) {
                }
                catch (IllegalArgumentException le) {
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause != null) {
                        StackTraceElement[] strace = cause.getStackTrace();
                        for (int i = strace.length; i > 0; --i) {
                            if (!strace[i - 1].getClassName().equals(realClass.getName())) continue;
                            StackTraceElement[] newStrace = new StackTraceElement[i];
                            System.arraycopy(strace, 0, newStrace, 0, i);
                            cause.setStackTrace(newStrace);
                            break;
                        }
                        cause.printStackTrace();
                    }
                    e.printStackTrace();
                }
            }
        });
    }

    public GClass createSubclass(String className, SourceType language) {
        try {
            GProject proj = this.gClass.getPackage().getProject();
            GPackage pkg = proj.getDefaultPackage();
            File dir = proj.getDir();
            String extension = language.toString().toLowerCase();
            File newFile = new File(dir, className + "." + extension);
            String superClassName = this.getClassName();
            GreenfootUtilDelegateIDE.getInstance().createSkeleton(className, superClassName, newFile, this.role.getTemplateFileName(false, language), proj.getCharsetName());
            GClass newClass = pkg.newClass(className, extension, false);
            newClass.setSuperclassGuess(this.getQualifiedClassName());
            return newClass;
        }
        catch (IOException ioe) {
            DialogManager.showErrorText((Component)this, (String)(Config.getString((String)"greenfoot.cannotCreateClass") + ": " + ioe.getLocalizedMessage()));
            return null;
        }
    }

    public void remove() {
        WorldHandler.getInstance().removeWorldListener(this.role);
        this.role.remove();
        this.classBrowser.removeClass(this);
        this.gClass.remove();
        this.gClass = null;
    }

    public String getSuperclass() {
        return this.gClass.getSuperclassGuess();
    }

    protected void fireSelectionChangeEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SelectionListener.class) continue;
            ((SelectionListener)listeners[i + 1]).selectionChange(this);
        }
    }

    public void addSelectionChangeListener(SelectionListener l) {
        this.listenerList.add(SelectionListener.class, l);
    }

    public void removeSelectionChangeListener(SelectionListener l) {
        this.listenerList.remove(SelectionListener.class, l);
    }

    public void nameChanged(String oldName) {
        this.classBrowser.renameClass(this, oldName);
        this.updateView();
    }

    public void updateView() {
        this.update();
        JRootPane rootPane = this.getRootPane();
        if (rootPane != null) {
            this.getRootPane().revalidate();
        }
    }

    @Override
    protected boolean isValidClass() {
        return this.gClass != null;
    }

    @Override
    protected boolean isUncompiled() {
        return !this.gClass.isCompiled();
    }

    @Override
    protected boolean hasKnownError() {
        return this.gClass.hasKnownError();
    }

    @Override
    protected void doubleClick() {
        this.gClass.edit();
    }

    @Override
    protected void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void removeStrideFileOnly() {
        this.gClass.removeStrideFile();
    }
}

