/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.classbrowser;

import bluej.utility.Utility;
import greenfoot.gui.classbrowser.Selectable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JToggleButton;

public abstract class ClassButton
extends JToggleButton
implements MouseListener,
Selectable {
    private final Color classColour = new Color(245, 204, 155);
    private static final Color errorStripeColor = new Color(180, 50, 20);
    private static final Color stripeColor = new Color(152, 152, 152);
    public static final Color[] shadowColours = new Color[]{new Color(242, 242, 242), new Color(211, 211, 211), new Color(189, 189, 189), new Color(83, 83, 83)};
    private static final int SHADOW = 4;
    private static final int GAP = 2;
    private static final int SELECTED_BORDER = 3;

    protected abstract boolean isValidClass();

    protected abstract boolean isUncompiled();

    protected abstract boolean hasKnownError();

    protected abstract void doubleClick();

    protected abstract void maybeShowPopup(MouseEvent var1);

    protected void initUI() {
        this.addMouseListener(this);
        this.setBorder(BorderFactory.createEmptyBorder(7, 8, 10, 11));
        Font font = this.getFont();
        font = font.deriveFont(13.0f);
        this.setFont(font);
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.isValidClass()) {
            this.drawBackground(g);
            super.paintComponent(g);
            this.drawShadow((Graphics2D)g);
            this.drawBorders((Graphics2D)g);
        }
    }

    private void drawBackground(Graphics g) {
        int height = this.getHeight() - 4 - 2;
        int width = this.getWidth() - 4;
        g.setColor(this.classColour);
        g.fillRect(0, 2, width, height);
        if (this.isUncompiled()) {
            Utility.stripeRect((Graphics)g, (int)0, (int)2, (int)width, (int)height, (int)8, (int)3, (Color)(this.hasKnownError() ? errorStripeColor : stripeColor));
            g.fillRect(7, 9, width - 14, height - 14);
        }
    }

    protected void drawShadow(Graphics2D g) {
        int height = this.getHeight() - 4;
        int width = this.getWidth() - 4;
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width + 4, 2);
        g.fillRect(0, height, 6, height + 4);
        g.fillRect(width, 0, width + 3, 10);
        g.setColor(shadowColours[3]);
        g.drawLine(3, height, width, height);
        g.setColor(shadowColours[2]);
        g.drawLine(4, height + 1, width, height + 1);
        g.drawLine(width + 1, height + 2, width + 1, 5);
        g.setColor(shadowColours[1]);
        g.drawLine(5, height + 2, width + 1, height + 2);
        g.drawLine(width + 2, height + 3, width + 2, 6);
        g.setColor(shadowColours[0]);
        g.drawLine(6, height + 3, width + 2, height + 3);
        g.drawLine(width + 3, height + 3, width + 3, 7);
    }

    protected void drawBorders(Graphics2D g) {
        g.setColor(Color.BLACK);
        int thickness = this.isSelected() ? 3 : 1;
        Utility.drawThickRect((Graphics)g, (int)0, (int)2, (int)(this.getWidth() - 4), (int)(this.getHeight() - 4 - 2 - 1), (int)thickness);
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1 && (e.getModifiers() & 0x10) != 0) {
            this.doubleClick();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.select();
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.select();
        this.maybeShowPopup(e);
    }

    protected void clearUI() {
        this.removeAll();
    }
}

