/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.classbrowser;

import bluej.Config;
import bluej.extensions.CompilationNotStartedException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.utility.Debug;
import greenfoot.core.GProject;
import greenfoot.gui.GreenfootFrame;
import greenfoot.gui.classbrowser.ArrowConnect;
import greenfoot.gui.classbrowser.ArrowConnectEnd;
import greenfoot.gui.classbrowser.ArrowHead;
import greenfoot.gui.classbrowser.ArrowHeadEnd;
import greenfoot.gui.classbrowser.ArrowLine;
import greenfoot.gui.classbrowser.ClassForest;
import greenfoot.gui.classbrowser.ClassView;
import greenfoot.gui.classbrowser.EmptySpace;
import greenfoot.gui.classbrowser.SelectionManager;
import greenfoot.gui.classbrowser.role.ActorClassRole;
import greenfoot.gui.classbrowser.role.WorldClassRole;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.border.TitledBorder;

public class ClassBrowser
extends JPanel {
    private ButtonGroup buttonGroup = new ButtonGroup();
    private SelectionManager selectionManager = new SelectionManager();
    private ClassForest worldClasses = new ClassForest();
    private ClassForest greenfootClasses = new ClassForest();
    private ClassForest otherClasses = new ClassForest();
    private GProject project;
    private GreenfootFrame frame;

    public ClassBrowser(GProject project, GreenfootFrame frame) {
        this.project = project;
        this.frame = frame;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setBackground(Color.WHITE);
        this.worldClasses = new ClassForest();
        this.greenfootClasses = new ClassForest();
        this.otherClasses = new ClassForest();
    }

    public void quickAddClass(ClassView classView) {
        if (classView.getRole() instanceof ActorClassRole) {
            this.greenfootClasses.add(classView);
        } else if (classView.getRole() instanceof WorldClassRole) {
            this.worldClasses.add(classView);
        } else {
            this.otherClasses.add(classView);
        }
        this.buttonGroup.add(classView);
        classView.addSelectionChangeListener(this.selectionManager);
    }

    public void addClass(ClassView classView) {
        this.quickAddClass(classView);
        try {
            classView.getGClass().compile(false, true);
        }
        catch (CompilationNotStartedException | PackageNotFoundException | ProjectNotOpenException | RemoteException e) {
            Debug.reportError((Throwable)e);
        }
        classView.select();
        this.updateLayout();
    }

    public void removeClass(ClassView classView) {
        this.buttonGroup.remove(classView);
        classView.deselect();
        ClassForest.TreeEntry treeEntry = this.removeFromForest(classView);
        List<ClassForest.TreeEntry> children = treeEntry.getChildren();
        for (ClassForest.TreeEntry child : children) {
            this.otherClasses.add(child);
            child.getData().setSuperclass(null);
        }
        classView.removeSelectionChangeListener(this.selectionManager);
        this.updateLayout();
    }

    private ClassForest.TreeEntry removeFromForest(ClassView classView) {
        ClassForest.TreeEntry removedEntry = this.greenfootClasses.remove(classView);
        if (removedEntry == null) {
            removedEntry = this.worldClasses.remove(classView);
        }
        if (removedEntry == null) {
            removedEntry = this.otherClasses.remove(classView);
        }
        return removedEntry;
    }

    public void renameClass(ClassView classView, String oldName) {
        this.greenfootClasses.rename(classView, oldName);
        this.worldClasses.rename(classView, oldName);
        this.otherClasses.rename(classView, oldName);
    }

    public void updateLayout() {
        JRootPane rootPane;
        JComponent otherClassPanel;
        this.greenfootClasses.rebuild();
        this.worldClasses.rebuild();
        this.otherClasses.rebuild();
        this.removeAll();
        JComponent worldClassPanel = this.createClassHierarchyComponent(this.worldClasses.getRoots(), false);
        JPanel worldFrame = new JPanel();
        ((FlowLayout)worldFrame.getLayout()).setAlignment(0);
        worldFrame.setBackground(Color.WHITE);
        worldFrame.add(worldClassPanel);
        TitledBorder border = BorderFactory.createTitledBorder(null, Config.getString((String)"browser.border.world"));
        border.setTitleColor(Color.GRAY);
        worldFrame.setBorder(border);
        this.add((Component)worldFrame, "North");
        JComponent greenfootClassPanel = this.createClassHierarchyComponent(this.greenfootClasses.getRoots(), false);
        if (greenfootClassPanel != null) {
            JPanel objectFrame = new JPanel();
            ((FlowLayout)objectFrame.getLayout()).setAlignment(0);
            objectFrame.setBackground(Color.WHITE);
            objectFrame.add(greenfootClassPanel);
            border = BorderFactory.createTitledBorder(null, Config.getString((String)"browser.border.actors"));
            border.setTitleColor(Color.GRAY);
            objectFrame.setBorder(border);
            this.add((Component)objectFrame, "Center");
        }
        if (!this.otherClasses.getRoots().isEmpty() && (otherClassPanel = this.createClassHierarchyComponent(this.otherClasses.getRoots(), false)) != null) {
            JPanel objectFrame = new JPanel();
            ((FlowLayout)objectFrame.getLayout()).setAlignment(0);
            objectFrame.setBackground(Color.WHITE);
            objectFrame.add(otherClassPanel);
            border = BorderFactory.createTitledBorder(null, Config.getString((String)"browser.border.others"));
            border.setTitleColor(Color.GRAY);
            objectFrame.setBorder(border);
            this.add((Component)objectFrame, "South");
        }
        if ((rootPane = this.getRootPane()) != null) {
            this.getRootPane().revalidate();
        }
    }

    private JComponent createClassHierarchyComponent(Collection<ClassForest.TreeEntry> roots, boolean isRecursiveCall) {
        JPanel hierarchyPanel = new JPanel();
        hierarchyPanel.setOpaque(false);
        hierarchyPanel.setLayout(new BoxLayout(hierarchyPanel, 1));
        boolean isFirstSubclass = true;
        Iterator<ClassForest.TreeEntry> iter = roots.iterator();
        while (iter.hasNext()) {
            JPanel classPanel = new JPanel();
            classPanel.setOpaque(false);
            classPanel.setLayout(new BoxLayout(classPanel, 0));
            ClassForest.TreeEntry element = iter.next();
            if (isRecursiveCall) {
                if (isFirstSubclass && !iter.hasNext()) {
                    classPanel.add(new ArrowHeadEnd());
                } else if (isFirstSubclass) {
                    classPanel.add(new ArrowHead());
                } else if (!iter.hasNext()) {
                    classPanel.add(new ArrowConnectEnd());
                } else {
                    classPanel.add(new ArrowConnect());
                }
            }
            ClassView classView = element.getData();
            classPanel.add(classView);
            JPanel flowPanel = new JPanel(new FlowLayout(0, 0, 0));
            flowPanel.add(classPanel);
            flowPanel.setOpaque(false);
            hierarchyPanel.add(flowPanel);
            List<ClassForest.TreeEntry> children = element.getChildren();
            if (!children.isEmpty()) {
                JPanel childPanel = new JPanel();
                childPanel.setOpaque(false);
                childPanel.setLayout(new BoxLayout(childPanel, 0));
                JComponent child = this.createClassHierarchyComponent(children, true);
                if (iter.hasNext()) {
                    childPanel.add(new ArrowLine());
                } else if (isRecursiveCall) {
                    childPanel.add(new EmptySpace());
                }
                childPanel.add(child);
                flowPanel = new JPanel(new FlowLayout(0, 0, 0));
                flowPanel.setOpaque(false);
                flowPanel.add(childPanel);
                hierarchyPanel.add(flowPanel);
            }
            isFirstSubclass = false;
        }
        return hierarchyPanel;
    }

    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public void consolidateLayout(ClassView classView) {
        if (this.greenfootClasses != null) {
            ClassForest.TreeEntry removed = this.removeFromForest(classView);
            if (classView.getRole() instanceof ActorClassRole) {
                this.greenfootClasses.add(removed);
            } else if (classView.getRole() instanceof WorldClassRole) {
                this.worldClasses.add(removed);
            } else {
                this.otherClasses.add(removed);
            }
        }
        this.updateLayout();
    }

    public GProject getProject() {
        return this.project;
    }

    public GreenfootFrame getFrame() {
        return this.frame;
    }

    public ClassView getActorClassView() {
        return ((ClassForest.TreeEntry)this.greenfootClasses.getRoots().toArray()[0]).getData();
    }

    public ClassView getWorldClassView() {
        return ((ClassForest.TreeEntry)this.worldClasses.getRoots().toArray()[0]).getData();
    }

    public void setActions(AbstractAction ... actions) {
        JPopupMenu menu = new JPopupMenu();
        for (int i = 0; i < actions.length; ++i) {
            menu.add(new JMenuItem(actions[i]));
        }
        this.setComponentPopupMenu(menu);
    }
}

