/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.export.mygame;

import greenfoot.core.ProjectProperties;
import java.util.LinkedList;
import java.util.List;

public class ScenarioInfo {
    private String title;
    private String shortDescription;
    private String longDescription;
    private String updateDescription;
    private List<String> tags;
    private String url;
    private boolean hasSource;
    private boolean isLocked;
    private boolean isUpdate = false;
    private static final String PUBLISH_TITLE = "publish.title";
    private static final String PUBLISH_SHORT_DESC = "publish.shortDesc";
    private static final String PUBLISH_LONG_DESC = "publish.longDesc";
    private static final String PUBLISH_URL = "publish.url";
    private static final String PUBLISH_TAGS = "publish.tags";
    private static final String PUBLISH_HAS_SOURCE = "publish.hasSource";
    private static final String PUBLISH_LOCKED = "publish.locked";
    private static final String PUBLISH_UPDATE_DESC = "publish.updateDesc";

    public void setTitle(String title) {
        if (title != null) {
            this.title = title.trim();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setShortDescription(String shortDesc) {
        this.shortDescription = shortDesc;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setLongDescription(String longDesc) {
        this.longDescription = longDesc;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setHasSource(boolean hasSource) {
        this.hasSource = hasSource;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean locked) {
        this.isLocked = locked;
    }

    public boolean getHasSource() {
        return this.hasSource;
    }

    public void store(ProjectProperties properties) {
        properties.setString(PUBLISH_TITLE, this.getTitle());
        if (this.getShortDescription() != null) {
            properties.setString(PUBLISH_SHORT_DESC, this.getShortDescription());
        }
        if (this.getLongDescription() != null) {
            properties.setString(PUBLISH_LONG_DESC, this.getLongDescription());
        }
        properties.setString(PUBLISH_URL, this.getUrl());
        properties.setString(PUBLISH_TAGS, this.getTagsAsString());
        properties.setBoolean(PUBLISH_HAS_SOURCE, this.getHasSource());
        properties.setBoolean(PUBLISH_LOCKED, this.isLocked());
        if (this.getUpdateDescription() != null) {
            properties.setString(PUBLISH_UPDATE_DESC, this.getUpdateDescription());
        }
    }

    private String getTagsAsString() {
        StringBuilder tags = new StringBuilder();
        List<String> tagList = this.getTags();
        for (String tag : tagList) {
            tags.append(tag);
            tags.append(" ");
        }
        return tags.toString();
    }

    public boolean load(ProjectProperties properties) {
        if (properties.getString(PUBLISH_TITLE) == null) {
            return false;
        }
        this.setTitle(properties.getString(PUBLISH_TITLE));
        this.setShortDescription(properties.getString(PUBLISH_SHORT_DESC));
        this.setLongDescription(properties.getString(PUBLISH_LONG_DESC));
        this.setUrl(properties.getString(PUBLISH_URL));
        LinkedList<String> tagList = new LinkedList<String>();
        String tags = properties.getString(PUBLISH_TAGS);
        if (tags != null) {
            String[] tagArray = tags.split(" ");
            for (int i = 0; i < tagArray.length; ++i) {
                String string = tagArray[i];
                tagList.add(string);
            }
        }
        this.setTags(tagList);
        this.setHasSource(properties.getBoolean(PUBLISH_HAS_SOURCE, "false"));
        this.setLocked(properties.getBoolean(PUBLISH_LOCKED, "true"));
        this.setUpdateDescription(properties.getString(PUBLISH_UPDATE_DESC));
        return true;
    }

    public String getUpdateDescription() {
        return this.updateDescription;
    }

    public void setUpdateDescription(String updateDescription) {
        this.updateDescription = updateDescription;
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public void setUpdate(boolean isUpdate) {
        this.isUpdate = isUpdate;
    }
}

