/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import bluej.BlueJPropStringSource;
import bluej.Config;
import bluej.extensions.SourceType;
import bluej.utility.Debug;
import greenfoot.core.GreenfootMain;
import greenfoot.platforms.ide.GreenfootUtilDelegateIDE;
import greenfoot.util.GreenfootUtil;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.rmi.RemoteException;
import java.util.Properties;
import rmiextension.BlueJRMIClient;
import rmiextension.wrappers.RBlueJ;
import rmiextension.wrappers.RPrintStream;

public class GreenfootLauncherDebugVM {
    private static GreenfootLauncherDebugVM instance;
    private Object transportField;

    public GreenfootLauncherDebugVM(String prjDir, String rmiServiceName, final String wizard, final String sourceTypeName) {
        instance = this;
        if (BlueJRMIClient.instance() != null) {
            return;
        }
        final BlueJRMIClient client = new BlueJRMIClient(prjDir, rmiServiceName);
        final RBlueJ blueJ = client.getBlueJ();
        if (blueJ == null) {
            System.exit(1);
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    client.initialise();
                    File libdir = blueJ.getSystemLibDir();
                    Config.initializeVMside((File)libdir, (File)blueJ.getUserPrefDir(), (Properties)blueJ.getInitialCommandLineProperties(), (boolean)true, (BlueJPropStringSource)client);
                    final RPrintStream rprintStream = blueJ.getDebugPrinter();
                    Debug.setDebugStream((Writer)new Writer(){

                        @Override
                        public void write(char[] cbuf, int off, int len) throws IOException {
                            String s = new String(cbuf, off, len);
                            rprintStream.print(s);
                        }

                        @Override
                        public void flush() throws IOException {
                        }

                        @Override
                        public void close() throws IOException {
                        }
                    });
                    GreenfootUtil.initialise(GreenfootUtilDelegateIDE.getInstance());
                    GreenfootMain.initialize(blueJ, client.getPackage(), wizard.equals("true"), SourceType.getEnum((String)sourceTypeName));
                }
                catch (RemoteException re) {
                    re.printStackTrace();
                }
            }
        }.start();
    }

    public static GreenfootLauncherDebugVM getInstance() {
        return instance;
    }

    public void setTransportField(Object transportField) {
        this.transportField = transportField;
    }
}

