/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import bluej.compiler.CompileObserver;
import bluej.debugmgr.InvokerCompiler;
import bluej.extensions.CompilationNotStartedException;
import bluej.extensions.MissingJavaFileException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.extensions.SourceType;
import bluej.utility.Debug;
import greenfoot.World;
import greenfoot.core.GClass;
import greenfoot.core.GProject;
import greenfoot.core.InternalGreenfootError;
import greenfoot.core.LocalCompileObserverWrapper;
import greenfoot.util.GreenfootUtil;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import rmiextension.wrappers.RClass;
import rmiextension.wrappers.RJobQueue;
import rmiextension.wrappers.RPackage;

public class GPackage {
    private RPackage pkg;
    private GProject project;
    private Map<RClass, GClass> classPool = new HashMap<RClass, GClass>();

    GPackage(GProject project) {
        if (project == null) {
            throw new NullPointerException("Project must not be null.");
        }
        this.project = project;
    }

    public GPackage(RPackage pkg, GProject project) {
        if (pkg == null) {
            throw new NullPointerException("Pkg must not be null.");
        }
        if (project == null) {
            throw new NullPointerException("Project must not be null.");
        }
        this.pkg = pkg;
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GClass getGClass(RClass remoteClass, boolean inRemoteCallback) {
        GClass gClass;
        if (remoteClass == null) {
            return null;
        }
        Map<RClass, GClass> map = this.classPool;
        synchronized (map) {
            gClass = this.classPool.get(remoteClass);
            if (gClass == null) {
                gClass = new GClass(remoteClass, this, inRemoteCallback);
                this.classPool.put(remoteClass, gClass);
                gClass.loadSavedSuperClass(inRemoteCallback);
            }
        }
        return gClass;
    }

    public void compileAll() {
        try {
            this.pkg.compileAll();
        }
        catch (ProjectNotOpenException pnoe) {
            Debug.reportError((String)"Could not start compilation", (Throwable)pnoe);
        }
        catch (CompilationNotStartedException cnse) {
            Debug.reportError((String)"Could not start compilation", (Throwable)cnse);
        }
        catch (RemoteException re) {
            Debug.reportError((String)"Could not start compilation", (Throwable)re);
        }
        catch (PackageNotFoundException pnfe) {
            Debug.reportError((String)"Could not start compilation", (Throwable)pnfe);
        }
    }

    public File getDir() {
        try {
            return this.pkg.getDir();
        }
        catch (ProjectNotOpenException pnoe) {
            Debug.reportError((String)"Could not get package directory", (Throwable)pnoe);
            throw new InternalGreenfootError(pnoe);
        }
        catch (PackageNotFoundException pnfe) {
            Debug.reportError((String)"Could not get package directory", (Throwable)pnfe);
            throw new InternalGreenfootError(pnfe);
        }
        catch (RemoteException re) {
            Debug.reportError((String)"Could not get package directory", (Throwable)re);
            throw new InternalGreenfootError(re);
        }
    }

    public GProject getProject() {
        return this.project;
    }

    public GClass[] getClasses(boolean inRemoteCallback) {
        try {
            RClass[] rClasses = this.pkg.getRClasses();
            GClass[] gClasses = new GClass[rClasses.length];
            for (int i = 0; i < rClasses.length; ++i) {
                RClass rClass = rClasses[i];
                gClasses[i] = this.getGClass(rClass, inRemoteCallback);
            }
            return gClasses;
        }
        catch (ProjectNotOpenException e) {
            Debug.reportError((String)"Could not get package classes", (Throwable)e);
            throw new InternalGreenfootError(e);
        }
        catch (PackageNotFoundException e) {
            Debug.reportError((String)"Could not get package classes", (Throwable)e);
            throw new InternalGreenfootError(e);
        }
        catch (RemoteException e) {
            Debug.reportError((String)"Could not get package classes", (Throwable)e);
            throw new InternalGreenfootError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GClass newClass(String className, String extension, boolean inRemoteCallback) {
        GClass newClass = null;
        try {
            RClass newRClass = this.pkg.newClass(className, extension);
            newClass = new GClass(newRClass, this, inRemoteCallback);
            Map<RClass, GClass> map = this.classPool;
            synchronized (map) {
                this.classPool.put(newRClass, newClass);
            }
            newClass.loadSavedSuperClass(false);
        }
        catch (RemoteException re) {
            Debug.reportError((String)"Creating new class", (Throwable)re);
        }
        catch (ProjectNotOpenException pnoe) {
            Debug.reportError((String)"Creating new class", (Throwable)pnoe);
        }
        catch (PackageNotFoundException pnfe) {
            Debug.reportError((String)"Creating new class", (Throwable)pnfe);
        }
        catch (MissingJavaFileException mjfe) {
            Debug.reportError((String)"Creating new class", (Throwable)mjfe);
        }
        return newClass;
    }

    public GClass getClass(String className) {
        try {
            RClass rClass = this.pkg.getRClass(className);
            return this.getGClass(rClass, false);
        }
        catch (RemoteException re) {
            Debug.reportError((String)"Getting class", (Throwable)re);
        }
        catch (ProjectNotOpenException pnoe) {
            Debug.reportError((String)"Creating new class", (Throwable)pnoe);
        }
        catch (PackageNotFoundException pnfe) {
            Debug.reportError((String)"Creating new class", (Throwable)pnfe);
        }
        return null;
    }

    public List<Class<? extends World>> getWorldClasses() {
        LinkedList<Class<? extends World>> worldClasses = new LinkedList<Class<? extends World>>();
        GClass[] classes = this.getClasses(false);
        for (int i = 0; i < classes.length; ++i) {
            Class<?> realClass;
            GClass cls = classes[i];
            if (!cls.isWorldSubclass() || !GreenfootUtil.canBeInstantiated(realClass = cls.getJavaClass())) continue;
            worldClasses.add(realClass);
        }
        return worldClasses;
    }

    public InvokerCompiler getCompiler() {
        try {
            final RJobQueue rqueue = this.pkg.getCompiler();
            return new InvokerCompiler(){

                public void compile(File[] files, CompileObserver observer) {
                    try {
                        rqueue.compile(files, new LocalCompileObserverWrapper(observer));
                    }
                    catch (RemoteException re) {
                        Debug.reportError((String)"Error trying to compile on remote queue", (Throwable)re);
                    }
                }
            };
        }
        catch (RemoteException re) {
            Debug.reportError((String)"Error getting remote compiler queue", (Throwable)re);
            return null;
        }
    }

    public void reload() {
        try {
            this.pkg.reload();
        }
        catch (ProjectNotOpenException e) {
            e.printStackTrace();
        }
        catch (PackageNotFoundException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public SourceType getDefaultSourceType() {
        if (Arrays.asList(this.getClasses(false)).stream().anyMatch(c -> c.getSourceType() == SourceType.Stride)) {
            return SourceType.Stride;
        }
        return SourceType.Java;
    }
}

