/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.actions;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.EscapeDialog;
import greenfoot.core.GProject;
import greenfoot.gui.GreenfootFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PasteImageAction
extends AbstractAction {
    private final GreenfootFrame gfFrame;

    public PasteImageAction(GreenfootFrame gfFrame) {
        super(Config.getString((String)"paste.image"));
        this.setEnabled(false);
        this.gfFrame = gfFrame;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PasteImageAction.pasteImage(this.gfFrame, this.gfFrame.getProject());
    }

    public static boolean pasteImage(Frame parent, GProject project) {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            try {
                Image img = (Image)transferable.getTransferData(DataFlavor.imageFlavor);
                BufferedImage buffered = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
                Graphics2D g = buffered.createGraphics();
                g.drawImage(img, 0, 0, null);
                g.dispose();
                NameDialog dlg = new NameDialog(parent, buffered);
                dlg.setModal(true);
                DialogManager.centreDialog((JDialog)((Object)dlg));
                dlg.setVisible(true);
                if (dlg.getFileName() != null) {
                    ImageIO.write((RenderedImage)buffered, "png", new File(project.getImageDir(), dlg.getFileName() + ".png"));
                    return true;
                }
            }
            catch (UnsupportedFlavorException | IOException ex) {
                Debug.reportError((Throwable)ex);
            }
        } else {
            DialogManager.showMessage((Component)parent, (String)"no-clipboard-image-data");
        }
        return false;
    }

    private static class NameDialog
    extends EscapeDialog {
        private String fileName = null;

        public NameDialog(Frame parent, BufferedImage img) {
            super(parent, Config.getString((String)"editor.paste.image.title"), true);
            this.makeDialog(img);
        }

        private void makeDialog(BufferedImage img) {
            JPanel bodyPanel = new JPanel();
            bodyPanel.setLayout(new BorderLayout());
            bodyPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
            bodyPanel.add((Component)new JLabel(new ImageIcon(img)), "North");
            JPanel fileNameRow = new JPanel();
            fileNameRow.setLayout(new BoxLayout(fileNameRow, 0));
            fileNameRow.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
            JTextField fileNameField = new JTextField();
            fileNameField.setHorizontalAlignment(4);
            fileNameRow.add(new JLabel(Config.getString((String)"editor.paste.image.prompt")));
            fileNameRow.add(fileNameField);
            fileNameRow.add(new JLabel(".png"));
            bodyPanel.add((Component)fileNameRow, "Center");
            JPanel buttonPanel = new JPanel(new FlowLayout(2));
            buttonPanel.setAlignmentX(0.0f);
            JButton okButton = BlueJTheme.getOkButton();
            okButton.addActionListener(e -> {
                this.fileName = fileNameField.getText();
                this.setVisible(false);
            });
            JButton cancelButton = BlueJTheme.getCancelButton();
            cancelButton.addActionListener(e -> this.setVisible(false));
            buttonPanel.add(okButton);
            buttonPanel.add(cancelButton);
            this.getRootPane().setDefaultButton(okButton);
            bodyPanel.add((Component)buttonPanel, "South");
            this.getContentPane().add((Component)bodyPanel, "Center");
            this.pack();
            fileNameField.requestFocusInWindow();
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

