/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.actions;

import bluej.Config;
import bluej.extensions.SourceType;
import bluej.utility.DialogManager;
import greenfoot.actions.SelectImageAction;
import greenfoot.core.GClass;
import greenfoot.core.GPackage;
import greenfoot.gui.NewClassDialog;
import greenfoot.gui.classbrowser.ClassBrowser;
import greenfoot.gui.classbrowser.ClassView;
import greenfoot.gui.classbrowser.role.ImageClassRole;
import greenfoot.gui.images.ImageLibFrame;
import greenfoot.record.InteractionListener;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class NewSubclassAction
extends AbstractAction {
    protected ClassView superclass;
    protected ClassBrowser classBrowser;
    protected InteractionListener interactionListener;

    public NewSubclassAction(ClassView view, ClassBrowser classBrowser, InteractionListener interactionListener) {
        this();
        this.superclass = view;
        this.classBrowser = classBrowser;
        this.interactionListener = interactionListener;
    }

    protected NewSubclassAction() {
        super(Config.getString((String)"new.sub.class"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GClass superG = this.superclass.getGClass();
        boolean imageClass = superG.isActorClass() || superG.isActorSubclass();
        if (imageClass |= superG.isWorldClass() || superG.isWorldSubclass()) {
            this.createImageClass(Config.getString((String)"imagelib.newClass"), null, null);
        } else {
            this.createNonActorClass();
        }
    }

    public void createImageClass(String title, String defaultName, List<String> description) {
        JFrame f = (JFrame)SwingUtilities.getWindowAncestor(this.classBrowser);
        ImageLibFrame dialog = new ImageLibFrame(f, this.superclass.getGClass(), title, defaultName, description);
        DialogManager.centreDialog((JDialog)((Object)dialog));
        dialog.setVisible(true);
        if (dialog.getResult() != 0) {
            return;
        }
        ClassView classView = this.createClassSilently(dialog.getClassName(), dialog.getSelectedLanguage());
        if (classView != null) {
            SelectImageAction.setClassImage(classView, (ImageClassRole)classView.getRole(), dialog.getSelectedImageFile());
        }
    }

    public void createNonActorClass() {
        JFrame f = (JFrame)SwingUtilities.getWindowAncestor(this.classBrowser);
        GPackage pkg = this.classBrowser.getProject().getDefaultPackage();
        NewClassDialog dialog = new NewClassDialog(f, pkg);
        dialog.setVisible(true);
        if (!dialog.okPressed()) {
            return;
        }
        this.createClassSilently(dialog.getClassName(), dialog.getSelectedLanguage());
    }

    public ClassView createClassSilently(String className, SourceType selectedLanguage) {
        ClassView classView = null;
        GClass gClass = this.superclass.createSubclass(className, selectedLanguage);
        if (gClass != null) {
            classView = new ClassView(this.classBrowser, gClass, this.interactionListener);
            this.classBrowser.addClass(classView);
        }
        return classView;
    }
}

