/*
 * Decompiled with CFR 0.152.
 */
package greenfoot;

import greenfoot.GreenfootImage;
import greenfoot.util.GreenfootUtil;
import java.util.List;

public class UserInfo {
    public static final int NUM_INTS = 10;
    public static final int NUM_STRINGS = 5;
    public static final int STRING_LENGTH_LIMIT = 50;
    private int[] ints;
    private String[] strings;
    private String userName;
    private int score;
    private int rank;

    UserInfo(String userName, int rank) {
        this.userName = userName;
        this.rank = rank;
        this.score = 0;
        this.ints = new int[10];
        this.strings = new String[5];
    }

    void setRank(int n) {
        this.rank = n;
    }

    public String getUserName() {
        return this.userName;
    }

    public int getInt(int index) {
        return this.ints[index];
    }

    public String getString(int index) {
        return this.strings[index] == null ? "" : this.strings[index];
    }

    public void setInt(int index, int value) {
        this.ints[index] = value;
    }

    public void setString(int index, String value) {
        if (value != null && value.length() > 50) {
            System.err.println("Error: tried to store a String of length " + value.length() + " in UserInfo, which is longer than UserInfo.STRING_LENGTH_LIMIT (" + 50 + ")");
        } else {
            this.strings[index] = value;
        }
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public int getRank() {
        return this.rank;
    }

    public static boolean isStorageAvailable() {
        return GreenfootUtil.isStorageSupported();
    }

    public static UserInfo getMyInfo() {
        return GreenfootUtil.getCurrentUserInfo();
    }

    public boolean store() {
        boolean success = GreenfootUtil.storeCurrentUserInfo(this);
        if (success) {
            this.rank = UserInfo.getMyInfo().rank;
        }
        return success;
    }

    public static List getTop(int maxAmount) {
        return GreenfootUtil.getTopUserInfo(maxAmount);
    }

    public static List getNearby(int maxAmount) {
        return GreenfootUtil.getNearbyUserData(maxAmount);
    }

    public GreenfootImage getUserImage() {
        return GreenfootUtil.getUserImage(this.userName);
    }
}

