/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.application.snapshot;

import com.sun.tools.visualvm.application.snapshot.ApplicationSnapshotsSupport;
import com.sun.tools.visualvm.core.ui.components.Spacer;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

class ApplicationSnapshotConfigurator
extends JPanel {
    private static ApplicationSnapshotConfigurator defaultInstance;
    private JLabel snapshotFileLabel;
    private JTextField snapshotFileField;
    private JButton snapshotFileButton;
    private JCheckBox deleteSourceCheckbox;
    private JButton okButton;

    static ApplicationSnapshotConfigurator defineSnapshot() {
        ApplicationSnapshotConfigurator hc = ApplicationSnapshotConfigurator.getDefault();
        hc.setupDefineCoreDump();
        DialogDescriptor dd = new DialogDescriptor((Object)hc, NbBundle.getMessage(ApplicationSnapshotConfigurator.class, (String)"Title_Add_Application_Snapshot"), true, new Object[]{hc.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)hc.okButton, 0, null, null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.pack();
        d.setVisible(true);
        if (dd.getValue() == hc.okButton) {
            return hc;
        }
        return null;
    }

    File getSnapshotFile() {
        return new File(this.snapshotFileField.getText().trim());
    }

    boolean deleteSourceFile() {
        return this.deleteSourceCheckbox.isSelected();
    }

    private ApplicationSnapshotConfigurator() {
        this.initComponents();
        this.update();
    }

    private static ApplicationSnapshotConfigurator getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ApplicationSnapshotConfigurator();
        }
        return defaultInstance;
    }

    private void setupDefineCoreDump() {
        this.snapshotFileField.setText("");
        this.deleteSourceCheckbox.setSelected(false);
    }

    private void update() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                File snapshotFile = ApplicationSnapshotConfigurator.this.getSnapshotFile();
                ApplicationSnapshotConfigurator.this.okButton.setEnabled(ApplicationSnapshotsSupport.getInstance().getApplicationSnapshotCategory().isSnapshotArchive(snapshotFile));
            }
        });
    }

    private void chooseSnapshot() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(NbBundle.getMessage(ApplicationSnapshotConfigurator.class, (String)"LBL_Select_Application_Snapshot"));
        chooser.setSelectedFile(this.getSnapshotFile());
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(ApplicationSnapshotsSupport.getInstance().getCategory().getFileFilter());
        if (chooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) == 0) {
            this.snapshotFileField.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.snapshotFileLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.snapshotFileLabel, (String)NbBundle.getMessage(ApplicationSnapshotConfigurator.class, (String)"LBL_Snapshot_file"));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(15, 10, 0, 0);
        this.add((Component)this.snapshotFileLabel, constraints);
        this.snapshotFileField = new JTextField();
        this.snapshotFileLabel.setLabelFor(this.snapshotFileField);
        this.snapshotFileField.setPreferredSize(new Dimension(220, this.snapshotFileField.getPreferredSize().height));
        this.snapshotFileField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ApplicationSnapshotConfigurator.this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                ApplicationSnapshotConfigurator.this.update();
            }

            public void changedUpdate(DocumentEvent e) {
                ApplicationSnapshotConfigurator.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 5, 0, 0);
        this.add((Component)this.snapshotFileField, constraints);
        this.snapshotFileButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.snapshotFileButton, (String)NbBundle.getMessage(ApplicationSnapshotConfigurator.class, (String)"LBL_Browse"));
        this.snapshotFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ApplicationSnapshotConfigurator.this.chooseSnapshot();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 5, 0, 10);
        this.add((Component)this.snapshotFileButton, constraints);
        this.deleteSourceCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.deleteSourceCheckbox, (String)NbBundle.getMessage(ApplicationSnapshotConfigurator.class, (String)"LBL_Delete_source_file"));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(18, 10, 0, 0);
        this.add((Component)this.deleteSourceCheckbox, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)Spacer.create(), constraints);
        this.okButton = new JButton(NbBundle.getMessage(ApplicationSnapshotConfigurator.class, (String)"LBL_OK"));
        this.deleteSourceCheckbox.setBorder(this.snapshotFileLabel.getBorder());
    }
}

