/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.model.fields;

public enum ByteUnit {
    BYTES(0, "b", "byte", "bytes"),
    KB(10, "kb", "kilobyte", "kilobytes"),
    MB(20, "Mb", "megabyte", "megabytes"),
    GB(30, "Gb", "gigabyte", "gigabytes"),
    TB(40, "Tb", "terabyte", "terabytes");

    private final String[] m_representations;
    private final long m_factor;

    private ByteUnit(int logFactor, String ... representations) {
        this.m_representations = representations;
        this.m_factor = logFactor == 0 ? 1 : 2 << logFactor - 1;
    }

    public long getFactor() {
        return this.m_factor;
    }

    public String[] getRepresentations() {
        return this.m_representations;
    }

    public static ByteUnit valueOfString(String text) {
        ByteUnit[] byteUnitArray = ByteUnit.values();
        int n = byteUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            ByteUnit bu = byteUnitArray[n2];
            String[] stringArray = bu.getRepresentations();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String representation = stringArray[n4];
                if (representation.equalsIgnoreCase(text)) {
                    return bu;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }
}

