/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.handlers;

import com.jrockit.mc.ui.UIPlugin;
import java.util.logging.Level;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;

public class CommandAction
extends Action {
    public CommandAction(String commandId) {
        CommandAction.setActionCommand((IAction)this, commandId);
    }

    public static void setActionCommand(IAction a, String commandId) {
        try {
            a.setActionDefinitionId(commandId);
            IWorkbench sl = PlatformUI.getWorkbench();
            ICommandImageService is = (ICommandImageService)sl.getService(ICommandImageService.class);
            ICommandService cs = (ICommandService)sl.getService(ICommandService.class);
            Command command = cs.getCommand(commandId);
            a.setText(command.getName());
            a.setDescription(command.getDescription());
            a.setImageDescriptor(is.getImageDescriptor(commandId, 0));
            a.setDisabledImageDescriptor(is.getImageDescriptor(commandId, 1));
            a.setHoverImageDescriptor(is.getImageDescriptor(commandId, 2));
        }
        catch (RuntimeException e) {
            a.setText(commandId);
            UIPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not create CommandAction for " + commandId, e);
        }
        catch (NotDefinedException e) {
            a.setText(commandId);
            UIPlugin.getDefault().getLogger().log(Level.SEVERE, String.valueOf(commandId) + " not defined", e);
        }
    }
}

